/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cns.basicreg.wizard.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;

public abstract class CursorUtils {
    private static final Cursor BUSY_CURSOR = new Cursor(3);
    private static final Cursor DEFAULT_CURSOR = new Cursor(0);
    private static final int DELAY = 250;
    private static final Logger LOG = Logger.getLogger(CursorUtils.class.getName());

    public static ActionListener createBusyCursorActionListener(final Component component, final ActionListener theActionListener) {
        ActionListener actionListener = new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                TimerTask busyCursorTimerTask = new TimerTask(){

                    public void run() {
                        LOG.info(" **** SET CURSOR BUSY ON: " + component.toString());
                        component.setCursor(BUSY_CURSOR);
                    }
                };
                Timer timer = new Timer();
                try {
                    timer.schedule(busyCursorTimerTask, 250L);
                    theActionListener.actionPerformed(actionEvent);
                }
                finally {
                    timer.cancel();
                    component.setCursor(DEFAULT_CURSOR);
                }
            }
        };
        return actionListener;
    }

    public static void setComponentBusyCursor(Component component) {
        component.setCursor(BUSY_CURSOR);
    }

    public static void setComponentDefaultCursor(Component component) {
        component.setCursor(DEFAULT_CURSOR);
    }

    public static void setHierarchyBusyCursor(Component component) {
        CursorUtils.setCursorForComponentHierarchy(BUSY_CURSOR, component);
    }

    public static void setHierarchyDefaultCursor(Component component) {
        CursorUtils.setCursorForComponentHierarchy(DEFAULT_CURSOR, component);
    }

    private static void setCursorForComponentHierarchy(Cursor cursor, Component component) {
        if (component == null) {
            return;
        }
        component.setCursor(cursor);
        for (Container parentContainer = component.getParent(); parentContainer != null; parentContainer = parentContainer.getParent()) {
            if (!(parentContainer instanceof Window)) continue;
            parentContainer.setCursor(cursor);
        }
    }
}

