/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cns.basicreg.wizard.swing;

import com.sun.cns.basicreg.wizard.swing.CustomField;
import com.sun.cns.basicreg.wizard.swing.NavigationProvider;
import com.sun.cns.basicreg.wizard.swing.PopupDialog;
import com.sun.cns.basicreg.wizard.swing.Utils;
import com.sun.cns.basicreg.wizard.util.I18N;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;

public class JumpButton
extends JButton
implements CustomField {
    private static final Font JUMP_FONT = new Font("SansSerif", 0, 12);
    private static final String BEGIN_LINK_HTML = "<html><u>";
    private static final String END_LINK_HTML = "</u>";
    private static final String BEGIN_BUTTON_HTML = "<html>";
    private static final String END_BUTTON_HTML = "";
    private static final String GO_ON_INDICATOR = " >></html>";
    private NavigationProvider navigationProvider;
    private JDialog parentDialog;
    private int jumpToIndex;
    private static final Logger LOG = Logger.getLogger(JumpButton.class.getName());

    public JumpButton(String label, NavigationProvider navigationProvider, JDialog parentDialog, int jumpToIndex, boolean showButton, boolean editable, String mnemonic) {
        super(showButton ? BEGIN_BUTTON_HTML + Utils.breakString(label) + END_BUTTON_HTML + GO_ON_INDICATOR : BEGIN_LINK_HTML + Utils.breakString(label) + END_LINK_HTML + GO_ON_INDICATOR);
        if (!showButton) {
            this.setContentAreaFilled(false);
            this.setBorder(BorderFactory.createLineBorder(Color.black));
            this.setBorderPainted(false);
            this.setFocusPainted(false);
            this.addFocusListener(new JumpButtonFocusListener());
            this.addMouseListener(new JumpButtonMouseListener());
            this.setForeground(Color.blue);
        }
        this.setFont(JUMP_FONT);
        this.setMaximumSize(this.getPreferredSize());
        this.addActionListener(new JumpButtonActionListener());
        this.navigationProvider = navigationProvider;
        this.parentDialog = parentDialog;
        this.jumpToIndex = jumpToIndex;
        this.setFieldEditable(editable);
        if (mnemonic != null && I18N.isLocalLanguageEnglish()) {
            LOG.info(" Set Mnemonic Key --" + mnemonic);
            this.setMnemonic(Integer.parseInt(mnemonic.trim()));
        }
    }

    public String getValue() {
        return null;
    }

    public void setValue(String valueString) {
    }

    public boolean isFieldEditable() {
        return this.isEnabled();
    }

    public void setFieldEditable(boolean editable) {
        this.setEnabled(editable);
        this.setFocusable(editable);
    }

    public boolean hasErrorSupport() {
        return false;
    }

    class JumpButtonMouseListener
    extends MouseAdapter {
        JumpButtonMouseListener() {
        }

        public void mouseEntered(MouseEvent evt) {
            JumpButton.this.setCursor(Cursor.getPredefinedCursor(12));
        }

        public void mouseExited(MouseEvent evt) {
            JumpButton.this.setCursor(Cursor.getDefaultCursor());
        }
    }

    class JumpButtonFocusListener
    implements FocusListener {
        JumpButtonFocusListener() {
        }

        public void focusGained(FocusEvent evt) {
            JumpButton.this.setFocusPainted(true);
        }

        public void focusLost(FocusEvent evt) {
            JumpButton.this.setFocusPainted(false);
        }
    }

    class JumpButtonActionListener
    implements ActionListener {
        JumpButtonActionListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            LOG.info("JUMP BUTTON ACTION LISTENER");
            if (JumpButton.this.parentDialog instanceof PopupDialog && ((PopupDialog)JumpButton.this.parentDialog).isNetworkErrorPopup()) {
                LOG.info("DISMISS NETWORK ERROR POPUP");
                ((PopupDialog)JumpButton.this.parentDialog).setVisible(false);
            }
            JumpButton.this.navigationProvider.navigateToIndex(JumpButton.this.jumpToIndex);
        }
    }
}

