/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cns.basicreg.wizard.swing;

import com.sun.cns.basicreg.wizard.swing.CustomField;
import com.sun.cns.basicreg.wizard.swing.NavigationProvider;
import com.sun.cns.basicreg.wizard.swing.Utils;
import com.sun.cns.basicreg.wizard.util.I18N;
import com.sun.cns.basicreg.wizard.util.Web;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JOptionPane;

public class LinkButton
extends JButton
implements CustomField {
    private static final Font LINK_FONT = new Font("SansSerif", 0, 12);
    private static final String BEGIN_LINK_HTML = "<html><u>";
    private static final String END_LINK_HTML = "</u>";
    private static final String BEGIN_BUTTON_HTML = "<html>";
    private static final String END_BUTTON_HTML = "";
    private static final String GO_ON_INDICATOR = "</html>";
    private NavigationProvider navigationProvider;
    private String urlString;
    private boolean endsWizard = false;
    private static final Logger LOG = Logger.getLogger(LinkButton.class.getName());

    public LinkButton(String label, NavigationProvider navigationProvider, String urlString, boolean showButton, boolean endsWizard, boolean editable, String mnemonic) {
        super(showButton ? BEGIN_BUTTON_HTML + Utils.breakString(label) + END_BUTTON_HTML + GO_ON_INDICATOR : BEGIN_LINK_HTML + Utils.breakString(label) + END_LINK_HTML + GO_ON_INDICATOR);
        if (!showButton) {
            this.setContentAreaFilled(false);
            this.setBorder(BorderFactory.createLineBorder(Color.black));
            this.setBorderPainted(false);
            this.setFocusPainted(false);
            this.addFocusListener(new LinkButtonFocusListener());
            this.addMouseListener(new LinkButtonMouseListener());
            this.setForeground(Color.blue);
        }
        this.setFont(LINK_FONT);
        this.setMaximumSize(this.getPreferredSize());
        this.addActionListener(new LinkButtonActionListener());
        this.navigationProvider = navigationProvider;
        this.urlString = urlString;
        this.endsWizard = endsWizard;
        this.setFieldEditable(editable);
        if (mnemonic != null && I18N.isLocalLanguageEnglish()) {
            LOG.info("Mnemonic is set to --" + mnemonic);
            this.setMnemonic(Integer.parseInt(mnemonic.trim()));
        }
    }

    public String getValue() {
        return null;
    }

    public void setValue(String valueString) {
    }

    public boolean isFieldEditable() {
        return this.isEnabled();
    }

    public void setFieldEditable(boolean editable) {
        this.setEnabled(editable);
        this.setFocusable(editable);
    }

    public boolean hasErrorSupport() {
        return false;
    }

    class LinkButtonMouseListener
    extends MouseAdapter {
        LinkButtonMouseListener() {
        }

        public void mouseEntered(MouseEvent evt) {
            LinkButton.this.setCursor(Cursor.getPredefinedCursor(12));
        }

        public void mouseExited(MouseEvent evt) {
            LinkButton.this.setCursor(Cursor.getDefaultCursor());
        }
    }

    class LinkButtonFocusListener
    implements FocusListener {
        LinkButtonFocusListener() {
        }

        public void focusGained(FocusEvent evt) {
            LinkButton.this.setFocusPainted(true);
        }

        public void focusLost(FocusEvent evt) {
            LinkButton.this.setFocusPainted(false);
        }
    }

    class LinkButtonActionListener
    implements ActionListener {
        LinkButtonActionListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            LOG.info("LINK BUTTON ACTION LISTENER: " + LinkButton.this.urlString);
            if (!Web.execURL(LinkButton.this.urlString)) {
                JOptionPane.showMessageDialog(LinkButton.this, I18N.getString("browser.error.dialog.message"), I18N.getString("browser.error.dialog.title"), 0);
            }
            if (LinkButton.this.endsWizard) {
                LinkButton.this.navigationProvider.closeWizard();
            }
        }
    }
}

