/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cns.basicreg.wizard.swing;

import com.sun.cns.basicreg.common.CommonUtil;
import com.sun.cns.basicreg.wizard.ComboBoxWidget;
import com.sun.cns.basicreg.wizard.Form;
import com.sun.cns.basicreg.wizard.JumpWidget;
import com.sun.cns.basicreg.wizard.LinkWidget;
import com.sun.cns.basicreg.wizard.RadioBoxWidget;
import com.sun.cns.basicreg.wizard.ResponseWidget;
import com.sun.cns.basicreg.wizard.SelectWidget;
import com.sun.cns.basicreg.wizard.TextAreaWidget;
import com.sun.cns.basicreg.wizard.TextIconLabelWidget;
import com.sun.cns.basicreg.wizard.TextWidget;
import com.sun.cns.basicreg.wizard.Widget;
import com.sun.cns.basicreg.wizard.WidgetType;
import com.sun.cns.basicreg.wizard.Wizard;
import com.sun.cns.basicreg.wizard.swing.CursorUtils;
import com.sun.cns.basicreg.wizard.swing.Field;
import com.sun.cns.basicreg.wizard.swing.FormPanel;
import com.sun.cns.basicreg.wizard.swing.GatherDialog;
import com.sun.cns.basicreg.wizard.swing.JumpButton;
import com.sun.cns.basicreg.wizard.swing.LinkButton;
import com.sun.cns.basicreg.wizard.swing.NavigationListener;
import com.sun.cns.basicreg.wizard.swing.NavigationProvider;
import com.sun.cns.basicreg.wizard.swing.SwingWorker;
import com.sun.cns.basicreg.wizard.swing.Utils;
import com.sun.cns.basicreg.wizard.util.I18N;
import com.sun.cns.basicreg.wizard.util.ResponseError;
import com.sun.cns.basicreg.wizard.util.Validation;
import com.sun.cns.basicreg.wizard.util.VariableMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class WizardPanel
extends JPanel
implements NavigationListener {
    private JDialog parentDialog;
    private Wizard wizard;
    private NavigationProvider navigationProvider;
    private Form form;
    private int formIndex;
    private JLabel titleLabel;
    private FormPanel formPanel;
    private Field[] fields;
    private ResponseError outputResult;
    private static final String CACAO_LOGIN_ACCOUNT_ERROR_TITLE = I18N.getString("cacao.login.account.error.title");
    private static final String CACAO_LOGIN_ACCOUNT_ERROR_MESSAGE = I18N.getString("cacao.login.account.error.message");
    private static final String CACAO_LOGIN_GROUP_ERROR_TITLE = I18N.getString("cacao.login.group.error.title");
    private static final String CACAO_LOGIN_GROUP_ERROR_MESSAGE = I18N.getString("cacao.login.group.error.message");
    private int informationWidgetIndex = -1;
    private static final Font TITLE_FONT = new Font("SansSerif", 1, 14);
    private static final Logger LOG = Logger.getLogger(WizardPanel.class.getName());
    private static final String YES_STR = "yes";
    private static final String NO_STR = "no";

    public WizardPanel() {
    }

    public WizardPanel(JDialog parentDialog, Wizard wizard, Form form, int formIndex, NavigationProvider navigationProvider) {
        this.parentDialog = parentDialog;
        this.wizard = wizard;
        this.form = form;
        this.formIndex = formIndex;
        this.navigationProvider = navigationProvider;
        this.getAccessibleContext().setAccessibleName(form.getTitle());
        this.getAccessibleContext().setAccessibleDescription(form.getTitle());
        this.buildMe();
    }

    private void buildMe() {
        this.setLayout(new BorderLayout());
        JPanel titlePanel = new JPanel();
        titlePanel.setLayout(new BoxLayout(titlePanel, 1));
        titlePanel.add(Box.createVerticalStrut(4));
        this.titleLabel = new JLabel();
        this.setFormTitleText(this.form.getTitle());
        this.titleLabel.setFont(TITLE_FONT);
        this.titleLabel.setAlignmentX(0.0f);
        titlePanel.add(this.titleLabel);
        titlePanel.add(Box.createVerticalStrut(4));
        JSeparator separator = new JSeparator();
        separator.setAlignmentX(0.0f);
        titlePanel.add(Box.createVerticalStrut(4));
        titlePanel.add(separator);
        titlePanel.add(Box.createVerticalStrut(4));
        this.add((Component)titlePanel, "North");
        List widgetList = this.form.getWidgets();
        int numberWidgets = widgetList == null ? 0 : widgetList.size();
        this.fields = new Field[numberWidgets];
        JComponent[] customFields = new JComponent[numberWidgets];
        if (widgetList != null && numberWidgets > 0) {
            for (int i = 0; i < numberWidgets; ++i) {
                this.fields[i] = new Field();
                Widget widget = (Widget)widgetList.get(i);
                this.fields[i].setId(widget.getId());
                this.fields[i].setSubnote(widget.getNote());
                this.fields[i].setPrenote(null);
                this.fields[i].setLabel(widget.getText());
                this.fields[i].setIsRequired(widget.isRequired());
                this.fields[i].setValidPattern(widget.getValidPattern());
                this.fields[i].setIsScrollable(widget.isScrollable());
                this.fields[i].setIsContinueCheck(false);
                this.fields[i].setIsVertical(false);
                this.fields[i].setFontFamily(null);
                this.fields[i].setFontStyle(widget.getFontStyle());
                this.fields[i].setFontSize(widget.getFontSize());
                this.fields[i].setFontColor(widget.getFontColor());
                this.fields[i].setLabelIconFilename(null);
                this.fields[i].setLabelIconDescription(null);
                this.fields[i].setLabelIconHorizontalTextPosition(null);
                this.fields[i].setLabelIconVerticalTextPosition(null);
                this.fields[i].setSlaveId(null);
                this.fields[i].setSlaveValue(null);
                this.fields[i].setSetVarListIfSelected(null);
                this.fields[i].setSetVarListIfDeselected(null);
                this.fields[i].setIsNewRow(widget.isNewRow());
                this.fields[i].setLeftAt(widget.getLeftAt());
                this.fields[i].setRightTo(widget.getRightTo());
                this.fields[i].setPopulation(null);
                this.fields[i].setInitialValue(widget.getDefaultValue());
                this.fields[i].setIsEditable(widget.isEditable());
                this.fields[i].setToolTip(widget.getToolTip());
                this.fields[i].setIsDisplayed(widget.getIsDisplayed());
                this.fields[i].sets508Name(widget.gets508Name());
                this.fields[i].sets508Desc(widget.gets508Desc());
                this.fields[i].setMnemonic(widget.getMnemonic());
                customFields[i] = null;
                WidgetType widgetType = widget.getType();
                if (widgetType == WidgetType.FIELD) {
                    this.fields[i].setType(1);
                    this.fields[i].setLength(((TextWidget)widget).getSize());
                    continue;
                }
                if (widgetType == WidgetType.PASSWORD) {
                    this.fields[i].setType(4);
                    this.fields[i].setLength(((TextWidget)widget).getSize());
                    continue;
                }
                if (widgetType == WidgetType.TEXTICONLABEL) {
                    this.fields[i].setType(7);
                    this.fields[i].setLabel(null);
                    this.fields[i].setLabelIconFilename(((TextIconLabelWidget)((Object)widget)).getLabelIconFilename());
                    this.fields[i].setLabelIconDescription(((TextIconLabelWidget)((Object)widget)).getLabelIconDescription());
                    this.fields[i].setLabelIconHorizontalTextPosition(((TextIconLabelWidget)((Object)widget)).getHorizontalTextPosition());
                    this.fields[i].setLabelIconVerticalTextPosition(((TextIconLabelWidget)((Object)widget)).getVerticalTextPosition());
                    this.fields[i].setInitialValue(widget.getText());
                    continue;
                }
                if (widgetType == WidgetType.MESSAGE) {
                    String confirmSystemMessage;
                    this.fields[i].setType(6);
                    this.fields[i].setLabel(null);
                    this.fields[i].setNumberColumns(((TextAreaWidget)widget).getColumns());
                    this.fields[i].setNumberRows(((TextAreaWidget)widget).getRows());
                    this.fields[i].setInitialValue(widget.getText());
                    String fieldId = this.fields[i].getId();
                    if (fieldId == null || !fieldId.equals("SWUPConfirmSystem") && !fieldId.equals("UMConfirmSystem") && !fieldId.equals("SolarisConfirmSystem") && !fieldId.equals("EnablePortalConfirmSystem") && !fieldId.equals("UpdateManagerConfirmSystem") || (confirmSystemMessage = this.getConfirmSystemMessage(fieldId)) == null) continue;
                    this.fields[i].setInitialValue(confirmSystemMessage);
                    continue;
                }
                if (widgetType == WidgetType.INFORMATION) {
                    this.informationWidgetIndex = i;
                    this.fields[i].setType(6);
                    this.fields[i].setLabel(null);
                    this.fields[i].setNumberColumns(((TextAreaWidget)widget).getColumns());
                    this.fields[i].setNumberRows(((TextAreaWidget)widget).getRows());
                    this.fields[i].setInitialValue("");
                    continue;
                }
                if (widgetType == WidgetType.HTML) {
                    this.fields[i].setType(8);
                    this.fields[i].setLabel(null);
                    this.fields[i].setInitialValue(widget.getText());
                    continue;
                }
                if (widgetType == WidgetType.RADIOBOX) {
                    this.fields[i].setType(5);
                    RadioBoxWidget radioBoxWidget = (RadioBoxWidget)widgetList.get(i);
                    this.fields[i].setIsVertical(radioBoxWidget.isVertical());
                    List radioBoxWidgetList = radioBoxWidget.getWidgets();
                    this.fields[i].setPopulation(this.getListWidgetPopulation(radioBoxWidgetList).toArray(new String[0]));
                    continue;
                }
                if (widgetType == WidgetType.COMBOBOX) {
                    this.fields[i].setType(2);
                    ComboBoxWidget comboBoxWidget = (ComboBoxWidget)widgetList.get(i);
                    List comboBoxWidgetList = comboBoxWidget.getWidgets();
                    this.fields[i].setPopulation(this.getListWidgetPopulation(comboBoxWidgetList).toArray());
                    continue;
                }
                if (widgetType == WidgetType.JUMP) {
                    this.fields[i].setType(0);
                    JumpWidget jumpWidget = (JumpWidget)((Object)widget);
                    String jumpToIdString = jumpWidget.getJumpToFormIdentifier();
                    customFields[i] = new JumpButton(jumpWidget.getTitle(), this.navigationProvider, this.parentDialog, this.wizard.getFormIndex(jumpToIdString), jumpWidget.getShowButton(), widget.isEditable(), widget.getMnemonic());
                    this.fields[i].setLabel(null);
                    String prenote = widget.getText();
                    if (prenote == null || prenote.trim() == "") continue;
                    this.fields[i].setPrenote(prenote);
                    continue;
                }
                if (widgetType == WidgetType.LINK) {
                    this.fields[i].setType(0);
                    LinkWidget linkWidget = (LinkWidget)((Object)widget);
                    String urlString = linkWidget.getURL();
                    customFields[i] = new LinkButton(linkWidget.getTitle(), this.navigationProvider, urlString, linkWidget.getShowButton(), linkWidget.getEndsWizard(), widget.isEditable(), widget.getMnemonic());
                    this.fields[i].setLabel(null);
                    String prenote = widget.getText();
                    if (prenote == null || prenote.trim() == "") continue;
                    this.fields[i].setPrenote(prenote);
                    continue;
                }
                if (widgetType == WidgetType.SELECT) {
                    this.fields[i].setType(3);
                    SelectWidget selectWidget = (SelectWidget)widget;
                    String selectType = selectWidget.getSelectType();
                    this.fields[i].setIsSelectRadio(selectType.equalsIgnoreCase("radio"));
                    this.fields[i].setButtonGroupId(selectWidget.getGroupId());
                    boolean isSelected = selectWidget.isSelected();
                    this.fields[i].setInitialValue(isSelected ? "true" : "false");
                    this.fields[i].setSlaveId(selectWidget.getSlaveId());
                    this.fields[i].setSlaveValue(selectWidget.getSlaveValue());
                    this.fields[i].setSetVarListIfSelected(selectWidget.getSetVarListIfSelected());
                    this.fields[i].setSetVarListIfDeselected(selectWidget.getSetVarListIfDeselected());
                    this.fields[i].setIsContinueCheck(selectWidget.isContinueCheck());
                    continue;
                }
                if (widgetType == WidgetType.HIDDEN) {
                    this.fields[i].setType(9);
                    this.fields[i].setLabel(null);
                    continue;
                }
                this.fields[i].setType(10);
                this.fields[i].setLabel(null);
                LOG.info("IGNORED TYPE: " + widgetType.toString());
            }
            this.formPanel = new FormPanel(this, this.fields, customFields);
            this.add((Component)this.formPanel, "Center");
        }
    }

    private void setFormTitleText(String formTitle) {
        this.titleLabel.setText(formTitle);
        this.titleLabel.getAccessibleContext().setAccessibleName(formTitle);
        this.titleLabel.getAccessibleContext().setAccessibleDescription(formTitle);
    }

    public void resolveDisplayVariables() {
        LOG.info("Load form variables");
        String formTitleValue = VariableMap.getActualValue(this.form.getTitle());
        this.setFormTitleText(formTitleValue);
        List widgetList = this.form.getWidgets();
        for (int index = 0; index < widgetList.size(); ++index) {
            Widget widget = (Widget)widgetList.get(index);
            WidgetType widgetType = widget.getType();
            if (widgetType != WidgetType.TEXTICONLABEL && widgetType != WidgetType.MESSAGE) continue;
            String widgetValue = VariableMap.getActualValue(widget.getText());
            this.formPanel.setFieldValue(index, widgetValue);
            CommonUtil.debug((Object)widgetValue);
        }
    }

    public void reloadWidgets() {
        LOG.info(" $$$$ RELOAD WIDGETS of form: " + this.form.getFormIdentifier());
        List widgetList = this.form.getWidgets();
        for (int index = 0; index < widgetList.size(); ++index) {
            String confirmSystemMessage;
            String widgetId;
            Widget widget = (Widget)widgetList.get(index);
            WidgetType widgetType = widget.getType();
            if (widgetType == WidgetType.REFLECTION || widgetType == WidgetType.UNKNOWN) continue;
            if (widget.isReload() && widgetType != WidgetType.HIDDEN) {
                LOG.info(" $$$$ RELOAD GUI FIELD VALUE OF WIDGET: " + widget.getId());
                LOG.finest(" $$$$ RELOAD VALUE: " + widget.getText());
                this.formPanel.setFieldValue(index, widget.getText());
            }
            if ((widgetId = widget.getId()) != null && widgetId.equals("system")) {
                String systemValue = widget.getDefaultValue();
                if (systemValue == null) {
                    systemValue = this.getWidgetSlaveValue("systemselect");
                }
                LOG.info(" >> SET system FIELD VALUE: " + systemValue);
                this.formPanel.setFieldValue(index, systemValue);
            }
            if (widgetId == null || !widgetId.equals("SWUPConfirmSystem") && !widgetId.equals("UMConfirmSystem") && !widgetId.equals("SolarisConfirmSystem") && !widgetId.equals("EnablePortalConfirmSystem") && !widgetId.equals("UpdateManagerConfirmSystem") || (confirmSystemMessage = this.getConfirmSystemMessage(widgetId)) == null) continue;
            this.fields[index].setInitialValue(confirmSystemMessage);
            this.formPanel.setFieldValue(index, confirmSystemMessage);
        }
    }

    public String getWidgetSlaveValue(String widgetId) {
        if (widgetId == null) {
            return null;
        }
        Widget widget = this.form.getWidgetById(widgetId);
        if (widget == null) {
            LOG.severe("ERROR - no widget with id: " + widgetId);
            return null;
        }
        if (!(widget instanceof SelectWidget)) {
            LOG.severe("ERROR - not a SelectWidget: " + widgetId);
            return null;
        }
        return ((SelectWidget)widget).getSlaveValue();
    }

    public JDialog getParentDialog() {
        return this.parentDialog;
    }

    public Form getForm() {
        return this.form;
    }

    public FormPanel getFormPanel() {
        return this.formPanel;
    }

    public void setInitialFocus() {
        JComponent firstFocusableComponent = this.formPanel.getFirstFocusableField();
        if (firstFocusableComponent != null) {
            firstFocusableComponent.requestFocusInWindow();
        }
    }

    public void refreshMe() {
        this.validate();
        this.repaint();
    }

    public boolean validateResponses() {
        return this.validateResponses(false);
    }

    private boolean validateResponses(boolean ignoreSpecialCaseErrors) {
        int numberWidgets;
        boolean errorsFound = false;
        List widgetList = this.form.getWidgets();
        int n = numberWidgets = widgetList == null ? 0 : widgetList.size();
        if (widgetList != null && numberWidgets > 0) {
            for (int i = 0; i < numberWidgets; ++i) {
                int errorMessageIndex;
                String errorMessageId;
                Widget errorMessageWidget;
                Widget widget = (Widget)widgetList.get(i);
                WidgetType widgetType = widget.getType();
                String widgetId = widget.getId();
                if (widgetType == WidgetType.HIDDEN || widgetType == WidgetType.REFLECTION) continue;
                if (!this.formPanel.isFieldEditable(i)) {
                    LOG.info("DO NOT VALIDATE AT INDEX: " + i);
                    continue;
                }
                String validationPatternError = Validation.validateValue(this.formPanel.getFieldValue(i), widget);
                String validationMatchError = null;
                String matchValue = null;
                String matchString = widget.getValidMatch();
                String matchError = widget.getMatchError();
                if (matchString != null) {
                    String matchWidgetId = Validation.getMatchWidgetId(matchString);
                    matchValue = matchWidgetId == null ? matchString : this.formPanel.getFieldValue(matchWidgetId);
                    validationMatchError = Validation.validateValueMatch(this.formPanel.getFieldValue(i), matchValue, widget);
                }
                String validationUserPassError = null;
                if (widgetId != null && widgetId.equals("password2")) {
                    Widget usernameWidget = this.form.getWidgetById("username");
                    if (usernameWidget != null) {
                        String usernameId = usernameWidget.getId();
                        if (usernameId != null) {
                            String usernameValue = this.formPanel.getFieldValue(usernameId);
                            String password2Value = this.formPanel.getFieldValue(i);
                            validationUserPassError = Validation.validateUserPass(usernameValue, password2Value);
                        } else {
                            LOG.severe("ERROR - username field has null id");
                        }
                    } else {
                        LOG.severe("ERROR - expected username field not found");
                    }
                }
                boolean validationFormFlag = false;
                String validationRadioButtonError = null;
                if (widgetId != null && widgetId.equals("contactselectNo")) {
                    Widget radioButtonYesWidget = this.form.getWidgetById("contactselect");
                    if (radioButtonYesWidget != null) {
                        String radioButtonYesId = radioButtonYesWidget.getId();
                        if (radioButtonYesId != null) {
                            validationFormFlag = true;
                            String radioButtonYesValue = this.formPanel.getFieldValue(radioButtonYesId);
                            String radioButtonNoValue = this.formPanel.getFieldValue(i);
                            validationRadioButtonError = Validation.validateRadioButton(radioButtonYesValue, radioButtonNoValue);
                        } else {
                            LOG.severe("ERROR - RadioButtonYes field has null id");
                        }
                    } else {
                        LOG.severe("ERROR - expected RadioButtonYes field not found");
                    }
                }
                if (validationPatternError != null) {
                    if (ignoreSpecialCaseErrors && (validationPatternError.equals(I18N.IS_REQUIRED_ERR_MSG) || validationPatternError.equals(I18N.ACCEPT_TOU_ERR_MSG) || validationPatternError.equals(I18N.ACCEPT_INFO_ERR_MSG) || validationPatternError.equals(I18N.SECURITY_QUESTION_PATTERN_ERROR) || validationPatternError.equals(I18N.COUNTRY_PATTERN_ERROR) || validationPatternError.equals(I18N.LANGUAGE_PATTERN_ERROR))) {
                        this.fields[i].setError(null);
                        continue;
                    }
                    this.fields[i].setError(validationPatternError);
                    errorsFound = true;
                    continue;
                }
                if (validationMatchError != null) {
                    this.fields[i].setError(validationMatchError);
                    errorsFound = true;
                    continue;
                }
                if (validationUserPassError != null) {
                    this.fields[i].setError(validationUserPassError);
                    errorsFound = true;
                    continue;
                }
                if (validationRadioButtonError != null) {
                    int errorMessageIndex2;
                    errorsFound = true;
                    errorMessageWidget = this.form.getWidgetById("brErrorMessage");
                    if (errorMessageWidget == null || (errorMessageId = errorMessageWidget.getId()) == null || (errorMessageIndex2 = this.formPanel.getFieldIndex(errorMessageId)) == -1) continue;
                    this.formPanel.setFieldValue(errorMessageId, validationRadioButtonError);
                    this.fields[errorMessageIndex2].setIsDisplayed(YES_STR);
                    continue;
                }
                this.fields[i].setError(null);
                if (!validationFormFlag || (errorMessageWidget = this.form.getWidgetById("brErrorMessage")) == null || (errorMessageIndex = this.formPanel.getFieldIndex(errorMessageId = errorMessageWidget.getId())) == -1) continue;
                this.fields[errorMessageIndex].setIsDisplayed(NO_STR);
                this.updateUI();
            }
        }
        return !errorsFound;
    }

    public void setResponses() {
        int numberWidgets;
        List widgetList = this.form.getWidgets();
        int n = numberWidgets = widgetList == null ? 0 : widgetList.size();
        if (widgetList != null && numberWidgets > 0) {
            for (int i = 0; i < numberWidgets; ++i) {
                Widget widget = (Widget)widgetList.get(i);
                WidgetType widgetType = widget.getType();
                if (widgetType == WidgetType.FIELD) {
                    if (widget instanceof ResponseWidget) {
                        ((ResponseWidget)((Object)widget)).setResponse(this.formPanel.getFieldValue(i));
                        continue;
                    }
                    LOG.severe("ERROR - FIELD not ResponseWidget");
                    continue;
                }
                if (widgetType == WidgetType.PASSWORD) {
                    if (widget instanceof ResponseWidget) {
                        ((ResponseWidget)((Object)widget)).setResponse(this.formPanel.getFieldValue(i));
                        continue;
                    }
                    LOG.severe("ERROR - PASSWORD not ResponseWidget");
                    continue;
                }
                if (widgetType == WidgetType.RADIOBOX) {
                    String radioBoxValue = this.formPanel.getFieldValue(i);
                    RadioBoxWidget radioBoxWidget = (RadioBoxWidget)((Object)widget);
                    radioBoxWidget.setResponse(radioBoxValue);
                    continue;
                }
                if (widgetType == WidgetType.COMBOBOX) {
                    String comboBoxValue = this.formPanel.getFieldValue(i);
                    ComboBoxWidget comboBoxWidget = (ComboBoxWidget)((Object)widget);
                    comboBoxWidget.setResponse(comboBoxValue);
                    continue;
                }
                if (widgetType == WidgetType.SELECT) {
                    SelectWidget selectWidget = (SelectWidget)widget;
                    selectWidget.setResponse(this.formPanel.getFieldValue(i).equals("true") ? "true" : "false");
                    continue;
                }
                if (widgetType == WidgetType.MESSAGE || widgetType == WidgetType.INFORMATION || widgetType == WidgetType.JUMP || widgetType == WidgetType.LINK || widgetType == WidgetType.TEXTICONLABEL || widgetType == WidgetType.HIDDEN || widgetType == WidgetType.HTML) continue;
                LOG.info("TODO(?) setResponse(): " + widgetType.toString());
            }
        }
    }

    public void setFormVariables() {
        List widgetList;
        int numberWidgets;
        LOG.info("setFormVariables ...");
        String formSetVarList = this.form.getSetVarList();
        if (formSetVarList != null) {
            VariableMap.addListToMap(formSetVarList);
        }
        int n = numberWidgets = (widgetList = this.form.getWidgets()) == null ? 0 : widgetList.size();
        if (widgetList != null && numberWidgets > 0) {
            for (int i = 0; i < numberWidgets; ++i) {
                Widget widget = (Widget)widgetList.get(i);
                WidgetType widgetType = widget.getType();
                if (widgetType != WidgetType.SELECT) continue;
                boolean isSelected = this.formPanel.getFieldValue(i).equals("true");
                String setVarListIfSelected = this.fields[i].getSetVarListIfSelected();
                String setVarListIfDeselected = this.fields[i].getSetVarListIfDeselected();
                if (isSelected && setVarListIfSelected != null) {
                    VariableMap.addListToMap(setVarListIfSelected);
                    continue;
                }
                if (isSelected || setVarListIfDeselected == null) continue;
                VariableMap.addListToMap(setVarListIfDeselected);
            }
        }
    }

    private void debugResponses() {
        int numberWidgets;
        List widgetList = this.form.getWidgets();
        int n = numberWidgets = widgetList == null ? 0 : widgetList.size();
        if (widgetList != null && numberWidgets > 0) {
            LOG.finest("\n****************\nWidget - response\n");
            for (int i = 0; i < numberWidgets; ++i) {
                String response;
                Widget widget = (Widget)widgetList.get(i);
                if (widget instanceof ResponseWidget) {
                    response = ((ResponseWidget)((Object)widget)).getResponse();
                    LOG.finest(widget.getText() + " - " + response);
                    continue;
                }
                if (widget instanceof RadioBoxWidget) {
                    response = ((RadioBoxWidget)((Object)widget)).getResponse();
                    LOG.finest(widget.getText() + " - " + response);
                    continue;
                }
                if (widget instanceof ComboBoxWidget) {
                    response = ((ComboBoxWidget)((Object)widget)).getResponse();
                    LOG.finest(widget.getText() + " - " + response);
                    continue;
                }
                if (widget instanceof SelectWidget) {
                    response = ((SelectWidget)widget).getResponse();
                    LOG.finest(widget.getText() + " - " + response);
                    continue;
                }
                LOG.finest("Non-valued widget");
            }
            LOG.finest("****************\n");
        }
    }

    private ArrayList getListWidgetPopulation(List widgetList) {
        ArrayList<String> populationArrayList = new ArrayList<String>();
        if (widgetList != null) {
            for (Widget widget : widgetList) {
                populationArrayList.add(widget.getText());
            }
        } else {
            LOG.severe("ERROR - get population for null widget list ?");
        }
        return populationArrayList;
    }

    private boolean doErrorNavigation() {
        LOG.info("Form id is: " + this.form.getFormIdentifier());
        if (this.outputResult.isProxyConnectionError()) {
            int networkFormIndex = this.wizard.getFormIndex("network");
            if (networkFormIndex != -1) {
                this.navigationProvider.navigateToIndex(networkFormIndex);
                return false;
            }
            LOG.severe("ERROR - missing network form");
        } else if (this.outputResult.isAccountCreationFailedError()) {
            String createFailedNextFormId = "createAccountOne";
            int createFormIndex = this.wizard.getFormIndex(createFailedNextFormId);
            if (createFormIndex != -1) {
                this.navigationProvider.navigateToIndex(createFormIndex);
            } else {
                LOG.severe("ERROR - missing form id: " + createFailedNextFormId);
            }
        } else if (this.outputResult.isSubscriptionKeyError()) {
            int subKeyFormIndex;
            String subKeyNextFormId = null;
            String thisFormIdentifier = this.form.getFormIdentifier();
            if (thisFormIdentifier.equalsIgnoreCase("sunAccountThreeA")) {
                subKeyNextFormId = "sunAccountTwo";
            } else if (thisFormIdentifier.equalsIgnoreCase("createAccountFourA")) {
                subKeyNextFormId = "createAccountThree";
            } else if (thisFormIdentifier.equalsIgnoreCase("subscription2")) {
                subKeyNextFormId = "subscription1";
            } else if (thisFormIdentifier.equalsIgnoreCase("solarisSunAccountThree")) {
                subKeyNextFormId = "solarisSunAccountTwo";
            } else if (thisFormIdentifier.equalsIgnoreCase("enablePortalOne")) {
                subKeyNextFormId = "enablePortalOne";
            }
            int n = subKeyFormIndex = subKeyNextFormId != null ? this.wizard.getFormIndex(subKeyNextFormId) : -1;
            if (subKeyFormIndex != -1) {
                this.navigationProvider.navigateToIndex(subKeyFormIndex);
            } else {
                LOG.severe("ERROR - missing form id: " + subKeyNextFormId);
            }
        } else if (this.outputResult.isNotYetCompanyRegistrationError()) {
            String notYetCompanyRegFormId = "sunAccountOne";
            int notYetCompanyRegIndex = this.wizard.getFormIndex(notYetCompanyRegFormId);
            if (notYetCompanyRegIndex != -1) {
                this.navigationProvider.navigateToIndex(notYetCompanyRegIndex);
            } else {
                LOG.severe("ERROR - missing form id: " + notYetCompanyRegFormId);
            }
        }
        return true;
    }

    private void showModalErrorDialog() {
        this.refreshMe();
        if (this.outputResult.getSeverity().equalsIgnoreCase("W")) {
            JOptionPane.showMessageDialog(this, I18N.getString(this.outputResult.getCode() + ".msg"), I18N.getString("warning.dialog.title"), 2);
        } else if (this.outputResult.getSeverity().equalsIgnoreCase("F")) {
            LOG.info("Error code is -->" + this.outputResult.getCode());
            JOptionPane.showMessageDialog(this, I18N.getString(this.outputResult.getCode() + ".err"), I18N.getString("error.dialog.title"), 0);
        }
        this.refreshMe();
    }

    void updateLpsUrl() {
        Widget patchUrlWgt = this.form.getWidgetById("patchURL");
        if (patchUrlWgt != null) {
            String lpsurl = this.formPanel.getFieldValue("patchURL");
            Widget lpsurlWgt = this.wizard.getFormById("LocalConfirm").getWidgetById("lpsurl");
            if (lpsurlWgt != null) {
                lpsurlWgt.setText(lpsurlWgt.getText() + " " + lpsurl);
            }
        }
    }

    public boolean isNavigationAllowed(int whichWay) {
        LOG.info("isNavigationAllowed: " + whichWay);
        if (whichWay == 2) {
            return WizardPanel.exitConfirmation(this);
        }
        if (whichWay == 0 || whichWay == 1 || whichWay == 3) {
            boolean validResponses = this.validateResponses(whichWay == 0);
            this.formPanel.layoutLabelsAndComponents();
            if (!validResponses && whichWay != 0) {
                this.getToolkit().beep();
                this.refreshMe();
                return false;
            }
            if (validResponses && whichWay != 0) {
                int continueCheckIndex = this.formPanel.getContinueCheckIndex();
                if (continueCheckIndex != -1 && !this.formPanel.getFieldValue(continueCheckIndex).equals("true") && this.remoteConfirmation()) {
                    JCheckBox remoteCheckBox = (JCheckBox)this.formPanel.getField(continueCheckIndex);
                    remoteCheckBox.doClick();
                }
                this.setFormVariables();
                this.setResponses();
            }
        }
        this.debugResponses();
        if (whichWay == 3) {
            final GatherDialog progressDialog = new GatherDialog(this.parentDialog, null, 1, true, false);
            SwingWorker worker = new SwingWorker(){
                boolean workerDone = false;

                public Object construct() {
                    StoreTask storeTask = new StoreTask();
                    this.workerDone = true;
                    progressDialog.stop();
                    return storeTask;
                }

                public boolean isDone() {
                    return this.workerDone;
                }
            };
            CursorUtils.setComponentBusyCursor(this.parentDialog);
            LOG.info("\n ** FINISH BACKEND CALL with outForms: " + this.form.getOutForms() + ", and outCall: " + this.form.getOutCall());
            worker.start();
            if (!worker.isDone()) {
                progressDialog.start();
            }
            CursorUtils.setComponentDefaultCursor(this.parentDialog);
            if (this.outputResult == null || this.outputResult.getCode().equals("0")) {
                return true;
            }
            boolean showErrorDialog = this.doErrorNavigation();
            if (showErrorDialog) {
                this.showModalErrorDialog();
            }
            return false;
        }
        if (whichWay == 1 && this.form.getOutForms() != null && this.form.getOutCall() != null) {
            LOG.info("\n ** NEXT BACKEND CALL with outForms: " + this.form.getOutForms() + ", and outCall: " + this.form.getOutCall());
            CursorUtils.setComponentBusyCursor(this.parentDialog);
            this.outputResult = this.wizard.output(this.form);
            CursorUtils.setComponentDefaultCursor(this.parentDialog);
            if (this.outputResult == null || this.outputResult.getCode().equals("0")) {
                return true;
            }
            boolean showErrorDialog = this.doErrorNavigation();
            if (showErrorDialog) {
                this.showModalErrorDialog();
            }
            return false;
        }
        return true;
    }

    public boolean isConfirmationForm() {
        return this.isFormWithId("UMConfirm") || this.isFormWithId("SWUPConfirm") || this.isFormWithId("SolarisConfirm") || this.isFormWithId("LocalConfirm") || this.isFormWithId("EnablePortalConfirm") || this.isFormWithId("UpdateManagerConfirm");
    }

    private boolean isFormWithId(String formId) {
        String formIdentifier = this.form.getFormIdentifier();
        return formIdentifier.equals(formId);
    }

    private String getConfirmSystemMessage(String id) {
        if (id == null) {
            return null;
        }
        String hostname = this.getJXTAHostname();
        if (hostname != null) {
            Object[] argObjects = new Object[]{hostname};
            if (id.equals("SWUPConfirmSystem")) {
                return I18N.getFormattedString("swup.confirm.system.message", argObjects);
            }
            if (id.equals("UMConfirmSystem")) {
                return I18N.getFormattedString("um.confirm.system.message", argObjects);
            }
            if (id.equals("SolarisConfirmSystem")) {
                return I18N.getFormattedString("solaris.confirm.system.message", argObjects);
            }
            if (id.equals("EnablePortalConfirmSystem")) {
                return I18N.getFormattedString("enablePortal.confirm.system.message", argObjects);
            }
            if (id.equals("UpdateManagerConfirmSystem")) {
                return I18N.getFormattedString("updateManager.confirm.system.message", argObjects);
            }
            return I18N.getFormattedString("solaris.confirm.system.message", argObjects);
        }
        return null;
    }

    private String getJXTAHostname() {
        Widget widget = this.form.getWidgetById("jxtaHostname");
        if (widget == null) {
            LOG.warning("WARNING - no jxta hostname widget in form");
            return null;
        }
        String hostname = widget.getText();
        if (hostname == null) {
            LOG.warning("WARNING - jxta hostname widget value is null");
        }
        LOG.info(" !! JXTA Hostname: " + hostname);
        return hostname;
    }

    public static boolean exitConfirmation(Component parentComponent) {
        String dialogTitle = I18N.getString("confirm.exit.dialog.title");
        String dialogMessage = I18N.getString("confirm.exit.dialog.message");
        String discardOption = I18N.getString("confirm.exit.dialog.discard");
        String continueOption = I18N.getString("confirm.exit.dialog.continue");
        Object[] options = new String[]{discardOption, continueOption};
        int confirmOption = JOptionPane.showOptionDialog(parentComponent, Utils.makeMultiLineLabel(dialogMessage), dialogTitle, 0, 3, null, options, continueOption);
        return confirmOption == 0;
    }

    public static boolean registerLaterConfirmation(Component parentComponent) {
        String dialogTitle = I18N.getString("confirm.reg.later.dialog.title");
        String dialogMessage = I18N.getString("confirm.reg.later.dialog.message");
        String regLaterOption = I18N.getString("confirm.reg.later.dialog.confirm");
        String continueOption = I18N.getString("confirm.reg.later.dialog.continue");
        Object[] options = new String[]{regLaterOption, continueOption};
        int confirmOption = JOptionPane.showOptionDialog(parentComponent, dialogMessage, dialogTitle, 0, 2, null, options, continueOption);
        return confirmOption == 0;
    }

    public static boolean registerNeverConfirmation(Component parentComponent) {
        String dialogTitle = I18N.getString("confirm.reg.never.dialog.title");
        String dialogMessage = I18N.getString("confirm.reg.never.dialog.message");
        String regNeverOption = I18N.getString("confirm.reg.never.dialog.confirm");
        String continueOption = I18N.getString("confirm.reg.later.dialog.continue");
        Object[] options = new String[]{regNeverOption, continueOption};
        int confirmOption = JOptionPane.showOptionDialog(parentComponent, dialogMessage, dialogTitle, 0, 2, null, options, continueOption);
        return confirmOption == 0;
    }

    private boolean remoteConfirmation() {
        String dialogTitle = I18N.getString("confirm.no.remote.dialog.title");
        String dialogMessage = I18N.getString("confirm.no.remote.dialog.message");
        String noOption = I18N.getString("confirm.no.remote.dialog.no");
        String yesOption = I18N.getString("confirm.no.remote.dialog.yes");
        Object[] options = new String[]{noOption, yesOption};
        int confirmOption = JOptionPane.showOptionDialog(this, Utils.makeMultiLineLabel(dialogMessage), dialogTitle, 0, 2, null, options, yesOption);
        return confirmOption == 1;
    }

    private void loadInformationWidget() {
        List widgetList = this.form.getWidgets();
        Widget informationWidget = (Widget)widgetList.get(this.informationWidgetIndex);
        String informationWidgetValue = informationWidget.getText();
        this.formPanel.setFieldValue(this.informationWidgetIndex, informationWidgetValue);
    }

    class StoreTask {
        StoreTask() {
            LOG.info("StoreTask ENTER");
            LOG.info(">>>> About to output");
            WizardPanel.this.outputResult = WizardPanel.this.wizard.output(WizardPanel.this.form);
            LOG.info(">>>> output result: " + WizardPanel.this.outputResult.getText());
            LOG.info("StoreTask LEAVE");
        }
    }
}

