/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cns.basicreg.wizard.util;

import com.sun.cns.basicreg.wizard.Widget;
import com.sun.cns.basicreg.wizard.util.I18N;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class Validation {
    private static String ERROR_INFO_NONE_TEXT = I18N.getString("error.info.none.text");
    private static final String TRUE_STR = "true";
    private static final String FALSE_STR = "false";
    private static final Logger LOG = Logger.getLogger(Validation.class.getName());

    private static String validateValueEmail(String value, Widget widget) {
        return "SPECIAL VALIDATION NOT YET IMPLEMENTED";
    }

    private static String validateValuePhone(String value, Widget widget) {
        return "SPECIAL VALIDATION NOT YET IMPLEMENTED";
    }

    private static String validateValueTOU(String value, Widget widget) {
        return value.equalsIgnoreCase(TRUE_STR) ? null : I18N.ACCEPT_TOU_ERR_MSG;
    }

    private static String validateValueInfo(String value, Widget widget) {
        return value.equalsIgnoreCase(TRUE_STR) ? null : I18N.ACCEPT_INFO_ERR_MSG;
    }

    private static String validateValuePatchURL(String value, Widget widget) {
        try {
            URL url = new URL(value);
            return null;
        }
        catch (MalformedURLException ex) {
            LOG.severe("Unable to create URL from String: " + value);
            return I18N.getString("patch.url.err");
        }
    }

    private static String validateValueSecurityQuestion(String value, Widget widget) {
        if (value != null && !value.equals(I18N.SECURITY_QUESTION_DEFAULT)) {
            return null;
        }
        return I18N.SECURITY_QUESTION_PATTERN_ERROR;
    }

    private static String validateValueCountry(String value, Widget widget) {
        if (value != null && !value.equals(I18N.COUNTRY_DEFAULT_NAME)) {
            return null;
        }
        return I18N.COUNTRY_PATTERN_ERROR;
    }

    private static String validateValueLanguage(String value, Widget widget) {
        if (value != null && !value.equals(I18N.LANGUAGE_DEFAULT_NAME)) {
            return null;
        }
        return I18N.LANGUAGE_PATTERN_ERROR;
    }

    private static String validateValueJobRole(String value, Widget widget) {
        if (value != null && !value.equals(I18N.JOB_SEPARATOR_ONE) && !value.equals(I18N.JOB_SEPARATOR_TWO)) {
            return null;
        }
        String patternError = widget.getPatternError();
        if (patternError == null) {
            patternError = "";
        }
        Object[] errorArguments = new Object[]{patternError};
        return I18N.getFormattedString("bad.format.err", errorArguments);
    }

    private static String validateValuePattern(String value, String patternString, Widget widget) {
        Pattern pattern = null;
        try {
            pattern = Pattern.compile(patternString);
        }
        catch (Exception ex) {
            LOG.severe("ERROR - Unable to compile pattern: " + widget.getValidPattern());
            pattern = null;
        }
        if (pattern != null && !pattern.matcher(value).matches()) {
            String patternError = widget.getPatternError();
            if (patternError == null) {
                patternError = "";
            }
            Object[] errorArguments = new Object[]{patternError};
            return I18N.getFormattedString("bad.format.err", errorArguments);
        }
        if (widget.getId().equalsIgnoreCase("email") && value.length() > 80) {
            return I18N.getString("bad.email.err");
        }
        return null;
    }

    private static String validateValueIsRequired(String value, boolean isRequired) {
        if (isRequired && (value == null || value.trim().length() == 0)) {
            return I18N.IS_REQUIRED_ERR_MSG;
        }
        return null;
    }

    public static String validateUserPass(String username, String password) {
        if (username == null && password != null || username != null && password == null) {
            return null;
        }
        if (username == null && password == null || username.equals(password)) {
            return I18N.getString("username.password.match.err");
        }
        return null;
    }

    public static String validateRadioButton(String radioButtonYesValue, String radioButtonNoValue) {
        if (radioButtonYesValue != null && radioButtonYesValue.equalsIgnoreCase(FALSE_STR) && radioButtonNoValue != null && radioButtonNoValue.equalsIgnoreCase(FALSE_STR)) {
            return ERROR_INFO_NONE_TEXT;
        }
        return null;
    }

    public static String validateValueMatch(String value, String matchValue, Widget widget) {
        if (matchValue == null) {
            return null;
        }
        if (!value.equals(matchValue)) {
            String matchError = widget.getMatchError();
            if (matchError == null) {
                matchError = "";
            }
            Object[] errorArguments = new Object[]{matchError};
            return I18N.getFormattedString("bad.match.err", errorArguments);
        }
        return null;
    }

    public static String getMatchWidgetId(String matchString) {
        if (matchString == null) {
            return null;
        }
        int widFlagIndex = matchString.indexOf("$WID:");
        if (widFlagIndex == -1) {
            return null;
        }
        if (widFlagIndex + "$WID:".length() >= matchString.length()) {
            LOG.severe("ERROR - no widget id specified");
            return null;
        }
        return matchString.substring(widFlagIndex + "$WID:".length());
    }

    public static String validateValue(String value, Widget widget) {
        String error = Validation.validateValueIsRequired(value, widget.isRequired());
        if (error != null) {
            return error;
        }
        String patternString = widget.getValidPattern();
        if (patternString == null) {
            return null;
        }
        if (!widget.isRequired() && value.trim().length() == 0) {
            return null;
        }
        String validationPatternError = null;
        validationPatternError = patternString.equals("Zemail") ? Validation.validateValueEmail(value, widget) : (patternString.equals("Zphone") ? Validation.validateValuePhone(value, widget) : (patternString.equals("Ztou") ? Validation.validateValueTOU(value, widget) : (patternString.equals("Zinfo") ? Validation.validateValueInfo(value, widget) : (patternString.equals("ZpatchURL") ? Validation.validateValuePatchURL(value, widget) : (patternString.equals("Zsecurity") ? Validation.validateValueSecurityQuestion(value, widget) : (patternString.equals("Zcountry") ? Validation.validateValueCountry(value, widget) : (patternString.equals("Zlanguage") ? Validation.validateValueLanguage(value, widget) : (patternString.equals("Zjob") ? Validation.validateValueJobRole(value, widget) : Validation.validateValuePattern(value, patternString, widget)))))))));
        return validationPatternError;
    }
}

