/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cns.basicreg.wizard.util;

import com.sun.cns.basicreg.wizard.util.I18N;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.logging.Logger;

public class VariableMap
extends HashMap {
    private static Logger LOG = Logger.getLogger(VariableMap.class.getName());
    private static VariableMap variableMap = new VariableMap();

    private VariableMap() {
    }

    public static void addListToMap(String keyValueListString) {
        LOG.finest("SET MAP VALUES: " + keyValueListString);
        if (keyValueListString == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(keyValueListString, ";");
        if (st.countTokens() < 1) {
            LOG.warning("No key:value in " + keyValueListString);
            return;
        }
        while (st.hasMoreTokens()) {
            String keyValuePair = st.nextToken();
            StringTokenizer st2 = new StringTokenizer(keyValuePair, "=");
            if (st2.countTokens() < 2) {
                LOG.warning("Bad key:value in " + keyValuePair);
                continue;
            }
            String key = st2.nextToken().trim();
            String value = st2.nextToken().trim();
            VariableMap.setVariable(key, value);
        }
    }

    public static void setVariable(String key, String value) {
        LOG.finest("PUT MAP VALUE: " + key + " = " + value);
        variableMap.put(key, value);
    }

    public static String getVariable(String key) {
        if (!variableMap.containsKey(key)) {
            LOG.info("No Variable Map value for: " + key);
            return null;
        }
        Object variableValue = variableMap.get(key);
        LOG.info("Variable Map value: " + key + " = " + (String)variableMap.get(key));
        return (String)variableMap.get(key);
    }

    public static String getActualValue(String literalValue) {
        if (literalValue == null || !literalValue.trim().startsWith("$VAR_")) {
            return literalValue;
        }
        String variableKey = literalValue.trim().substring("$VAR_".length());
        String variableValue = VariableMap.getVariable(variableKey);
        if (variableValue == null || !variableValue.startsWith("_i18n")) {
            return variableValue;
        }
        return I18N.getXMLValueString(variableValue);
    }
}

