/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.netbeans.lib.profiler.heap.HprofByteBuffer;
import org.netbeans.lib.profiler.heap.HprofHeap;
import org.netbeans.lib.profiler.heap.LongHashMap;
import org.netbeans.lib.profiler.heap.TagBounds;

class StringSegment
extends TagBounds {
    private final int UTF8CharsOffset;
    private final int lengthOffset;
    private final int stringIDOffset;
    private final int timeOffset;
    private LongHashMap stringIDMap;
    private HprofHeap hprofHeap;
    private Map stringCache = Collections.synchronizedMap(new StringCache());

    StringSegment(HprofHeap hprofHeap, long l, long l2) {
        super(1, l, l2);
        int n = hprofHeap.dumpBuffer.getIDSize();
        this.hprofHeap = hprofHeap;
        this.timeOffset = 1;
        this.lengthOffset = this.timeOffset + 4;
        this.stringIDOffset = this.lengthOffset + 4;
        this.UTF8CharsOffset = this.stringIDOffset + n;
    }

    String getStringByID(long l) {
        Long l2 = new Long(l);
        String string = (String)this.stringCache.get(l2);
        if (string == null) {
            string = this.createStringByID(l);
            this.stringCache.put(l2, string);
        }
        return string;
    }

    private String createStringByID(long l) {
        return this.getString(this.getStringOffsetByID(l));
    }

    private String getString(long l) {
        HprofByteBuffer hprofByteBuffer = this.getDumpBuffer();
        if (l == -1L) {
            return "<unknown string>";
        }
        int n = hprofByteBuffer.getInt(l + (long)this.lengthOffset);
        byte[] byArray = new byte[n - hprofByteBuffer.getIDSize()];
        hprofByteBuffer.get(l + (long)this.UTF8CharsOffset, byArray);
        String string = "Error";
        try {
            string = new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        return string;
    }

    private synchronized long getStringOffsetByID(long l) {
        long l2;
        if (this.stringIDMap == null) {
            this.stringIDMap = new LongHashMap(32768);
            long[] lArray = new long[]{this.startOffset};
            while (lArray[0] < this.endOffset) {
                long l3 = lArray[0];
                long l4 = this.readStringTag(lArray);
                if (l4 == 0L) continue;
                this.stringIDMap.put(l4, l3);
            }
        }
        if ((l2 = this.stringIDMap.get(l)) == 0L) {
            return -1L;
        }
        return l2;
    }

    private HprofByteBuffer getDumpBuffer() {
        HprofByteBuffer hprofByteBuffer = this.hprofHeap.dumpBuffer;
        return hprofByteBuffer;
    }

    private long readStringTag(long[] lArray) {
        long l = lArray[0];
        if (this.hprofHeap.readTag(lArray) != 1) {
            return 0L;
        }
        return this.getDumpBuffer().getID(l + (long)this.stringIDOffset);
    }

    private static class StringCache
    extends LinkedHashMap {
        private static final int SIZE = 1000;

        StringCache() {
            super(1000, 0.75f, true);
        }

        protected boolean removeEldestEntry(Map.Entry entry) {
            return this.size() > 1000;
        }
    }
}

