/*
 * Decompiled with CFR 0.152.
 */
package sunsoft.jws.visual.rt.awt;

import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Panel;
import java.util.Vector;
import sunsoft.jws.visual.rt.awt.GBConstraints;
import sunsoft.jws.visual.rt.awt.GBLayout;
import sunsoft.jws.visual.rt.awt.Scrollable;

class CheckboxView
extends Panel
implements Scrollable {
    Vector items = new Vector();
    private int curx;
    private int cury;
    private GBLayout gridbag;
    private Panel panel;

    public CheckboxView() {
        this.setLayout(null);
        this.gridbag = new GBLayout();
        this.panel = new Panel();
        this.panel.setLayout(this.gridbag);
        this.add(this.panel);
    }

    public void updateCheckboxes() {
        this.panel.removeAll();
        GBConstraints gBConstraints = new GBConstraints();
        gBConstraints.gridx = 0;
        gBConstraints.gridy = 0;
        gBConstraints.fill = 1;
        int n = this.items.size();
        for (int i = 0; i < this.items.size(); ++i) {
            Checkbox checkbox = new Checkbox((String)this.items.elementAt(i));
            this.gridbag.setConstraints(this.panel.add(checkbox), gBConstraints);
            ++gBConstraints.gridx;
            if (gBConstraints.gridx != 3) continue;
            gBConstraints.gridx = 0;
            ++gBConstraints.gridy;
        }
        if (this.panel.getPeer() != null) {
            Dimension dimension = this.panel.minimumSize();
            this.panel.reshape(0, 0, dimension.width, dimension.height);
        }
    }

    public void addNotify() {
        super.addNotify();
        Dimension dimension = this.panel.minimumSize();
        this.panel.reshape(0, 0, dimension.width, dimension.height);
    }

    public Dimension minimumSize() {
        return new Dimension(150, 300);
    }

    public Dimension preferredSize() {
        return this.minimumSize();
    }

    public void scrollX(int n) {
        this.curx = -n;
        this.panel.move(this.curx, this.cury);
    }

    public void scrollY(int n) {
        this.cury = -n;
        this.panel.move(this.curx, this.cury);
    }

    public Dimension scrollSize() {
        return this.panel.minimumSize();
    }

    public Dimension viewSize(Dimension dimension) {
        return dimension;
    }

    public int lineHeight() {
        if (this.panel.countComponents() == 0) {
            return 1;
        }
        Component component = this.panel.getComponent(0);
        Dimension dimension = component.minimumSize();
        return dimension.height;
    }
}

