/*
 * Decompiled with CFR 0.152.
 */
package sunsoft.jws.visual.rt.awt;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.util.Hashtable;
import java.util.Vector;
import sunsoft.jws.visual.rt.awt.CLChoice;
import sunsoft.jws.visual.rt.awt.Scrollable;
import sunsoft.jws.visual.rt.awt.TextList;
import sunsoft.jws.visual.rt.awt.VJCanvas;
import sunsoft.jws.visual.rt.base.Global;

public class TextView
extends VJCanvas
implements Scrollable {
    private static final int RIGHT_MOUSE = 4;
    protected Vector items;
    protected int fontHeight;
    protected int lineWidth;
    protected int lineHeight;
    protected FontMetrics fontMetrics;
    protected int minrows = 10;
    protected int mincolumns = 15;
    protected int minWidth = 0;
    protected static final int textIndent = 6;
    protected static final int textBorder = 2;
    protected static final int viewBorder = 0;
    protected static final int viewIPad = 2;
    private int[] selected = new int[0];
    private int numSelected;
    private int scrollx = 0;
    private int scrolly = 0;
    private Image buffer;
    private boolean multipleSelections;
    private Hashtable stringWidthTable = new Hashtable();
    private boolean menuMode;
    private CLChoice menuChoice;
    boolean menuDrag;
    private boolean gotEventInside;
    private int prevMenuY;

    public void setMinimumRows(int n) {
        this.minrows = n;
    }

    public int getMinimumRows() {
        return this.minrows;
    }

    public void setMinimumColumns(int n) {
        this.mincolumns = n;
    }

    public int getMinimumColumns() {
        return this.mincolumns;
    }

    public int getRows() {
        if (this.lineHeight == 0) {
            return 0;
        }
        Dimension dimension = this.size();
        int n = dimension.height - 2;
        return (n + this.lineHeight - 1) / this.lineHeight;
    }

    public void updateView() {
        for (int i = 0; i < this.numSelected; ++i) {
            if (this.selected[i] < this.items.size()) continue;
            this.shift(this.selected, i + 1, this.numSelected, -1);
            --this.numSelected;
        }
        this.cacheMinWidth();
        this.repaint();
    }

    private void shift(int[] nArray, int n, int n2, int n3) {
        System.arraycopy(nArray, n, nArray, n + n3, n2 - n);
    }

    public void select(int n) {
        if (n >= this.items.size()) {
            return;
        }
        if (n < -1) {
            return;
        }
        if (!this.multipleSelections) {
            if (n == -1) {
                if (this.numSelected != 0) {
                    this.numSelected = 0;
                    this.repaint();
                }
            } else {
                if (this.numSelected == 0) {
                    this.selected = this.ensureCapacity(this.selected, this.numSelected, 1);
                    this.numSelected = 1;
                    this.selected[0] = -1;
                }
                if (this.selected[0] != n) {
                    this.selected[0] = n;
                    this.repaint();
                }
            }
        } else {
            if (n == -1) {
                return;
            }
            boolean bl = false;
            for (int i = 0; i < this.numSelected; ++i) {
                if (n == this.selected[i]) {
                    bl = true;
                    break;
                }
                if (n >= this.selected[i]) continue;
                bl = true;
                this.selected = this.ensureCapacity(this.selected, this.numSelected, this.numSelected + 1);
                this.shift(this.selected, i, this.numSelected, 1);
                this.selected[i] = n;
                ++this.numSelected;
                this.repaint();
                break;
            }
            if (!bl) {
                this.selected = this.ensureCapacity(this.selected, this.numSelected, this.numSelected + 1);
                this.selected[this.numSelected] = n;
                ++this.numSelected;
                this.repaint();
            }
        }
    }

    public void select(Object object) {
        if (object != null) {
            this.select(this.items.indexOf(object));
        }
    }

    public void deselect(int n) {
        if (n < 0 || n >= this.items.size()) {
            return;
        }
        for (int i = 0; i < this.numSelected; ++i) {
            if (this.selected[i] != n) continue;
            this.shift(this.selected, i + 1, this.numSelected, -1);
            --this.numSelected;
            this.repaint();
            break;
        }
    }

    public void deselectAll() {
        if (this.numSelected != 0) {
            this.numSelected = 0;
            this.repaint();
        }
    }

    public boolean isSelected(int n) {
        for (int i = 0; i < this.numSelected; ++i) {
            if (this.selected[i] != n) continue;
            return true;
        }
        return false;
    }

    public void setMultipleSelections(boolean bl) {
        this.multipleSelections = bl;
    }

    public boolean allowsMultipleSelections() {
        return this.multipleSelections;
    }

    public int getSelectedIndex() {
        if (this.numSelected == 0) {
            return -1;
        }
        return this.selected[0];
    }

    public int[] getSelectedIndexes() {
        int[] nArray = new int[this.numSelected];
        System.arraycopy(this.selected, 0, nArray, 0, this.numSelected);
        return nArray;
    }

    public Object getSelectedItem() {
        if (this.numSelected == 0) {
            return null;
        }
        return this.items.elementAt(this.selected[0]);
    }

    public Object[] getSelectedItems() {
        Object[] objectArray = new Object[this.numSelected];
        for (int i = 0; i < this.numSelected; ++i) {
            objectArray[i] = this.items.elementAt(this.selected[i]);
        }
        return objectArray;
    }

    private int[] ensureCapacity(int[] nArray, int n, int n2) {
        int n3 = nArray.length;
        if (n2 > n3) {
            int[] nArray2 = nArray;
            int n4 = n3 * 2;
            if (n4 < n2) {
                n4 = n2;
            }
            nArray = new int[n4];
            System.arraycopy(nArray2, 0, nArray, 0, n);
        }
        return nArray;
    }

    protected void items(Vector vector) {
        this.items = vector;
    }

    public Dimension minimumSize() {
        int n = this.getBD();
        return new Dimension(this.minWidth + n, this.minrows * this.lineHeight + n);
    }

    public Dimension preferredSize() {
        return this.minimumSize();
    }

    public void scrollX(int n) {
        this.scrollx = n;
        this.repaint();
    }

    public void scrollY(int n) {
        this.scrolly = n;
        this.repaint();
    }

    public Dimension scrollSize() {
        return new Dimension(this.minWidth, this.items.size() * this.lineHeight);
    }

    public Dimension viewSize(Dimension dimension) {
        int n = this.getBD();
        dimension.width -= n;
        dimension.height -= n;
        return dimension;
    }

    public int lineHeight() {
        return this.lineHeight;
    }

    private int getBD() {
        return 4;
    }

    public boolean mouseDown(Event event, int n, int n2) {
        if (this.menuChoice != null && !this.menuDrag) {
            return true;
        }
        this.selectY(event, true);
        this.menuMode = false;
        this.menuChoice = null;
        this.menuDrag = false;
        return true;
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        if (!Global.isWindows() || event.y != -1) {
            if (this.menuMode) {
                this.menuDrag = true;
                this.menuEvent(event);
            } else if (!this.multipleSelections) {
                this.selectY(event, true);
            }
        }
        return true;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        if (this.menuMode) {
            this.menuEvent(event);
        }
        return true;
    }

    public boolean mouseMove(Event event, int n, int n2) {
        if (this.menuMode) {
            this.menuDrag = true;
            this.menuEvent(event);
            return true;
        }
        return false;
    }

    private void selectY(Event event, boolean bl) {
        int n = event.x;
        int n2 = event.y + this.scrolly - 2;
        int n3 = n2 / this.lineHeight;
        int n4 = this.items.size();
        if (n4 == 0) {
            return;
        }
        if (n3 >= n4) {
            n3 = n4 - 1;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        if (this.multipleSelections) {
            int n5;
            if (this.isSelected(n3)) {
                n5 = 702;
                this.deselect(n3);
            } else {
                n5 = 701;
                this.select(n3);
            }
            if (bl) {
                Event event2 = new Event(this.getParent(), n5, this.items.elementAt(n3));
                if (this.menuChoice != null) {
                    this.menuChoice.handleEvent(event2);
                } else {
                    this.postEvent(event2);
                }
            }
        } else {
            int n6 = 701;
            if (event.clickCount == 2 && !Global.isWindows() || event.modifiers == 4) {
                n6 = 1001;
            }
            if (!this.isSelected(n3)) {
                this.select(n3);
                this.repaint();
                if (bl) {
                    Event event3 = new Event(this.getParent(), n6, this.items.elementAt(n3));
                    if (this.menuChoice != null) {
                        this.menuChoice.handleEvent(event3);
                    } else {
                        this.postEvent(event3);
                    }
                }
            } else if ((event.id == 501 || event.id == 502) && bl) {
                Event event4 = new Event(this.getParent(), n6, this.items.elementAt(n3));
                if (this.menuChoice != null) {
                    this.menuChoice.handleEvent(event4);
                } else {
                    this.postEvent(event4);
                }
            }
        }
    }

    public void reshape(int n, int n2, int n3, int n4) {
        super.reshape(n, n2, n3, n4);
        this.cacheLineWidth();
        if (n3 <= 0 || n4 <= 0) {
            return;
        }
        if (this.buffer == null || n3 != this.buffer.getWidth(this) || n4 != this.buffer.getHeight(this)) {
            this.buffer = this.createImage(n3, n4);
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        if (this.buffer == null) {
            return;
        }
        graphics = this.buffer.getGraphics();
        graphics.setFont(this.getFont());
        Dimension dimension = this.size();
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        if (this.isEnabled()) {
            graphics.setColor(this.getForeground());
        } else {
            graphics.setColor(this.getBackground().darker());
        }
        this.drawItems(graphics);
        graphics.setColor(this.getBackground());
        this.drawBorder(graphics);
        graphics = this.getGraphics();
        graphics.drawImage(this.buffer, 0, 0, this);
    }

    private void drawItems(Graphics graphics) {
        Dimension dimension = this.size();
        int n = this.items.size();
        int n2 = 2;
        int n3 = this.scrolly;
        int n4 = this.scrolly + dimension.height;
        for (int i = 0; i < n; ++i) {
            int n5 = i * this.lineHeight;
            int n6 = n5 + this.lineHeight;
            if (n5 > n4 || n6 < n3) continue;
            int n7 = n5 - n3 + n2;
            this.drawLine(graphics, i, -this.scrollx + n2, n7);
        }
    }

    protected void drawLine(Graphics graphics, int n, int n2, int n3) {
        String string = (String)this.items.elementAt(n);
        int n4 = 6;
        int n5 = (this.lineHeight + this.fontHeight) / 2 - 1;
        if (this.isSelected(n)) {
            graphics.setColor(new Color(0, 0, 128));
            graphics.fillRect(n2, n3, this.lineWidth, this.lineHeight);
            graphics.setColor(Color.white);
        }
        graphics.drawString(string, n4 + n2, n5 + n3);
        if (this.isSelected(n)) {
            graphics.setColor(this.getForeground());
        }
    }

    private void drawBorder(Graphics graphics) {
        Dimension dimension = this.size();
        for (int i = 0; i < 2; ++i) {
            graphics.drawRect(0 + i, 0 + i, dimension.width - 1 - 2 * (i + 0), dimension.height - 1 - 2 * (i + 0));
        }
    }

    public void addNotify() {
        super.addNotify();
        this.cacheAll();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.stringWidthTable.clear();
        if (this.getPeer() != null) {
            this.cacheAll();
        }
    }

    private void cacheAll() {
        this.cacheLineHeight();
        this.cacheMinWidth();
    }

    protected void cacheMinWidth() {
        this.minWidth = this.mincolumns * this.getStringWidth("0");
        int n = this.items.size();
        for (int i = 0; i < n; ++i) {
            this.minWidth = Math.max(this.minWidth, this.getStringWidth((String)this.items.elementAt(i)));
        }
        this.minWidth += 12;
        this.cacheLineWidth();
    }

    protected int getStringWidth(String string) {
        if (this.fontMetrics == null) {
            return 0;
        }
        Integer n = (Integer)this.stringWidthTable.get(string);
        if (n == null) {
            n = new Integer(this.fontMetrics.stringWidth(string));
            this.stringWidthTable.put(string, n);
        }
        return n;
    }

    protected void cacheLineWidth() {
        Dimension dimension = this.size();
        int n = this.getBD();
        this.lineWidth = Math.max(this.minWidth, dimension.width - n);
    }

    protected void cacheLineHeight() {
        this.lineHeight = 0;
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            return;
        }
        Font font = this.getFont();
        if (font == null) {
            return;
        }
        this.fontMetrics = graphics.getFontMetrics(font);
        this.fontHeight = this.fontMetrics.getMaxAscent();
        this.lineHeight = this.fontHeight + 4;
    }

    void menuMode(CLChoice cLChoice) {
        this.menuChoice = cLChoice;
        this.menuMode = true;
        this.menuDrag = false;
        this.gotEventInside = false;
        this.prevMenuY = 0;
    }

    private void menuEvent(Event event) {
        if (this.checkBounds(event)) {
            this.selectY(event, event.id == 502);
            int n = this.getBD();
            if (event.id != 503 && (event.y < n && event.y < this.prevMenuY || event.y > this.size().height - n && event.y > this.prevMenuY)) {
                ((TextList)this.getParent()).makeVisible(this.getSelectedIndex());
            }
            this.prevMenuY = event.y;
        }
    }

    private boolean checkBounds(Event event) {
        if (!this.gotEventInside) {
            Dimension dimension = this.size();
            int n = this.getBD();
            if (event.x >= n && event.y >= n && event.x <= dimension.width - n && event.y <= dimension.height - n) {
                this.gotEventInside = true;
            }
        }
        return this.gotEventInside;
    }
}

