/*
 * Decompiled with CFR 0.152.
 */
package sunsoft.jws.visual.rt.base;

import java.util.Enumeration;
import java.util.Vector;
import sunsoft.jws.visual.rt.base.AMContainer;
import sunsoft.jws.visual.rt.base.AttributeManager;
import sunsoft.jws.visual.rt.base.DesignerAccess;
import sunsoft.jws.visual.rt.base.Global;
import sunsoft.jws.visual.rt.base.Group;
import sunsoft.jws.visual.rt.base.Root;
import sunsoft.jws.visual.rt.base.Shadow;

public class AMContainerHelper {
    private AMContainer container;
    private Vector children;

    public AMContainerHelper(AMContainer aMContainer) {
        this.container = aMContainer;
        this.children = new Vector();
    }

    public Vector getChildren() {
        return this.children;
    }

    public Enumeration getChildList() {
        return ((Vector)this.children.clone()).elements();
    }

    public int getChildCount() {
        return this.children.size();
    }

    public void add(AttributeManager attributeManager) {
        if (attributeManager != null && !this.children.contains(attributeManager)) {
            Object object;
            if (attributeManager instanceof AMContainer) {
                object = this.container;
                while (object != null) {
                    if (object == attributeManager) {
                        throw new IllegalArgumentException(Global.getMsg("sunsoft.jws.visual.rt.base.AMContainerHelper.adding__container's__p.0"));
                    }
                    object = ((AttributeManager)object).getParent();
                }
            }
            if (attributeManager.getParent() != null) {
                attributeManager.getParent().remove(attributeManager);
            }
            attributeManager.setParent(this.container);
            this.children.addElement(attributeManager);
            this.recurseCheckAdd(attributeManager);
            if (attributeManager instanceof Shadow && ((Shadow)attributeManager).getBody() != null) {
                this.container.addChildBody((Shadow)attributeManager);
            }
            if (((AttributeManager)(object = (AttributeManager)((Object)this.container))).isLayoutMode() != attributeManager.isLayoutMode()) {
                if (((AttributeManager)object).isLayoutMode()) {
                    attributeManager.layoutMode();
                } else {
                    attributeManager.previewMode();
                }
            }
        }
    }

    private void recurseCheckAdd(AttributeManager attributeManager) {
        Root root = attributeManager.getRoot();
        if (root != null && attributeManager.get("name") == null && ((Boolean)root.get("autoNaming")).booleanValue()) {
            attributeManager.set("name", root.getUniqueName(attributeManager));
        }
        if (attributeManager instanceof Group) {
            if (attributeManager.getRoot() != null) {
                Group group = attributeManager.getRoot().getGroup();
                if (group != null) {
                    group.add((Group)attributeManager);
                }
                ((Group)attributeManager).setParentBody();
            }
        } else if (attributeManager instanceof AMContainer) {
            AMContainer aMContainer = (AMContainer)((Object)attributeManager);
            Enumeration enumeration = aMContainer.getChildList();
            while (enumeration.hasMoreElements()) {
                this.recurseCheckAdd((AttributeManager)enumeration.nextElement());
            }
        }
    }

    public void remove(AttributeManager attributeManager) {
        if (attributeManager != null) {
            if (attributeManager.getParent() != this.container) {
                return;
            }
            Root root = attributeManager.getRoot();
            if (root != null && root.isLoadedRoot()) {
                DesignerAccess.setChangesMade(true);
            }
            if (attributeManager instanceof Shadow && ((Shadow)attributeManager).getBody() != null) {
                this.container.removeChildBody((Shadow)attributeManager);
            }
            this.recurseCheckRemove(attributeManager);
            attributeManager.setParent(null);
            this.children.removeElement(attributeManager);
        }
    }

    private void recurseCheckRemove(AttributeManager attributeManager) {
        if (attributeManager instanceof Group) {
            if (attributeManager.getRoot() != null) {
                Group group = attributeManager.getRoot().getGroup();
                if (group != null) {
                    group.remove((Group)attributeManager);
                }
                ((Group)attributeManager).unsetParentBody();
            }
        } else if (attributeManager instanceof AMContainer) {
            AMContainer aMContainer = (AMContainer)((Object)attributeManager);
            Enumeration enumeration = aMContainer.getChildList();
            while (enumeration.hasMoreElements()) {
                this.recurseCheckRemove((AttributeManager)enumeration.nextElement());
            }
        }
    }

    public AttributeManager getChild(String string) {
        if (string != null) {
            Enumeration enumeration = this.children.elements();
            while (enumeration.hasMoreElements()) {
                AttributeManager attributeManager = (AttributeManager)enumeration.nextElement();
                if (!string.equals(attributeManager.get("name"))) continue;
                return attributeManager;
            }
        }
        return null;
    }

    public void createChildren() {
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            AttributeManager attributeManager = (AttributeManager)enumeration.nextElement();
            if (attributeManager.hasAttribute("visible")) {
                Boolean bl = (Boolean)attributeManager.get("visible");
                if (!bl.booleanValue()) continue;
                attributeManager.create();
                continue;
            }
            attributeManager.create();
        }
    }

    public void destroyChildren() {
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            ((AttributeManager)enumeration.nextElement()).destroy();
        }
    }

    public void reparentChildren() {
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            AttributeManager attributeManager = (AttributeManager)enumeration.nextElement();
            if (!(attributeManager instanceof Shadow) || ((Shadow)attributeManager).getBody() == null) continue;
            this.container.addChildBody((Shadow)attributeManager);
        }
    }

    public void layoutMode() {
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            AttributeManager attributeManager = (AttributeManager)enumeration.nextElement();
            attributeManager.layoutMode();
        }
    }

    public void previewMode() {
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            AttributeManager attributeManager = (AttributeManager)enumeration.nextElement();
            attributeManager.previewMode();
        }
    }

    public void preValidate() {
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            AttributeManager attributeManager = (AttributeManager)enumeration.nextElement();
            attributeManager.preValidate();
        }
    }
}

