/*
 * Decompiled with CFR 0.152.
 */
package sunsoft.jws.visual.rt.base;

import java.awt.Frame;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import sunsoft.jws.visual.rt.base.AMContainer;
import sunsoft.jws.visual.rt.base.AMContainerHelper;
import sunsoft.jws.visual.rt.base.AttributeManager;
import sunsoft.jws.visual.rt.base.Global;
import sunsoft.jws.visual.rt.base.Group;
import sunsoft.jws.visual.rt.base.Message;
import sunsoft.jws.visual.rt.base.RootObserver;
import sunsoft.jws.visual.rt.base.Shadow;
import sunsoft.jws.visual.rt.shadow.java.awt.BeanShadow;
import sunsoft.jws.visual.rt.shadow.java.awt.ComponentShadow;
import sunsoft.jws.visual.rt.shadow.java.awt.FrameShadow;
import sunsoft.jws.visual.rt.shadow.java.awt.JAShadowAccess;
import sunsoft.jws.visual.rt.shadow.java.awt.WindowShadow;

public class Root
extends AttributeManager
implements AMContainer {
    private AMContainerHelper containerHelper = new AMContainerHelper(this);
    private boolean isLoadedRoot = false;
    private Hashtable observers = new Hashtable();
    private Hashtable uniqueNameTable = null;
    private static final String[] reservedWords = new String[]{"abstract", "boolean", "break", "byte", "byvalue", "case", "cast", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "false", "final", "finally", "float", "for", "future", "generic", "goto", "if", "implements", "import", "inner", "instanceof", "int", "interface", "long", "native", "new", "null", "operator", "outer", "package", "private", "protected", "public", "rest", "return", "short", "static", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "var", "void", "volatile", "while", "containerHelper", "READONLY", "HIDDEN", "TRANSIENT", "CONTAINER", "attributes", "parent", "isCreated", "GROUP", "ROOT"};
    private Group group;
    private boolean eventForwardingDisabled;

    public Root() {
        this.attributes.add("generateClass", "java.lang.String", null, 0);
        this.attributes.add("generateDirectory", "java.lang.String", null, 0);
        this.attributes.add("generatePackage", "java.lang.String", null, 0);
        this.attributes.add("willGenerateGUI", "java.lang.Boolean", Boolean.TRUE, 0);
        this.attributes.add("willGenerateMain", "java.lang.Boolean", Boolean.TRUE, 0);
        this.attributes.add("willGenerateGroup", "java.lang.Boolean", Boolean.FALSE, 0);
        this.attributes.add("willGenerateHTML", "java.lang.Boolean", Boolean.FALSE, 0);
        this.attributes.add("suffixForGUIClass", "java.lang.String", "Root", 0);
        this.attributes.add("suffixForMainClass", "java.lang.String", "Main", 0);
        this.attributes.add("suffixForOpsClass", "java.lang.String", "Ops", 0);
        this.attributes.add("suffixForGroupClass", "java.lang.String", "", 0);
        this.attributes.add("showGenerateConsole", "java.lang.Boolean", Boolean.TRUE, 0);
        this.attributes.add("groupType", "java.lang.String", null, 0);
        this.attributes.add("appletSize", "java.awt.Dimension", null, 0);
        this.attributes.add("autoNaming", "java.lang.Boolean", Boolean.TRUE, 6);
        this.set("name", this.getUniqueName(this));
    }

    protected String getUserTypeName() {
        return "root";
    }

    void setLoadedRoot(boolean bl) {
        this.isLoadedRoot = bl;
    }

    public boolean isLoadedRoot() {
        return this.isLoadedRoot;
    }

    void setMainChild(AttributeManager attributeManager, boolean bl) {
        AttributeManager attributeManager2 = this.getMainChild();
        if (attributeManager instanceof FrameShadow && !((FrameShadow)attributeManager).isPanel() && bl && attributeManager.get("menubar") != null) {
            attributeManager.set("menubar", null);
        }
        WindowShadow windowShadow = null;
        WindowShadow windowShadow2 = null;
        if (attributeManager instanceof WindowShadow) {
            windowShadow = (WindowShadow)attributeManager;
        }
        if (attributeManager2 instanceof WindowShadow) {
            windowShadow2 = (WindowShadow)attributeManager2;
        }
        if (attributeManager2 == attributeManager) {
            if (windowShadow != null) {
                windowShadow.isPanel(bl);
                windowShadow.show();
            }
        } else {
            Vector vector;
            if (windowShadow2 != null) {
                windowShadow2.isPanel(false);
            }
            this.observerSelect(attributeManager2);
            if (windowShadow != null) {
                windowShadow.isPanel(bl);
                windowShadow.show();
            }
            if (!(vector = this.containerHelper.getChildren()).removeElement(attributeManager)) {
                throw new Error(Global.fmtMsg("sunsoft.jws.visual.rt.base.Root.RootMissingContainer", this.getName(), attributeManager.getName()));
            }
            vector.insertElementAt(attributeManager, 0);
        }
        this.observerReload();
        this.observerSelect(attributeManager);
    }

    public AttributeManager getMainChild() {
        Vector vector = this.containerHelper.getChildren();
        if (vector.size() > 0) {
            return (AttributeManager)vector.elementAt(0);
        }
        return null;
    }

    void addRootObserver(RootObserver rootObserver) {
        if (rootObserver == null) {
            return;
        }
        if (this.observers.put(rootObserver, rootObserver) != null) {
            return;
        }
        rootObserver.clear();
        Enumeration enumeration = this.getChildList();
        while (enumeration.hasMoreElements()) {
            AttributeManager attributeManager = (AttributeManager)enumeration.nextElement();
            rootObserver.add(attributeManager);
        }
    }

    void removeRootObserver(RootObserver rootObserver) {
        if (rootObserver == null) {
            return;
        }
        this.observers.remove(rootObserver);
    }

    private void observerAdd(AttributeManager attributeManager) {
        if (!(attributeManager instanceof WindowShadow || attributeManager instanceof Group || attributeManager instanceof BeanShadow)) {
            return;
        }
        Enumeration enumeration = this.observers.elements();
        while (enumeration.hasMoreElements()) {
            ((RootObserver)enumeration.nextElement()).add(attributeManager);
        }
    }

    private void observerRemove(AttributeManager attributeManager) {
        if (!(attributeManager instanceof WindowShadow || attributeManager instanceof Group || attributeManager instanceof BeanShadow)) {
            return;
        }
        Enumeration enumeration = this.observers.elements();
        while (enumeration.hasMoreElements()) {
            ((RootObserver)enumeration.nextElement()).remove(attributeManager);
        }
    }

    private void observerSelect(AttributeManager attributeManager) {
        Enumeration enumeration = this.observers.elements();
        while (enumeration.hasMoreElements()) {
            ((RootObserver)enumeration.nextElement()).select(attributeManager);
        }
    }

    private void observerReload() {
        Enumeration enumeration = this.observers.elements();
        while (enumeration.hasMoreElements()) {
            RootObserver rootObserver = (RootObserver)enumeration.nextElement();
            rootObserver.clear();
            Enumeration enumeration2 = this.containerHelper.getChildren().elements();
            while (enumeration2.hasMoreElements()) {
                rootObserver.add((AttributeManager)enumeration2.nextElement());
            }
        }
    }

    void clearUniqueNameTable() {
        this.uniqueNameTable = null;
    }

    boolean isUniqueName(String string) {
        return this.isUniqueName(this, string, null, null);
    }

    boolean isUniqueName(String string, AttributeManager attributeManager) {
        return this.isUniqueName(this, string, attributeManager, null);
    }

    boolean isUniqueName(String string, AttributeManager attributeManager, AttributeManager attributeManager2) {
        return this.isUniqueName(this, string, attributeManager, attributeManager2);
    }

    private boolean isUniqueName(AttributeManager attributeManager, String string, AttributeManager attributeManager2, AttributeManager attributeManager3) {
        if (attributeManager == attributeManager3) {
            return true;
        }
        if (attributeManager != attributeManager2 && string.equals(attributeManager.get("name"))) {
            return false;
        }
        if (attributeManager instanceof AMContainer) {
            AMContainer aMContainer = (AMContainer)((Object)attributeManager);
            Enumeration enumeration = aMContainer.getChildList();
            while (enumeration.hasMoreElements()) {
                attributeManager = (AttributeManager)enumeration.nextElement();
                if (this.isUniqueName(attributeManager, string, attributeManager2, attributeManager3)) continue;
                return false;
            }
        }
        return true;
    }

    static boolean isValidName(String string) {
        int n;
        if (string == null || string.length() == 0) {
            return false;
        }
        for (n = 0; n < reservedWords.length; ++n) {
            if (!string.equals(reservedWords[n])) continue;
            return false;
        }
        for (n = 0; n < string.length(); ++n) {
            if (n == 0 && !Character.isJavaIdentifierStart(string.charAt(n))) {
                return false;
            }
            if (Character.isJavaIdentifierPart(string.charAt(n))) continue;
            return false;
        }
        return true;
    }

    String getUniqueName(AttributeManager attributeManager) {
        if (this.uniqueNameTable == null) {
            this.uniqueNameTable = new Hashtable();
        }
        String string = attributeManager.getUserTypeName();
        String string2 = null;
        while (string2 == null || !this.isUniqueName(string2) || !Root.isValidName(string2)) {
            if (this.uniqueNameTable.containsKey(string)) {
                int n = (Integer)this.uniqueNameTable.get(string);
                this.uniqueNameTable.put(string, new Integer(n + 1));
                string2 = string + Integer.toString(n);
                continue;
            }
            this.uniqueNameTable.put(string, new Integer(2));
            string2 = string + "1";
        }
        return string2;
    }

    String getUniqueName(AttributeManager attributeManager, Root root) {
        String string = this.getUniqueName(attributeManager);
        while (!root.isUniqueName(string)) {
            string = this.getUniqueName(attributeManager);
        }
        return string;
    }

    String getProblemWithName(String string) {
        String string2 = null;
        if (string == null || string.length() == 0) {
            string2 = Global.getMsg("sunsoft.jws.visual.rt.base.Root.NeedName");
        } else if (!this.isUniqueName(string)) {
            string2 = Global.fmtMsg("sunsoft.jws.visual.rt.base.Root.NotUniqueName", string);
        } else if (!Root.isValidName(string)) {
            string2 = Global.fmtMsg("sunsoft.jws.visual.rt.base.Root.NotValidName", string);
        }
        return string2;
    }

    public AttributeManager resolve(String string) {
        if (string == null) {
            return null;
        }
        if (string.equals("GROUP")) {
            return this.group;
        }
        if (string.equals("ROOT")) {
            return this;
        }
        return super.resolve(string);
    }

    public void add(AttributeManager attributeManager) {
        this.containerHelper.add(attributeManager);
        this.observerAdd(attributeManager);
    }

    public void remove(AttributeManager attributeManager) {
        this.containerHelper.remove(attributeManager);
        this.observerRemove(attributeManager);
    }

    public void addChildBody(Shadow shadow) {
        if (shadow instanceof WindowShadow) {
            return;
        }
        if (this.group == null) {
            return;
        }
        AMContainer aMContainer = this.group.getParent();
        if (aMContainer == null) {
            return;
        }
        if (shadow != null && shadow.getBody() != null) {
            aMContainer.addChildBody(shadow);
        }
    }

    public void updateContainerAttribute(AttributeManager attributeManager, String string, Object object) {
        if (this.group == null) {
            return;
        }
        AMContainer aMContainer = this.group.getParent();
        if (aMContainer == null) {
            return;
        }
        aMContainer.updateContainerAttribute(attributeManager, string, object);
    }

    public void removeChildBody(Shadow shadow) {
        if (shadow instanceof WindowShadow) {
            return;
        }
        if (this.group == null) {
            return;
        }
        AMContainer aMContainer = this.group.getParent();
        if (aMContainer == null) {
            return;
        }
        if (shadow != null && shadow.getBody() != null) {
            aMContainer.removeChildBody(shadow);
        }
    }

    public void createChildren() {
        this.containerHelper.createChildren();
    }

    public void reparentChildren() {
        this.containerHelper.reparentChildren();
    }

    public void destroyChildren() {
        this.containerHelper.destroyChildren();
    }

    public AttributeManager getChild(String string) {
        return this.containerHelper.getChild(string);
    }

    public Enumeration getChildList() {
        return this.containerHelper.getChildList();
    }

    public int getChildCount() {
        return this.containerHelper.getChildCount();
    }

    public void setGroup(Group group) {
        if (this.group != null) {
            this.group.removeRootChildren(this);
        }
        this.group = group;
        if (this.group != null) {
            this.group.addRootChildren(this);
        }
    }

    public Group getGroup() {
        return this.group;
    }

    void setCursor(int n) {
        Enumeration enumeration = this.getChildList();
        while (enumeration.hasMoreElements()) {
            FrameShadow frameShadow;
            Frame frame;
            AttributeManager attributeManager = (AttributeManager)enumeration.nextElement();
            if (!(attributeManager instanceof FrameShadow) || (frame = (Frame)(frameShadow = (FrameShadow)attributeManager).getBody()) == null) continue;
            int n2 = frame.getCursorType();
            if (n == n2) {
                JAShadowAccess.incrCursor(frameShadow);
                continue;
            }
            if (n == 50000) {
                if (JAShadowAccess.decrCursor(frameShadow) != 0) continue;
                frame.setCursor(JAShadowAccess.getPrevCursor(frameShadow));
                JAShadowAccess.setPrevCursor(frameShadow, 0);
                continue;
            }
            JAShadowAccess.setPrevCursor(frameShadow, n2);
            frame.setCursor(n);
            frame.getToolkit().sync();
        }
    }

    public void showRoot() {
        Enumeration enumeration = this.getChildList();
        while (enumeration.hasMoreElements()) {
            Boolean bl;
            AttributeManager attributeManager;
            AttributeManager attributeManager2 = (AttributeManager)enumeration.nextElement();
            if (attributeManager2 instanceof ComponentShadow) {
                attributeManager = (ComponentShadow)attributeManager2;
                bl = (Boolean)((Shadow)attributeManager).get("visible");
                if (!bl.booleanValue()) continue;
                ((ComponentShadow)attributeManager).showComponent();
                continue;
            }
            if (!(attributeManager2 instanceof Group) || !(bl = (Boolean)((Group)(attributeManager = (Group)attributeManager2)).get("visible")).booleanValue()) continue;
            ((Group)attributeManager).internalShowGroup();
        }
    }

    public void hideRoot() {
        Enumeration enumeration = this.getChildList();
        while (enumeration.hasMoreElements()) {
            AttributeManager attributeManager = (AttributeManager)enumeration.nextElement();
            if (attributeManager instanceof ComponentShadow) {
                ((ComponentShadow)attributeManager).hideComponent();
                continue;
            }
            if (!(attributeManager instanceof Group)) continue;
            ((Group)attributeManager).internalHideGroup();
        }
    }

    public void postMessageToParent(Message message) {
        if (this.group != null && !this.eventForwardingDisabled) {
            this.group.postMessage(message);
        }
    }

    public void postMessage(Message message) {
        if (!this.handleMessage(message) && this.group != null && !this.eventForwardingDisabled) {
            this.group.postMessage(message);
        }
    }

    public void postEvent(Message message) {
        if (this.handleMessage(message)) {
            return;
        }
        if (this.group != null && !this.eventForwardingDisabled) {
            this.group.postMessage(message);
        }
    }

    void disableEventForwarding() {
        this.eventForwardingDisabled = true;
    }

    void enableEventForwarding() {
        this.eventForwardingDisabled = false;
    }

    public void layoutMode() {
        super.layoutMode();
        this.containerHelper.layoutMode();
    }

    public void previewMode() {
        super.previewMode();
        this.containerHelper.previewMode();
    }
}

