/*
 * Decompiled with CFR 0.152.
 */
package sunsoft.jws.visual.rt.encoding;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import sunsoft.jws.visual.rt.encoding.CRC16;

public class UCEncoder {
    private PrintStream pStream;
    private static final byte[] map_array = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 40, 41};
    private int sequence;
    private byte[] tmp = new byte[2];
    private CRC16 crc = new CRC16();

    protected int bytesPerAtom() {
        return 2;
    }

    protected int bytesPerLine() {
        return 48;
    }

    protected void encodeAtom(OutputStream outputStream, byte[] byArray, int n, int n2) throws IOException {
        byte by = byArray[n];
        byte by2 = n2 == 2 ? byArray[n + 1] : (byte)0;
        this.crc.update(by);
        if (n2 == 2) {
            this.crc.update(by2);
        }
        outputStream.write(map_array[(by >>> 2 & 0x38) + (by2 >>> 5 & 7)]);
        int n3 = 0;
        int n4 = 0;
        for (int i = 1; i < 256; i *= 2) {
            if ((by & i) != 0) {
                ++n3;
            }
            if ((by2 & i) == 0) continue;
            ++n4;
        }
        n3 = (n3 & 1) * 32;
        n4 = (n4 & 1) * 32;
        outputStream.write(map_array[(by & 0x1F) + n3]);
        outputStream.write(map_array[(by2 & 0x1F) + n4]);
    }

    protected void encodeLinePrefix(OutputStream outputStream, int n) throws IOException {
        outputStream.write(42);
        this.crc.value = 0;
        this.tmp[0] = (byte)n;
        this.tmp[1] = (byte)this.sequence;
        this.sequence = this.sequence + 1 & 0xFF;
        this.encodeAtom(outputStream, this.tmp, 0, 2);
    }

    protected void encodeLineSuffix(OutputStream outputStream) throws IOException {
        this.tmp[0] = (byte)(this.crc.value >>> 8 & 0xFF);
        this.tmp[1] = (byte)(this.crc.value & 0xFF);
        this.encodeAtom(outputStream, this.tmp, 0, 2);
        this.pStream.println();
    }

    protected void encodeBufferPrefix(OutputStream outputStream) throws IOException {
        this.sequence = 0;
        this.pStream = new PrintStream(outputStream);
    }

    public void encodeBuffer(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[this.bytesPerLine()];
        this.encodeBufferPrefix(outputStream);
        while ((n = this.readFully(inputStream, byArray)) != -1) {
            this.encodeLinePrefix(outputStream, n);
            for (int i = 0; i < n; i += this.bytesPerAtom()) {
                if (i + this.bytesPerAtom() <= n) {
                    this.encodeAtom(outputStream, byArray, i, this.bytesPerAtom());
                    continue;
                }
                this.encodeAtom(outputStream, byArray, i, n - i);
            }
            this.encodeLineSuffix(outputStream);
            if (n >= this.bytesPerLine()) continue;
        }
        this.encodeBufferSuffix(outputStream);
    }

    protected int readFully(InputStream inputStream, byte[] byArray) throws IOException {
        for (int i = 0; i < byArray.length; ++i) {
            int n = inputStream.read();
            if (n == -1) {
                return i;
            }
            byArray[i] = (byte)n;
        }
        return byArray.length;
    }

    protected void encodeBufferSuffix(OutputStream outputStream) throws IOException {
    }

    public String encodeBuffer(byte[] byArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            this.encodeBuffer(byteArrayInputStream, byteArrayOutputStream);
        }
        catch (Exception exception) {
            throw new Error("encodeBuffer internal error");
        }
        return byteArrayOutputStream.toString();
    }
}

