/*
 * Decompiled with CFR 0.152.
 */
package sunsoft.jws.visual.rt.type;

import java.util.Hashtable;
import sunsoft.jws.visual.rt.base.Attribute;
import sunsoft.jws.visual.rt.base.Global;
import sunsoft.jws.visual.rt.base.VJException;
import sunsoft.jws.visual.rt.type.TypeEditor;

public abstract class Converter {
    private static Hashtable converterNameTable = new Hashtable();
    private static Hashtable converterInstanceTable = new Hashtable();
    private static Hashtable typeEditorNameTable;
    protected String converterType;
    private static final int TOSTRING = 0;
    private static final int TOCODE = 1;
    private boolean[] converting = new boolean[]{false, false};
    private boolean[] isBuffered = new boolean[]{false, false};
    private int[] convertRecurse = new int[]{0, 0};
    private static final String indentString = "  ";
    private static int indentLevel;

    public static void addConverter(String string, String string2) {
        converterNameTable.put(string, string2);
    }

    public static Converter getConverter(String string) {
        Converter converter = (Converter)converterInstanceTable.get(string);
        if (converter != null) {
            return converter;
        }
        String string2 = (String)converterNameTable.get(string);
        if (string2 == null) {
            Converter.loadType(string);
            string2 = (String)converterNameTable.get(string);
        }
        if (string2 == null && (string2 = (String)converterNameTable.get("unknown")) == null) {
            throw new Error(Global.getMsg("sunsoft.jws.visual.rt.type.Converter.No__converter__defined.20"));
        }
        try {
            Class<?> clazz = Class.forName(string2);
            converter = (Converter)clazz.newInstance();
            converter.setConverterType(string);
            converterInstanceTable.put(string, converter);
            return converter;
        }
        catch (Exception exception) {
            throw new Error(exception.getMessage());
        }
    }

    private static void loadType(String string) {
        if (string.charAt(0) == '[') {
            int n;
            int n2 = string.length();
            for (n = 0; n < n2 && string.charAt(n) == '['; ++n) {
            }
            if (++n < n2) {
                string = string.substring(n, n2 - 1);
            }
        }
        try {
            Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println(Global.getMsg("sunsoft.jws.visual.rt.type.Converter.Class__not__found__for__.21") + string + "\".");
        }
    }

    public static boolean hasConverter(String string) {
        return converterNameTable.containsKey(string);
    }

    public static void addTypeEditor(String string, String string2) {
        typeEditorNameTable.put(string, string2);
    }

    public static boolean hasTypeEditor(String string) {
        return typeEditorNameTable.containsKey(string);
    }

    public static TypeEditor newTypeEditor(String string) {
        String string2 = (String)typeEditorNameTable.get(string);
        if (string2 != null) {
            try {
                Class<?> clazz = Class.forName(string2);
                return (TypeEditor)clazz.newInstance();
            }
            catch (Exception exception) {
                throw new VJException(Global.newline() + "    " + exception.toString());
            }
        }
        return null;
    }

    public boolean hasTypeEditor() {
        return Converter.hasTypeEditor(this.getConverterType());
    }

    public TypeEditor newTypeEditor() {
        return Converter.newTypeEditor(this.getConverterType());
    }

    protected void setConverterType(String string) {
        this.converterType = string;
    }

    public String getConverterType() {
        return this.converterType;
    }

    public String convertToString(Object object) {
        this.enterConvert(0, false);
        StringBuffer stringBuffer = new StringBuffer();
        this.convertToString(object, stringBuffer);
        this.exitConvert(0, false);
        return stringBuffer.toString();
    }

    public void convertToString(Object object, StringBuffer stringBuffer) {
        this.enterConvert(0, true);
        stringBuffer.append(this.convertToString(object));
        this.exitConvert(0, true);
    }

    public abstract Object convertFromString(String var1);

    public void convertToCodeBlock(String string, Attribute attribute, int n, StringBuffer stringBuffer) {
        Converter converter = Converter.getConverter(attribute.getType());
        Converter.indent(stringBuffer, n);
        stringBuffer.append(string);
        stringBuffer.append(".set(\"");
        String string2 = attribute.getName();
        stringBuffer.append(string2);
        stringBuffer.append("\", ");
        stringBuffer.append(converter.convertToCode(attribute.getValue()));
        stringBuffer.append(");");
        Converter.newline(stringBuffer);
    }

    public String convertToCode(Object object) {
        if (object != null) {
            return "convert(\"" + object.getClass().getName() + "\", \"" + this.convertToString(object) + "\")";
        }
        return "null";
    }

    public String displayString(Object object) {
        return this.convertToString(object);
    }

    public boolean viewableAsString() {
        return true;
    }

    public boolean editableAsString() {
        return this.viewableAsString();
    }

    private void enterConvert(int n, boolean bl) {
        if (this.converting[n] && this.isBuffered[n] != bl) {
            throw new Error(Global.getMsg("sunsoft.jws.visual.rt.type.Converter.Sub-classes__of__Conve.22"));
        }
        this.isBuffered[n] = bl;
        this.converting[n] = true;
        int n2 = n;
        this.convertRecurse[n2] = this.convertRecurse[n2] + 1;
    }

    private void exitConvert(int n, boolean bl) {
        if (!this.converting[n]) {
            throw new Error(Global.getMsg("sunsoft.jws.visual.rt.type.Converter.Convert__exit__without.25"));
        }
        if (this.isBuffered[n] != bl) {
            throw new Error(Global.getMsg("sunsoft.jws.visual.rt.type.Converter.isBuffered__mismatch__.26"));
        }
        int n2 = n;
        this.convertRecurse[n2] = this.convertRecurse[n2] - 1;
        if (this.convertRecurse[n] == 0) {
            this.converting[n] = false;
        }
    }

    public static String newline() {
        return Global.newline();
    }

    public static void newline(StringBuffer stringBuffer) {
        Global.newline(stringBuffer);
    }

    protected static void indent(StringBuffer stringBuffer) {
        for (int i = 0; i < indentLevel; ++i) {
            stringBuffer.append(indentString);
        }
    }

    protected static void indent(StringBuffer stringBuffer, int n) {
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(' ');
        }
    }

    protected static void incrIndent() {
        ++indentLevel;
    }

    protected static void decrIndent() {
        --indentLevel;
    }

    protected static int indentLevel() {
        return indentLevel;
    }

    public static String shortClassName(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    static {
        Converter.addConverter("[I", "sunsoft.jws.visual.rt.type.IntArrayConverter");
        Converter.addConverter("[D", "sunsoft.jws.visual.rt.type.DoubleArrayConverter");
        Converter.addConverter("java.lang.String", "sunsoft.jws.visual.rt.type.StringConverter");
        Converter.addConverter("[Ljava.lang.String;", "sunsoft.jws.visual.rt.type.StringArrayConverter");
        Converter.addConverter("java.lang.Boolean", "sunsoft.jws.visual.rt.type.BooleanConverter");
        Converter.addConverter("java.lang.Character", "sunsoft.jws.visual.rt.type.CharacterConverter");
        Converter.addConverter("java.lang.Integer", "sunsoft.jws.visual.rt.type.IntegerConverter");
        Converter.addConverter("java.awt.Color", "sunsoft.jws.visual.rt.type.ColorConverter");
        Converter.addConverter("java.awt.SystemColor", "sunsoft.jws.visual.rt.type.ColorConverter");
        Converter.addConverter("java.awt.Font", "sunsoft.jws.visual.rt.type.FontConverter");
        Converter.addConverter("java.awt.Point", "sunsoft.jws.visual.rt.type.PointConverter");
        Converter.addConverter("java.awt.Dimension", "sunsoft.jws.visual.rt.type.DimensionConverter");
        Converter.addConverter("java.awt.Insets", "sunsoft.jws.visual.rt.type.InsetsConverter");
        Converter.addConverter("sunsoft.jws.visual.rt.awt.GBConstraints", "sunsoft.jws.visual.rt.type.GBConstraintsConverter");
        Converter.addConverter("sunsoft.jws.visual.rt.base.AttributeManager", "sunsoft.jws.visual.rt.type.AMConverter");
        Converter.addConverter("sunsoft.jws.visual.rt.type.AMRef", "sunsoft.jws.visual.rt.type.AMRefConverter");
        Converter.addConverter("sunsoft.jws.visual.rt.base.Attribute", "sunsoft.jws.visual.rt.type.AttributeConverter");
        Converter.addConverter("sunsoft.jws.visual.rt.base.AttributeList", "sunsoft.jws.visual.rt.type.AttributeListConverter");
        Converter.addConverter("sunsoft.jws.visual.rt.type.ImageRef", "sunsoft.jws.visual.rt.type.ImageRefConverter");
        Converter.addConverter("sunsoft.jws.visual.rt.type.AlignmentEnum", "sunsoft.jws.visual.rt.type.BaseEnumConverter");
        Converter.addConverter("sunsoft.jws.visual.rt.type.AnchorEnum", "sunsoft.jws.visual.rt.type.BaseEnumConverter");
        Converter.addConverter("sunsoft.jws.visual.rt.type.OrientationEnum", "sunsoft.jws.visual.rt.type.BaseEnumConverter");
        Converter.addConverter("sunsoft.jws.visual.rt.type.ReliefEnum", "sunsoft.jws.visual.rt.type.BaseEnumConverter");
        Converter.addConverter("sunsoft.jws.visual.rt.type.ModeEnum", "sunsoft.jws.visual.rt.type.BaseEnumConverter");
        Converter.addConverter("unknown", "sunsoft.jws.visual.rt.type.UnknownTypeConverter");
        typeEditorNameTable = new Hashtable();
        indentLevel = 0;
    }
}

