/*
 * Decompiled with CFR 0.152.
 */
package sunsoft.jws.visual.rt.type;

import java.awt.Dimension;
import java.util.Enumeration;
import java.util.Hashtable;
import sunsoft.jws.visual.rt.base.Global;
import sunsoft.jws.visual.rt.type.Converter;
import sunsoft.jws.visual.rt.type.ParseException;
import sunsoft.jws.visual.rt.type.SubFieldTokenizer;

public class DimensionConverter
extends Converter {
    public String convertToString(Object object) {
        if (object == null) {
            return "";
        }
        Dimension dimension = (Dimension)object;
        return "width=" + dimension.width + ";height=" + dimension.height;
    }

    public Object convertFromString(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        SubFieldTokenizer subFieldTokenizer = new SubFieldTokenizer(string);
        Hashtable hashtable = subFieldTokenizer.getHashtable();
        Dimension dimension = new Dimension();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (string2.equals("width") || string2.equals("height")) continue;
            throw new ParseException(Global.fmtMsg("sunsoft.jws.visual.rt.type.DimensionConverter.FMT.31", Global.getMsg("sunsoft.jws.visual.rt.type.DimensionConverter.illegal__dimension__value"), string2));
        }
        if (hashtable.containsKey("width")) {
            dimension.width = this.getIntegerFromTable(hashtable, "width");
        }
        if (hashtable.containsKey("height")) {
            dimension.height = this.getIntegerFromTable(hashtable, "height");
        }
        return dimension;
    }

    private int getIntegerFromTable(Hashtable hashtable, String string) {
        String string2 = (String)hashtable.get(string);
        if (string2 != null) {
            try {
                return Integer.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException(Global.getMsg("sunsoft.jws.visual.rt.type.DimensionConverter.Badly__formatted__dime.27") + string2);
            }
        }
        return 0;
    }

    public String convertToCode(Object object) {
        if (object == null) {
            return "new java.awt.Dimension()";
        }
        Dimension dimension = (Dimension)object;
        return "new java.awt.Dimension(" + dimension.width + ", " + dimension.height + ")";
    }
}

