/*
 * Decompiled with CFR 0.152.
 */
package sunsoft.jws.visual.rt.type;

import java.awt.Font;
import java.util.Hashtable;
import sunsoft.jws.visual.rt.base.Global;
import sunsoft.jws.visual.rt.type.Converter;
import sunsoft.jws.visual.rt.type.ParseException;
import sunsoft.jws.visual.rt.type.SubFieldTokenizer;

public class FontConverter
extends Converter {
    private static final int styleDefault = 0;
    private static final int sizeDefault = 12;

    public String convertToString(Object object) {
        String string;
        if (object == null) {
            return "";
        }
        Font font = (Font)object;
        switch (font.getStyle()) {
            case 0: {
                string = "plain";
                break;
            }
            case 1: {
                string = "bold";
                break;
            }
            case 2: {
                string = "italic";
                break;
            }
            default: {
                System.out.println(Global.getMsg("sunsoft.jws.visual.rt.type.FontConverter.Warning-co-__unknown__fon.29") + font.getStyle());
                string = "plain";
            }
        }
        return "name=" + font.getName() + ";style=" + string + ";size=" + font.getSize();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object convertFromString(String string) {
        int n;
        int n2;
        if (string == null || string.length() == 0) {
            return null;
        }
        SubFieldTokenizer subFieldTokenizer = new SubFieldTokenizer(string);
        Hashtable hashtable = subFieldTokenizer.getHashtable();
        String string2 = (String)hashtable.get("name");
        if (string2 == null || string2.length() <= 0) {
            throw new ParseException(Global.getMsg("sunsoft.jws.visual.rt.type.FontConverter.Missing__font__name-co-__") + string);
        }
        String string3 = (String)hashtable.get("style");
        if (string3 != null) {
            if (string3.equals("italic")) {
                n2 = 2;
            } else if (string3.equals("bold")) {
                n2 = 1;
            } else {
                if (!string3.equals("plain")) throw new ParseException(Global.getMsg("sunsoft.jws.visual.rt.type.FontConverter.Invalid__font__style-co-__.30") + string);
                n2 = 0;
            }
        } else {
            n2 = 0;
        }
        String string4 = (String)hashtable.get("size");
        if (string4 != null) {
            try {
                n = Integer.valueOf(string4);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException(Global.getMsg("sunsoft.jws.visual.rt.type.FontConverter.Invalid__font__size-co-__") + string);
            }
            if (n > 0) return new Font(string2, n2, n);
            throw new ParseException(Global.getMsg("sunsoft.jws.visual.rt.type.FontConverter.Negative__font__size-co-__.31") + string);
        }
        n = 12;
        return new Font(string2, n2, n);
    }
}

