/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.core.agent.ohinv.engine;

import java.util.Properties;
import oracle.sysman.core.agent.ohinv.HomeInfo;
import oracle.sysman.core.agent.ohinv.engine.BaseMetric;

class HomeInfoMetric
extends BaseMetric {
    public HomeInfoMetric(HomeInfo homeInfo) {
        this.values = new Properties();
        this.values.setProperty("LOCATION", homeInfo.getLocation());
        String homeName = homeInfo.getHomeName();
        if (homeName == null) {
            homeName = "";
        }
        this.values.setProperty("HOME_NAME", homeName);
        this.values.setProperty("HOME_TYPE", homeInfo.getHomeType());
        boolean isClonable = homeInfo.isClonable();
        this.values.setProperty("CLONABLE", isClonable ? "Y" : "N");
        boolean isCRS = homeInfo.isCRS();
        this.values.setProperty("IS_CRS", isCRS ? "Y" : "N");
        this.values.setProperty("ARU_ID", "-1");
        this.values.setProperty("OUI_PLATFORM", "-1");
    }

    static {
        columns = new String[]{"LOCATION", "HOME_NAME", "OUI_HOME_GUID", "HOME_TYPE", "HOME_POINTER", "CLONABLE", "IS_CRS", "ARU_ID", "OUI_PLATFORM", "HOME_SIZE", "HOME_RW_STATUS", "ORACLE_BASE", "OH_OWNER_ID", "OH_OWNER", "OH_GROUP_ID", "OH_GROUP", "OH_OWNER_GROUPS_ID", "OH_OWNER_GROUPS"};
    }
}

