/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.core.agent.ohinv.engine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import oracle.sysman.core.agent.PatchInfoProvider;
import oracle.sysman.core.agent.PatchInfoProviderFactory;
import oracle.sysman.core.agent.PatchInformation;
import oracle.sysman.core.agent.ProductInformation;
import oracle.sysman.core.agent.exceptions.PatchDataException;
import oracle.sysman.core.agent.exceptions.PatchSystemException;
import oracle.sysman.core.agent.ohinv.HomeInfo;
import oracle.sysman.core.agent.ohinv.engine.BugsFixedMetric;
import oracle.sysman.core.agent.ohinv.engine.ComponentMetric;
import oracle.sysman.core.agent.ohinv.engine.HomeInfoMetric;
import oracle.sysman.core.agent.ohinv.engine.MetricResultSet;
import oracle.sysman.core.agent.ohinv.engine.PatchMetric;
import oracle.sysman.core.agent.ohinv.engine.PatchedCompMetric;

public class OHConfigCollector {
    public static void main(String[] args) {
        String HOME_ARG = "--home";
        String METRIC_ARG = "--metric";
        String TYPE_ARG = "--type";
        String INV_ARG = "--inventory";
        String MWHOME_ARG = "--mw_home";
        String CLASS_ARG = "--class";
        String home_loc = null;
        String metric = null;
        String home_type = null;
        String inv_loc = null;
        String mw_home = null;
        String class_name = null;
        Properties params = new Properties();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("--home")) {
                home_loc = args[++i];
                continue;
            }
            if (args[i].equals("--metric")) {
                metric = args[++i];
                continue;
            }
            if (args[i].equals("--type")) {
                home_type = args[++i];
                continue;
            }
            if (args[i].equals("--inventory")) {
                inv_loc = args[++i];
                continue;
            }
            if (args[i].equals("--mw_home")) {
                mw_home = args[++i];
                continue;
            }
            if (!args[i].equals("--class")) continue;
            class_name = args[++i];
        }
        try {
            MetricResultSet resultSet = new MetricResultSet();
            if (metric.equals("HOME_INFO")) {
                HomeInfo homeInfo = new HomeInfo(home_loc, home_type);
                HomeInfoMetric homeInfoMetric = new HomeInfoMetric(homeInfo);
                resultSet.addRow(homeInfoMetric);
            } else if (metric.equals("COMPS")) {
                Map<ProductInformation, List<PatchInformation>> ppMap = OHConfigCollector.getAllProductMap(home_loc, class_name);
                Set<ProductInformation> productSet = ppMap.keySet();
                Iterator<ProductInformation> products = productSet.iterator();
                ArrayList<String> uniqueComps = new ArrayList<String>();
                String productName = null;
                String productVersion = null;
                String productKey = null;
                while (products.hasNext()) {
                    ProductInformation product = products.next();
                    productName = product.getProductName();
                    productVersion = product.getProductVersion();
                    productKey = productName + productVersion;
                    if (uniqueComps.contains(productKey)) continue;
                    uniqueComps.add(productKey);
                    ComponentMetric compMetric = new ComponentMetric(product);
                    resultSet.addRow(compMetric);
                }
            } else if (metric.equals("PATCHES")) {
                Map<ProductInformation, List<PatchInformation>> ppMap = OHConfigCollector.getAllProductMap(home_loc, class_name);
                ArrayList<List<PatchInformation>> patchLists = new ArrayList<List<PatchInformation>>(ppMap.values());
                ArrayList<PatchInformation> patches = new ArrayList<PatchInformation>();
                ArrayList<String> uniquePatches = new ArrayList<String>();
                String patchId = null;
                for (List<PatchInformation> patchList : patchLists) {
                    patches.addAll(patchList);
                }
                for (PatchInformation patch : patches) {
                    PatchMetric patchMetric;
                    if (home_type.equals("W")) {
                        String primaryBugId = patch.getPrimaryBugId();
                        if (uniquePatches.contains(primaryBugId)) continue;
                        uniquePatches.add(primaryBugId);
                        patchMetric = new PatchMetric(patch, primaryBugId);
                        resultSet.addRow(patchMetric);
                        continue;
                    }
                    patchId = patch.getPatchId();
                    if (uniquePatches.contains(patchId)) continue;
                    uniquePatches.add(patchId);
                    patchMetric = new PatchMetric(patch);
                    resultSet.addRow(patchMetric);
                }
            } else if (metric.equals("PATCH_COMPS")) {
                Map<ProductInformation, List<PatchInformation>> ppMap = OHConfigCollector.getAllProductMap(home_loc, class_name);
                ArrayList<List<PatchInformation>> patchLists = new ArrayList<List<PatchInformation>>(ppMap.values());
                ArrayList<PatchInformation> patches = new ArrayList<PatchInformation>();
                ArrayList<String> uniquePatchComps = new ArrayList<String>();
                String productName = null;
                String productVersion = null;
                String patchID = null;
                String patchCompKey = null;
                for (List<PatchInformation> patchList : patchLists) {
                    patches.addAll(patchList);
                }
                for (PatchInformation patch : patches) {
                    ProductInformation comp = patch.getProductInfo();
                    try {
                        productName = comp.getARUProductName();
                        productVersion = comp.getARUProductVersion();
                    }
                    catch (PatchDataException pde) {
                        productName = comp.getProductName();
                        productVersion = comp.getProductVersion();
                    }
                    if (uniquePatchComps.contains(patchCompKey = (patchID = home_type.equals("W") ? patch.getPrimaryBugId() : patch.getPatchId()) + productName + productVersion)) continue;
                    uniquePatchComps.add(patchCompKey);
                    PatchedCompMetric pcMetric = new PatchedCompMetric(patchID, "N/A", "en", productName, productVersion);
                    resultSet.addRow(pcMetric);
                }
            } else if (metric.equals("PATCH_BUGS")) {
                Map<ProductInformation, List<PatchInformation>> ppMap = OHConfigCollector.getAllProductMap(home_loc, class_name);
                ArrayList<List<PatchInformation>> patchLists = new ArrayList<List<PatchInformation>>(ppMap.values());
                ArrayList<PatchInformation> patches = new ArrayList<PatchInformation>();
                ArrayList<String> uniquePatchBugs = new ArrayList<String>();
                String patchBugKey = null;
                for (List<PatchInformation> patchList : patchLists) {
                    patches.addAll(patchList);
                }
                for (PatchInformation patch : patches) {
                    String primaryBugId;
                    if (home_type.equals("W") && (primaryBugId = patch.getPrimaryBugId()) != null && !uniquePatchBugs.contains(patchBugKey = primaryBugId + primaryBugId)) {
                        uniquePatchBugs.add(patchBugKey);
                        BugsFixedMetric bugMetric = new BugsFixedMetric(primaryBugId, "N/A", "en", primaryBugId);
                        resultSet.addRow(bugMetric);
                    }
                    try {
                        List<String> bugIds = patch.getBugIds();
                        String patchId = home_type.equals("W") ? patch.getPrimaryBugId() : patch.getPatchId();
                        for (String bugId : bugIds) {
                            patchBugKey = patchId + bugId;
                            if (uniquePatchBugs.contains(patchBugKey)) continue;
                            uniquePatchBugs.add(patchBugKey);
                            BugsFixedMetric bugMetric = new BugsFixedMetric(patchId, "N/A", "en", bugId);
                            resultSet.addRow(bugMetric);
                        }
                    }
                    catch (PatchDataException e) {
                    }
                }
            } else {
                System.exit(0);
            }
            resultSet.printRows();
        }
        catch (PatchDataException e) {
            // empty catch block
        }
    }

    private static Map<ProductInformation, List<PatchInformation>> getAllProductMap(String home_loc, String class_name) {
        HashMap<ProductInformation, List<PatchInformation>> allPPMap = new HashMap<ProductInformation, List<PatchInformation>>();
        try {
            Class<?> patchInfoProviderFactory = Class.forName(class_name);
            PatchInfoProviderFactory pipFactory = (PatchInfoProviderFactory)patchInfoProviderFactory.newInstance();
            PatchInfoProvider pInfoProvider = pipFactory.createPatchInfoProvider(home_loc);
            if (pInfoProvider != null) {
                Map<ProductInformation, List<PatchInformation>> ppMap = pInfoProvider.getAppliedPatchListByProduct();
                allPPMap.putAll(ppMap);
            }
        }
        catch (ClassNotFoundException e) {
            System.err.println("ClassNotFoundException " + e.getMessage());
        }
        catch (InstantiationException e) {
            System.err.println("InstantiationException " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            System.err.println("IllegalAccessException " + e.getMessage());
        }
        catch (PatchSystemException e) {
            System.err.println("PatchSystemException " + e.getMessage());
        }
        return allPPMap;
    }
}

