/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.core.agent.ohinv.engine;

import java.util.ArrayList;
import oracle.sysman.core.agent.ohinv.engine.UIDInfo;

public class OHOwnerInfo {
    private UIDInfo m_owner;
    private UIDInfo m_group;
    private ArrayList<UIDInfo> m_other_groups = new ArrayList();

    public OHOwnerInfo(int owner_id, String owner_name, int group_id, String group_name) {
        this.m_owner = new UIDInfo(owner_id, owner_name);
        this.m_group = new UIDInfo(group_id, group_name);
    }

    public void addOtherGroup(int group_id, String group_name) {
        this.m_other_groups.add(new UIDInfo(group_id, group_name));
    }

    public int getOwnerId() {
        if (null != this.m_owner) {
            return this.m_owner.id;
        }
        return -1;
    }

    public String getOwnerName() {
        if (null != this.m_owner) {
            return this.m_owner.name;
        }
        return "";
    }

    public int getGroupId() {
        if (null != this.m_group) {
            return this.m_group.id;
        }
        return -1;
    }

    public String getGroupName() {
        if (null != this.m_group) {
            return this.m_group.name;
        }
        return "";
    }

    public String getOtherGroupIds() {
        StringBuffer gids = null;
        for (UIDInfo group : this.m_other_groups) {
            if (gids == null) {
                gids = new StringBuffer("" + group.id);
                continue;
            }
            gids.append("," + group.id);
        }
        return gids.toString();
    }

    public String getOtherGroupNames() {
        StringBuffer gnames = null;
        for (UIDInfo group : this.m_other_groups) {
            if (gnames == null) {
                gnames = new StringBuffer("" + group.name);
                continue;
            }
            gnames.append("," + group.name);
        }
        return gnames.toString();
    }
}

