/*
 * Decompiled with CFR 0.152.
 */
package com.sun.swup.client.common;

import com.sun.cns.authentication.CMDExecutionException;
import com.sun.cns.authentication.CSMAuthenticator;
import com.sun.cns.authentication.NotAuthenticatedException;
import com.sun.swup.client.common.ExecuteCommand;
import com.sun.swup.client.common.UMData;
import java.util.Vector;

public class CCRUtils {
    public static final String ASSETID_CCR_KEY = "cns.assetid";
    public static final String PORTAL_MGMT_KEY = "cns.service.swupPortalMgmt.status";
    public static final String AUTO_ANALYSIS_KEY = "cns.swup.autoAnalysis.enabled";
    public static final String REGISTRATION_REQD_KEY = "cns.swup.regRequired";
    public static final String TRUE_CCR_VALUE = "true";
    public static final String FALSE_CCR_VALUE = "false";
    public static final String ENABLED_CCR_VALUE = "enabled";
    public static final String DISABLED_CCR_VALUE = "disabled";
    public static final String EMPTY_CCR_VALUE = "";
    private static final String CCR_EXECUTABLE = "/usr/lib/cc-ccr/bin/ccr";

    public static String getCCRValue(String key) {
        String value = EMPTY_CCR_VALUE;
        String ccrGetCommand = "/usr/lib/cc-ccr/bin/ccr -g " + key;
        ExecuteCommand executeCommand = new ExecuteCommand(ccrGetCommand);
        executeCommand.setCollectOutput(true);
        if (UMData.getDebug()) {
            System.out.println("getCCRValue() executing command: " + ccrGetCommand);
        }
        try {
            executeCommand.execute();
        }
        catch (InterruptedException iEx) {
            iEx.printStackTrace();
            return value;
        }
        String commandOutput = executeCommand.getOutput();
        int commandResult = executeCommand.getResult();
        if (commandResult == 0 && commandOutput != null) {
            value = commandOutput.trim();
        } else if (commandResult != 0 && UMData.getDebug()) {
            System.out.println("ERROR - nonzero error code returned by ccr get");
        }
        if (UMData.getDebug()) {
            System.out.println("CCR value of key " + key + ": " + value);
        }
        return value;
    }

    public static boolean setCCRValueAuthenticated(String key, String value) {
        Vector<String> args = new Vector<String>();
        args.add("ccr");
        args.add("-p");
        args.add(key);
        args.add("-v");
        args.add(value);
        try {
            CSMAuthenticator csmAuthenticator = CSMAuthenticator.getInstance();
            csmAuthenticator.runCMD(CCR_EXECUTABLE, args);
        }
        catch (CMDExecutionException we) {
            System.out.println("ERROR - CSMAuthenticator: command execution: " + we.getMessage());
            return false;
        }
        catch (NotAuthenticatedException nae) {
            System.out.println("ERROR - CSMAuthenticator: not authenticated");
            return false;
        }
        return true;
    }

    public static boolean setCCRValue(String key, String value) {
        String ccrSetCommand = "/usr/lib/cc-ccr/bin/ccr -p " + key + " -v " + value;
        ExecuteCommand executeCommand = new ExecuteCommand(ccrSetCommand);
        if (UMData.getDebug()) {
            System.out.println("setCCRValue() executing command: " + ccrSetCommand);
        }
        try {
            executeCommand.execute();
        }
        catch (InterruptedException iEx) {
            iEx.printStackTrace();
            return false;
        }
        int commandResult = executeCommand.getResult();
        if (commandResult != 0) {
            if (UMData.getDebug()) {
                System.out.println("ERROR - nonzero error code returned by ccr set, return code: " + commandResult);
            }
            return false;
        }
        return true;
    }

    public static final boolean isSystemRegistered() {
        String regRequired = CCRUtils.getCCRValue(REGISTRATION_REQD_KEY);
        if (regRequired != null && regRequired.equals(FALSE_CCR_VALUE)) {
            return true;
        }
        String assetId = CCRUtils.getCCRValue(ASSETID_CCR_KEY);
        return assetId != null && !assetId.equals(EMPTY_CCR_VALUE);
    }

    public static final boolean isPortalManagementEnabled() {
        String portalMgmt = CCRUtils.getCCRValue(PORTAL_MGMT_KEY);
        return portalMgmt != null && portalMgmt.equalsIgnoreCase(ENABLED_CCR_VALUE);
    }

    public static final boolean isAutoAnalysisEnabled() {
        String autoAnalysis = CCRUtils.getCCRValue(AUTO_ANALYSIS_KEY);
        return autoAnalysis != null && autoAnalysis.equalsIgnoreCase(TRUE_CCR_VALUE);
    }

    public static final boolean setAutoAnalysisEnabled(boolean enabled) {
        return CCRUtils.setCCRValueAuthenticated(AUTO_ANALYSIS_KEY, enabled ? TRUE_CCR_VALUE : FALSE_CCR_VALUE);
    }
}

