/*
 * Decompiled with CFR 0.152.
 */
package com.sun.swup.client.common;

import com.sun.swup.client.common.environment.Environment;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

class InformationPanel
extends JPanel {
    private JLabel messageLabel;
    private ImageIcon alertImageIcon;
    private String message;
    private String url;
    private JPanel msgSubPanel;
    private JPanel linkSubPanel;
    private JPanel imageSubPanel;
    private ImageIcon imageIcon;
    private JLabel imageLabel;

    InformationPanel(String url, String message) {
        this.message = this.convertMessageToHTML(message);
        this.url = url;
        this.createComponents();
        this.createLayout();
    }

    private void createComponents() {
        this.messageLabel = new JLabel(this.message);
        this.imageIcon = Environment.getImageIcon("info_medium.gif");
        this.imageLabel = new JLabel(this.imageIcon);
        this.imageSubPanel = new JPanel();
        this.linkSubPanel = new JPanel();
        this.linkSubPanel.setToolTipText(this.url);
        this.msgSubPanel = new JPanel();
    }

    private void createLayout() {
        this.setLayout(new BorderLayout());
        this.linkSubPanel.setLayout(new BorderLayout());
        this.linkSubPanel.add((Component)this.messageLabel, "North");
        this.imageSubPanel.add(this.imageLabel);
        this.msgSubPanel.setLayout(new BorderLayout());
        this.msgSubPanel.add((Component)this.imageSubPanel, "West");
        this.msgSubPanel.add((Component)this.linkSubPanel, "Center");
        this.add(this.msgSubPanel);
    }

    private String convertMessageToHTML(String message) {
        if (message == null) {
            return "";
        }
        String result = "<html>";
        String[] lines = message.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            result = result + lines[i] + "<br>";
        }
        result = result + "</html>";
        return result;
    }
}

