/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scn.client.comm;

import com.sun.scn.client.ui.Client;
import com.sun.scn.client.util.EncryptionHelper;
import com.sun.scn.servicetags.Agent;
import com.sun.scn.servicetags.SvcTag;
import com.sun.scn.servicetags.util.XMLUtil;
import com.sun.scn.util.XMLErrorSuppressor;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvcTagRunnable
implements Runnable {
    private static Logger log = Logger.getLogger(SvcTagRunnable.class.getName());
    private URL stUrl;
    private Agent agent;
    private Client client;
    private String targetProductURN;

    SvcTagRunnable(URL stUrl, Agent agent, Client client) {
        this.stUrl = stUrl;
        this.agent = agent;
        this.client = client;
        this.targetProductURN = null;
    }

    SvcTagRunnable(URL stUrl, Agent agent, String targetProductURN, Client client) {
        this.stUrl = stUrl;
        this.agent = agent;
        this.client = client;
        this.targetProductURN = targetProductURN;
    }

    @Override
    public void run() {
        try {
            this.test();
        }
        catch (Exception e) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Exception while gathering svctag: " + e.getMessage(), e);
            }
            System.err.println(e.getMessage());
        }
    }

    private void test() throws IOException, ParserConfigurationException, SAXException {
        List<SvcTag> svcTags;
        HttpURLConnection con;
        block15: {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Connecting to: " + this.stUrl);
            }
            con = (HttpURLConnection)this.stUrl.openConnection();
            con.setRequestMethod("GET");
            con.setDoInput(true);
            con.setDoOutput(true);
            con.setUseCaches(false);
            con.setAllowUserInteraction(false);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Connecting...");
            }
            con.connect();
            InputStream is = con.getInputStream();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setErrorHandler(new XMLErrorSuppressor());
            svcTags = null;
            StringBuilder sb = new StringBuilder();
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line).append("\n");
            }
            br.close();
            String xml = sb.toString();
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "XML: " + xml);
            }
            try {
                svcTags = this.parseSvcTagsInputStream(builder, new ByteArrayInputStream(xml.getBytes()));
            }
            catch (SAXException se) {
                StringTokenizer stringTokenizer = new StringTokenizer(xml, "\n");
                StringBuilder decSB = new StringBuilder();
                while (stringTokenizer.hasMoreTokens()) {
                    decSB.append(this.decrypt(stringTokenizer.nextToken())).append("\n");
                }
                xml = decSB.toString();
                try {
                    svcTags = this.parseSvcTagsInputStream(builder, new ByteArrayInputStream(xml.getBytes()));
                }
                catch (SAXException se2) {
                    if (!log.isLoggable(Level.FINE)) break block15;
                    log.log(Level.FINE, "Exception parsing input stream", se2);
                }
            }
        }
        if (svcTags != null) {
            for (SvcTag svcTag : svcTags) {
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "Service Tag: " + svcTag.getProductName() + " -- " + svcTag.getInstanceURN());
                }
                if (this.targetProductURN == null) {
                    if (log.isLoggable(Level.FINER)) {
                        log.log(Level.FINER, "Adding Service Tag: " + svcTag.getInstanceURN());
                    }
                    this.agent.addSvcTag(svcTag);
                    continue;
                }
                if (!this.targetProductURN.equals(svcTag.getProductURN())) continue;
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "Adding Service Tag: " + svcTag.getInstanceURN());
                }
                this.agent.addSvcTag(svcTag);
            }
        }
        con.disconnect();
    }

    private List<SvcTag> parseSvcTagsInputStream(DocumentBuilder builder, InputStream is) throws SAXException, IOException {
        ArrayList<SvcTag> svcTags = null;
        Document doc = builder.parse(is);
        NodeList nodeList = doc.getElementsByTagName("service_tag");
        if (nodeList != null && nodeList.getLength() > 0) {
            svcTags = new ArrayList<SvcTag>();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element svcTag = (Element)nodeList.item(i);
                SvcTag st = new SvcTag(XMLUtil.getRequiredTextValue(svcTag, "instance_urn"));
                st.setState(svcTag);
                st.setAgentURN(this.agent.getAgentURN());
                svcTags.add(st);
            }
        }
        return svcTags;
    }

    private String decrypt(String line) {
        String res = null;
        try {
            res = EncryptionHelper.decrypt(this.client.getEncryptionKey(), line);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return res;
    }
}

