/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scn.client.comm;

import com.sun.scn.client.comm.Communicator;
import com.sun.scn.client.ui.Client;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TCPProbe
implements Runnable {
    private static Logger log = Logger.getLogger(TCPProbe.class.getName());
    public static final int DEFAULT_PORT = 6481;
    public static final String LOCAL_HOST = "127.0.0.1";
    public static final Set<String> DEFAULT_PROBE_ADDRS = new HashSet<String>();
    public static final Set<String> LOCAL_HOST_ADDR = new HashSet<String>();
    private int port;
    private Set<String> probeAddrs;
    private Client client;
    private String targetProductURN;

    public TCPProbe(Client client) {
        this.client = client;
        this.port = 6481;
        this.probeAddrs = new HashSet<String>();
        this.targetProductURN = null;
    }

    public TCPProbe(Client client, String targetProductURN) {
        this.client = client;
        this.port = 6481;
        this.probeAddrs = LOCAL_HOST_ADDR;
        this.targetProductURN = targetProductURN;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setProbeAddrs(Set<String> probeAddrs) {
        this.probeAddrs = probeAddrs;
    }

    @Override
    public void run() {
        for (String probeAddr : this.probeAddrs) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "sending message to: " + probeAddr);
            }
            try {
                InetAddress addr = InetAddress.getByName(probeAddr);
                Communicator.handleComm(this.client, addr, this.port, this.targetProductURN);
            }
            catch (UnknownHostException uhe) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Unknown host exception: " + probeAddr);
                }
                this.client.reportUnknownHost(probeAddr);
            }
        }
    }

    static {
        LOCAL_HOST_ADDR.add(LOCAL_HOST);
    }
}

