/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scn.client.registry;

import com.sun.scn.client.registry.RegistryNotLoadedException;
import com.sun.scn.client.registry.ServiceTagRegistryException;
import com.sun.scn.servicetags.SvcTag;
import com.sun.scn.servicetags.util.XMLUtil;
import com.sun.scn.util.XMLErrorSuppressor;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceTagRegistry {
    public static final String command = "/usr/bin/stclient";
    public static final String commandOption = "-x";
    public static final String Solaris8URN = "urn:uuid:a7a38948-2bd5-11d6-98ce-9d3ac1c0cfd7";
    public static final String Solaris9URN = "urn:uuid:4f82caac-36f3-11d6-866b-85f428ef944e";
    public static final String Solaris10URN = "urn:uuid:5005588c-36f3-11d6-9cec-fc96f718e113";
    public static final String Solaris11URN = "urn:uuid:6df19e63-7ef5-11db-a4bd-080020a9ed93";
    private String registryURN;
    private String registryVersion;
    private List<SvcTag> serviceTags;
    private boolean isLoaded = false;

    public static void main(String[] args) {
        try {
            ServiceTagRegistry str = ServiceTagRegistry.loadLocalRegistry();
            for (SvcTag svctag : str.getServiceTags()) {
                System.out.println(svctag.toXMLString());
            }
            System.out.println("Registry urn: " + str.getRegistryURN());
            System.out.println("Version: " + str.getRegistryVersion());
            SvcTag osTag = str.getSolarisServiceTag();
            System.out.println(osTag.toXMLString());
        }
        catch (ServiceTagRegistryException stre) {
            stre.printStackTrace();
        }
    }

    private ServiceTagRegistry() {
    }

    public static ServiceTagRegistry loadLocalRegistry() throws ServiceTagRegistryException {
        ServiceTagRegistry str = new ServiceTagRegistry();
        str.load();
        return str;
    }

    public String getRegistryVersion() throws RegistryNotLoadedException {
        if (!this.isLoaded) {
            throw new RegistryNotLoadedException("Registry has not been loaded");
        }
        return this.registryVersion;
    }

    public String getRegistryURN() throws RegistryNotLoadedException {
        if (!this.isLoaded) {
            throw new RegistryNotLoadedException("Registry has not been loaded");
        }
        return this.registryURN;
    }

    public List<SvcTag> getServiceTags() throws RegistryNotLoadedException {
        if (!this.isLoaded) {
            throw new RegistryNotLoadedException("Registry has not been loaded");
        }
        return this.serviceTags;
    }

    public SvcTag getSolarisServiceTag() throws RegistryNotLoadedException {
        if (!this.isLoaded) {
            throw new RegistryNotLoadedException("Registry has not been loaded");
        }
        if (this.serviceTags == null) {
            return null;
        }
        for (SvcTag svctag : this.serviceTags) {
            if (!svctag.getProductURN().equals(Solaris8URN) && !svctag.getProductURN().equals(Solaris9URN) && !svctag.getProductURN().equals(Solaris10URN) && !svctag.getProductURN().equals(Solaris11URN)) continue;
            return svctag;
        }
        return null;
    }

    private void setRegistryVersion(String registryVersion) {
        this.registryVersion = registryVersion;
    }

    private void setRegistryURN(String registryURN) {
        this.registryURN = registryURN;
    }

    private void setServiceTags(List<SvcTag> serviceTags) {
        this.serviceTags = serviceTags;
    }

    private void load() throws ServiceTagRegistryException {
        try {
            String[] cmd = new String[]{command, commandOption};
            Process proc = Runtime.getRuntime().exec(cmd);
            int rc = proc.waitFor();
            if (rc != 0) {
                throw new ServiceTagRegistryException("Unable to load registry, return code: " + rc);
            }
            ArrayList<SvcTag> svcTags = null;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setErrorHandler(new XMLErrorSuppressor());
            Document doc = builder.parse(proc.getInputStream());
            NodeList regNodeList = doc.getElementsByTagName("registry");
            if (regNodeList != null && regNodeList.getLength() > 0) {
                Element registry = (Element)regNodeList.item(0);
                String registryURN = registry.getAttribute("urn");
                if (registryURN != null && registryURN.trim().equals("")) {
                    registryURN = null;
                }
                this.setRegistryURN(registryURN);
                String registryVersion = registry.getAttribute("version");
                this.setRegistryVersion(registryVersion);
            }
            NodeList stNodeList = doc.getElementsByTagName("service_tag");
            svcTags = new ArrayList<SvcTag>();
            if (stNodeList != null && stNodeList.getLength() > 0) {
                for (int i = 0; i < stNodeList.getLength(); ++i) {
                    Element svcTag = (Element)stNodeList.item(i);
                    SvcTag st = new SvcTag(XMLUtil.getRequiredTextValue(svcTag, "instance_urn"));
                    st.setState(svcTag);
                    svcTags.add(st);
                }
            }
            this.setServiceTags(svcTags);
        }
        catch (Exception e) {
            throw new ServiceTagRegistryException("Unable to load registry, message: " + e.getMessage());
        }
        this.isLoaded = true;
    }
}

