/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scn.client.usermgmt;

import com.sun.scn.client.generated.session.ObjectFactory;
import com.sun.scn.client.generated.session.Session;
import com.sun.scn.client.usermgmt.UserMgmtServiceException;
import com.sun.scn.client.util.SCRKClientHelper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyPair;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

public class UserMgmtServiceClient {
    private static Logger log = Logger.getLogger(UserMgmtServiceClient.class.getName());
    private String serviceURL = null;
    private int _respCode;
    private final String sessionPkgName = "com.sun.scn.client.generated.session";
    private String username;
    private String password;
    private String clientId;
    private KeyPair keyPair;
    private String scrkBaseCRSUrl;

    public UserMgmtServiceClient(String baseUrl) {
        this.serviceURL = baseUrl + "usermgmt";
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setSCRKClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setSCRKKeyPair(KeyPair keyPair) {
        this.keyPair = keyPair;
    }

    public void setSCRKBaseCRSUrl(String scrkBaseCRSUrl) {
        this.scrkBaseCRSUrl = scrkBaseCRSUrl;
    }

    public Session loginSession(String soaID, String password) throws Exception {
        String xml = null;
        try {
            ObjectFactory factory = new ObjectFactory();
            Session session = factory.createSession();
            session.setUserId(soaID);
            session.setPassword(password);
            String xmlString = this.marshal(session, this.sessionPkgName);
            xml = this.doProcess("POST", "session/" + soaID, xmlString);
        }
        catch (JAXBException je) {
            throw new UserMgmtServiceException("UserMgmt service exception; unable to get session object for login: " + soaID + " (" + je.getMessage() + ")");
        }
        catch (IOException ioe) {
            throw new UserMgmtServiceException("UserMgmt service exception; unable to login; login: " + soaID + " (" + ioe.getMessage() + ")");
        }
        Session newSession = null;
        if (xml != null) {
            try {
                newSession = (Session)this.unmarshal(xml, this.sessionPkgName);
            }
            catch (JAXBException ex) {
                throw new UserMgmtServiceException("UserMgmt service exception; unable to get session object for login: " + soaID + " (" + ex.getMessage() + ")");
            }
        }
        return newSession;
    }

    private int getRespCode() {
        return this._respCode;
    }

    private String doProcess(String method, String key, String payload) throws Exception {
        log.log(Level.FINE, "Sending " + method + " to: " + this.serviceURL + "/" + key);
        HttpURLConnection conn = this.openConnection(this.serviceURL + "/" + key);
        InputStream in = null;
        String rs = null;
        conn.setRequestMethod(method);
        try {
            this.addAuth(conn, method, payload);
        }
        catch (Exception e) {
            throw new UserMgmtServiceException("Unable to add authentication: " + e.getMessage());
        }
        if (("PUT".equals(method) || "POST".equals(method)) && payload != null) {
            OutputStream urlOut = conn.getOutputStream();
            urlOut.write(payload.getBytes());
            urlOut.flush();
            urlOut.close();
        }
        this._respCode = conn.getResponseCode();
        if ((this._respCode == 200 || this._respCode == 204) && ("GET".equals(method) || "DELETE".equals(method)) || (this._respCode == 200 || this._respCode == 201) && ("PUT".equals(method) || "POST".equals(method) || "DELETE".equals(method))) {
            String line;
            in = conn.getInputStream();
            BufferedReader inbuf = new BufferedReader(new InputStreamReader(in));
            StringBuffer sb = new StringBuffer();
            while ((line = inbuf.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
            rs = sb.toString().trim();
        } else {
            rs = null;
        }
        if (in != null) {
            in.close();
        }
        if (conn != null) {
            conn.disconnect();
        }
        if (rs == null) {
            if (this._respCode == 409) {
                throw new UserMgmtServiceException("Duplicate Key exception detected; method=" + method + "; key=" + key + "; return code=" + this._respCode, this._respCode);
            }
            if (this._respCode == 404) {
                throw new UserMgmtServiceException("Not Found exception; method=" + method + "; key=" + key + "; return code=" + this._respCode, this._respCode);
            }
            if (this._respCode == 401) {
                throw new UserMgmtServiceException("Not Authorized exception; method=" + method + "; key=" + key + "; return code=" + this._respCode, this._respCode);
            }
            throw new UserMgmtServiceException("UserMgmt service exception; method=" + method + "; key=" + key + "; return code=" + this._respCode, this._respCode);
        }
        return rs;
    }

    private void addAuth(HttpURLConnection conn, String method, String payload) throws Exception {
        if (this.username == null) {
            log.log(Level.FINE, "username was null");
            return;
        }
        if (this.password == null && (this.keyPair == null || this.clientId == null)) {
            return;
        }
        SCRKClientHelper scrkClient = new SCRKClientHelper();
        if (this.keyPair == null || this.clientId == null) {
            this.keyPair = scrkClient.getKeyPair();
            this.clientId = scrkClient.getClientRegId(this.keyPair, this.username, this.password);
        }
        String payloadSignature = null;
        payloadSignature = new String(SCRKClientHelper.signPayload(payload, this.keyPair.getPrivate()));
        conn.setRequestProperty("client_reg_id", this.clientId);
        conn.setRequestProperty("payload_sig", payloadSignature);
    }

    private Object unmarshal(String s, String pkgName) throws JAXBException {
        JAXBContext jc = JAXBContext.newInstance((String)pkgName);
        Unmarshaller u = jc.createUnmarshaller();
        return u.unmarshal((Source)new StreamSource(new StringReader(s)));
    }

    private String marshal(Object obj, String pkgName) throws JAXBException {
        JAXBContext jc = JAXBContext.newInstance((String)pkgName, (ClassLoader)this.getClass().getClassLoader());
        Marshaller m = jc.createMarshaller();
        m.setProperty("jaxb.encoding", (Object)"UTF-8");
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        StringWriter sw = new StringWriter();
        m.marshal(obj, (Writer)sw);
        StringBuffer sb = sw.getBuffer();
        try {
            sw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    private HttpURLConnection openConnection(String serviceURL) throws IOException {
        HttpURLConnection conn = null;
        URL url = new URL(serviceURL);
        conn = (HttpURLConnection)url.openConnection();
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.setAllowUserInteraction(false);
        conn.setUseCaches(false);
        conn.setRequestProperty("Content-Type", "text/xml; charset=\"utf-8\"");
        return conn;
    }
}

