/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki;

import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1OctetString;
import com.phaos.cert.CertificateRequest;
import com.phaos.cert.PKCS12Bag;
import com.phaos.cert.PKCS12CertBag;
import com.phaos.cert.PKCS12KeyBag;
import com.phaos.cert.PKCS12SecretBag;
import com.phaos.cert.PKCS12ShroudedKeyBag;
import com.phaos.crypto.DSAPrivateKey;
import com.phaos.crypto.PrivateKey;
import com.phaos.crypto.RSAPrivateKey;
import java.io.IOException;
import java.security.Key;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Vector;
import oracle.security.pki.C17;
import oracle.security.pki.OracleLocalKeyId;
import oracle.security.pki.OraclePKIDebug;
import oracle.security.pki.OraclePKIRSAPrivateKey;
import oracle.security.pki.OraclePKIX509CertImpl;

class C19
extends C17 {
    final PKCS12Bag b;
    Certificate[] c;
    private CertificateRequest d;

    boolean a() {
        return true;
    }

    Key g() {
        PrivateKey privateKey = null;
        if (this.b instanceof PKCS12KeyBag) {
            privateKey = ((PKCS12KeyBag)this.b).getPrivateKey();
        } else if (this.b instanceof PKCS12ShroudedKeyBag) {
            privateKey = ((PKCS12ShroudedKeyBag)this.b).getPrivateKey();
        }
        if (privateKey instanceof RSAPrivateKey) {
            return new OraclePKIRSAPrivateKey((RSAPrivateKey)privateKey, this.d);
        }
        if (privateKey instanceof DSAPrivateKey) {
            OraclePKIDebug.c("DSA Keys not supported");
            return null;
        }
        return null;
    }

    private boolean a(byte[] byArray, byte[] byArray2) {
        if (byArray == null | byArray2 == null) {
            return false;
        }
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    Certificate e() {
        if (this.c == null) {
            return null;
        }
        return this.c[0];
    }

    String c() {
        Certificate certificate = this.e();
        if (certificate instanceof X509Certificate) {
            OraclePKIDebug.c("Certificate for private key is " + certificate);
            return ((X509Certificate)certificate).getSubjectDN().getName();
        }
        return "";
    }

    C19(PKCS12Bag pKCS12Bag, Vector vector, Vector vector2) {
        Object object;
        if (!(pKCS12Bag instanceof PKCS12KeyBag) && !(pKCS12Bag instanceof PKCS12ShroudedKeyBag)) {
            throw new IllegalArgumentException("Incorrect bag type" + pKCS12Bag);
        }
        this.b = pKCS12Bag;
        byte[] byArray = this.b.getLocalKeyID();
        Vector<OraclePKIX509CertImpl> vector3 = new Vector<OraclePKIX509CertImpl>(vector.size());
        for (int i = 0; i < vector.size(); ++i) {
            PKCS12CertBag pKCS12CertBag = (PKCS12CertBag)vector.elementAt(i);
            if (!this.a(pKCS12CertBag.getLocalKeyID(), byArray)) continue;
            vector3.addElement(new OraclePKIX509CertImpl(pKCS12CertBag.getCert()));
            vector.removeElementAt(i);
            OraclePKIDebug.c("Found certificate " + pKCS12CertBag.getCert());
            break;
        }
        byte[] byArray2 = OracleLocalKeyId.h(OracleLocalKeyId.g(byArray), OracleLocalKeyId.b(byArray));
        for (int i = 0; i < vector2.size(); ++i) {
            ASN1Object aSN1Object;
            PKCS12SecretBag pKCS12SecretBag = (PKCS12SecretBag)vector2.elementAt(i);
            if (!this.a(pKCS12SecretBag.getLocalKeyID(), byArray2) || !((aSN1Object = pKCS12SecretBag.getSecretValue()) instanceof ASN1OctetString)) continue;
            try {
                object = ((ASN1OctetString)aSN1Object).getValue();
                this.d = new CertificateRequest((byte[])object);
                OraclePKIDebug.c("Found cert req " + this.d);
                break;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (vector3.size() == 0) {
            OraclePKIDebug.c("No certificate found for key " + this.b.getLocalKeyID());
            this.c = null;
        } else {
            X509Certificate x509Certificate = (X509Certificate)vector3.lastElement();
            while (!((Object)x509Certificate.getIssuerDN()).equals(x509Certificate.getSubjectDN())) {
                boolean bl = false;
                for (int i = 0; i < vector.size(); ++i) {
                    object = (PKCS12CertBag)vector.elementAt(i);
                    if (!((Object)x509Certificate.getIssuerDN()).equals(((PKCS12CertBag)object).getCert().getSubject())) continue;
                    bl = true;
                    vector3.addElement(new OraclePKIX509CertImpl(((PKCS12CertBag)object).getCert()));
                    x509Certificate = (X509Certificate)vector3.lastElement();
                    break;
                }
                if (bl) continue;
                OraclePKIDebug.c("Cert chain incomplete for key " + this.b);
                break;
            }
            OraclePKIDebug.c("Cert chain determined");
            this.c = new Certificate[vector3.size()];
            this.c = vector3.toArray(this.c);
        }
    }

    Certificate[] f() {
        if (this.c == null) {
            return null;
        }
        return (Certificate[])this.c.clone();
    }
}

