/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki;

import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.ASN1.ASN1OctetString;
import com.phaos.cert.CertificateRequest;
import com.phaos.cert.PKCS12;
import com.phaos.cert.PKCS12Bag;
import com.phaos.cert.PKCS12CertBag;
import com.phaos.cert.PKCS12KeyBag;
import com.phaos.cert.PKCS12Safe;
import com.phaos.cert.PKCS12SecretBag;
import com.phaos.cert.PKCS12ShroudedKeyBag;
import com.phaos.cert.X509;
import com.phaos.crypto.AuthenticationException;
import com.phaos.crypto.RSAPrivateKey;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.Collator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import oracle.security.pki.C01;
import oracle.security.pki.C16;
import oracle.security.pki.C17;
import oracle.security.pki.C19;
import oracle.security.pki.OracleLocalKeyId;
import oracle.security.pki.OraclePKIDebug;
import oracle.security.pki.OraclePKIX509CertImpl;
import oracle.security.pki.OracleSecretStoreException;
import oracle.security.pki.OracleWalletPermission;

public class OracleKeyStoreSpi
extends KeyStoreSpi {
    public static final String CREDENTIAL_USERNAME = "oracle.security.client.username";
    private PKCS12 o = null;
    public static final String CREDENTIAL_PASSWORD = "oracle.security.client.password";
    private HashMap p = new HashMap();
    private HashMap q = new HashMap();
    public static final String CREDENTIAL_CONNECT_STRING = "oracle.security.client.connect_string";

    byte[] a(InputStream inputStream, char[] cArray, OraclePKIX509CertImpl oraclePKIX509CertImpl) throws IOException, KeyStoreException {
        Object object;
        ASN1Object aSN1Object;
        PKCS12 pKCS12 = new PKCS12();
        pKCS12.setPassword(new String(cArray));
        if (inputStream != null) {
            aSN1Object = new PKCS12(new String(cArray), inputStream);
            pKCS12.setAuthSafes(((PKCS12)aSN1Object).getAuthSafes());
        }
        aSN1Object = null;
        if (pKCS12.getAuthSafes().size() == 0) {
            OraclePKIDebug.c("OracleKeyStoreSpi: creating new key store");
            aSN1Object = new PKCS12Safe(pKCS12);
            ((PKCS12Safe)aSN1Object).setMode(3);
        } else {
            OraclePKIDebug.c("OracleKeyStoreSpi: using safe 0");
            aSN1Object = (PKCS12Safe)pKCS12.getAuthSafes().elementAt(0);
        }
        Vector vector = ((PKCS12Safe)aSN1Object).getBags();
        OraclePKIDebug.c("OracleKeyStoreSpi: safe has " + vector.size() + " bags");
        int n = 0;
        for (int i = 0; i < vector.size(); ++i) {
            object = (PKCS12Bag)vector.elementAt(i);
            if (!OracleKeyStoreSpi.b((PKCS12Bag)object) || !OracleLocalKeyId.i(((PKCS12Bag)object).getLocalKeyID())) continue;
            OraclePKIDebug.c("OracleKeyStoreSpi: found cert bag");
            ++n;
        }
        PKCS12CertBag pKCS12CertBag = new PKCS12CertBag((PKCS12Safe)aSN1Object, oraclePKIX509CertImpl.getX509());
        pKCS12CertBag.setLocalKeyID(OracleLocalKeyId.c(0, n));
        vector.addElement(pKCS12CertBag);
        OraclePKIDebug.c("OracleWallet: added key bag " + n);
        ((PKCS12Safe)aSN1Object).setBags(vector);
        if (vector.size() > 0 && pKCS12.getAuthSafes().size() == 0) {
            pKCS12.addAuthSafe((PKCS12Safe)aSN1Object);
        }
        OraclePKIDebug.c("OracleKeyStoreSpi: wallet has " + pKCS12.getAuthSafes().size() + " safes");
        OraclePKIDebug.c("OracleKeyStoreSpi: wallet size " + pKCS12.length());
        object = new ByteArrayOutputStream(pKCS12.length());
        pKCS12.output((OutputStream)object);
        return ((ByteArrayOutputStream)object).toByteArray();
    }

    private static boolean b(PKCS12Bag pKCS12Bag) {
        return pKCS12Bag instanceof PKCS12CertBag;
    }

    static void a(InputStream inputStream, char[] cArray, OutputStream outputStream, char[] cArray2) throws IOException {
        PKCS12 pKCS12 = new PKCS12(new String(cArray), inputStream);
        boolean bl = cArray.length == cArray2.length;
        for (int i = 0; bl && i < cArray.length; ++i) {
            if (cArray[i] == cArray2[i]) continue;
            bl = false;
        }
        if (!bl) {
            pKCS12.setPassword(new String(cArray2));
            Vector vector = pKCS12.getAuthSafes();
            for (int i = 0; i < vector.size(); ++i) {
                ((PKCS12Safe)vector.elementAt(i)).setPassword(new String(cArray2));
            }
        }
        try {
            pKCS12.output(outputStream);
            OraclePKIDebug.c("Verifying wallet " + pKCS12.verify());
        }
        catch (AuthenticationException authenticationException) {
            OraclePKIDebug.c("Verifying wallet failed" + authenticationException);
            throw new IOException("Could not store wallet " + authenticationException);
        }
    }

    byte[] c(InputStream inputStream, char[] cArray, CertificateRequest certificateRequest, RSAPrivateKey rSAPrivateKey) throws IOException, KeyStoreException {
        Object object;
        ASN1Object aSN1Object;
        PKCS12 pKCS12 = new PKCS12();
        pKCS12.setPassword(new String(cArray));
        if (inputStream != null) {
            aSN1Object = new PKCS12(new String(cArray), inputStream);
            pKCS12.setAuthSafes(((PKCS12)aSN1Object).getAuthSafes());
        }
        aSN1Object = null;
        if (pKCS12.getAuthSafes().size() == 0) {
            OraclePKIDebug.c("OracleKeyStoreSpi: creating new key store");
            aSN1Object = new PKCS12Safe(pKCS12);
            ((PKCS12Safe)aSN1Object).setMode(3);
        } else {
            OraclePKIDebug.c("OracleKeyStoreSpi: using safe 0");
            aSN1Object = (PKCS12Safe)pKCS12.getAuthSafes().elementAt(0);
        }
        Vector vector = ((PKCS12Safe)aSN1Object).getBags();
        OraclePKIDebug.c("OracleKeyStoreSpi: safe has " + vector.size() + " bags");
        int n = 0;
        for (int i = 0; i < vector.size(); ++i) {
            object = (PKCS12Bag)vector.elementAt(i);
            if (!OracleKeyStoreSpi.n((PKCS12Bag)object)) continue;
            OraclePKIDebug.c("OracleKeyStoreSpi: found key bag");
            ++n;
        }
        PKCS12KeyBag pKCS12KeyBag = new PKCS12KeyBag((PKCS12Safe)aSN1Object, rSAPrivateKey);
        pKCS12KeyBag.setLocalKeyID(OracleLocalKeyId.j(0, n));
        vector.addElement(pKCS12KeyBag);
        OraclePKIDebug.c("OracleWallet: added key bag " + n);
        object = new ByteArrayOutputStream();
        certificateRequest.output((OutputStream)object);
        byte[] byArray = ((ByteArrayOutputStream)object).toByteArray();
        ASN1OctetString aSN1OctetString = new ASN1OctetString(byArray);
        PKCS12SecretBag pKCS12SecretBag = new PKCS12SecretBag((PKCS12Safe)aSN1Object, new ASN1ObjectID("42.134.72.134.247.13.1.10"), aSN1OctetString);
        pKCS12SecretBag.setLocalKeyID(OracleLocalKeyId.h(0, n));
        vector.addElement(pKCS12SecretBag);
        OraclePKIDebug.c("OracleKeyStoreSpi: added req bag " + n);
        ((PKCS12Safe)aSN1Object).setBags(vector);
        if (vector.size() > 0 && pKCS12.getAuthSafes().size() == 0) {
            pKCS12.addAuthSafe((PKCS12Safe)aSN1Object);
        }
        OraclePKIDebug.c("OracleKeyStoreSpi: wallet has " + pKCS12.getAuthSafes().size() + " safes");
        OraclePKIDebug.c("OracleKeyStoreSpi: wallet size " + pKCS12.length());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(pKCS12.length());
        pKCS12.output(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public Certificate[] engineGetCertificateChain(String string) {
        OraclePKIDebug.c("OracleKeyStoreSpi: getCertificateChain alias \"" + (null == string ? "null" : string) + "\"");
        if (this.engineContainsAlias(string)) {
            return ((C17)this.p.get(string)).f();
        }
        return null;
    }

    public char[] secretStoreGetSecret(String string) throws OracleSecretStoreException {
        if (this.secretStoreContainsAlias(string)) {
            return ((C16)this.q.get(string)).a();
        }
        return null;
    }

    public void engineDeleteEntry(String string) throws KeyStoreException {
        if (!this.engineContainsAlias(string)) {
            throw new KeyStoreException("No such alias in KeyStore");
        }
        this.p.remove(string);
    }

    byte[] b(InputStream inputStream, char[] cArray) throws IOException, OracleSecretStoreException {
        Object object;
        ASN1Object aSN1Object;
        PKCS12 pKCS12 = null;
        pKCS12 = new PKCS12();
        pKCS12.setPassword(new String(cArray));
        if (inputStream != null) {
            aSN1Object = new PKCS12(new String(cArray), inputStream);
            pKCS12.setAuthSafes(((PKCS12)aSN1Object).getAuthSafes());
            OracleKeyStoreSpi.h(pKCS12);
        }
        aSN1Object = null;
        if (pKCS12.getAuthSafes().size() == 0) {
            OraclePKIDebug.c("OracleKeyStoreSpi: creating new secret store");
            aSN1Object = new PKCS12Safe(pKCS12);
            ((PKCS12Safe)aSN1Object).setMode(3);
        } else {
            OraclePKIDebug.c("OracleKeyStoreSpi: using safe 0");
            aSN1Object = (PKCS12Safe)pKCS12.getAuthSafes().elementAt(0);
        }
        Vector vector = ((PKCS12Safe)aSN1Object).getBags();
        OraclePKIDebug.c("OracleKeyStoreSpi: safe has " + vector.size() + "bags");
        if (this.q.size() > 0) {
            object = this.q.entrySet();
            Iterator iterator = object.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                C16 c16 = (C16)iterator.next().getValue();
                PKCS12SecretBag pKCS12SecretBag = new PKCS12SecretBag((PKCS12Safe)aSN1Object);
                c16.b(pKCS12SecretBag);
                pKCS12SecretBag.setLocalKeyID(OracleLocalKeyId.d(0, n));
                vector.insertElementAt(pKCS12SecretBag, 0);
                ++n;
                OraclePKIDebug.c("OracleWallet: added secret bag");
            }
        }
        ((PKCS12Safe)aSN1Object).setBags(vector);
        if (vector.size() > 0 && pKCS12.getAuthSafes().size() == 0) {
            pKCS12.addAuthSafe((PKCS12Safe)aSN1Object);
        }
        OraclePKIDebug.c("OracleWallet: wallet has " + pKCS12.getAuthSafes().size() + " safes");
        OraclePKIDebug.c("OracleWallet: wallet size " + pKCS12.length());
        object = new ByteArrayOutputStream(pKCS12.length());
        pKCS12.output((OutputStream)object);
        return ((ByteArrayOutputStream)object).toByteArray();
    }

    int d() {
        return this.q.size();
    }

    public void engineSetCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
        if (this.engineContainsAlias(string) && !((C17)this.p.get(string)).d()) {
            throw new KeyStoreException("Not a certificate entry");
        }
        C01 c01 = new C01(certificate);
        this.p.put(string, c01);
    }

    private static boolean e(PKCS12Bag pKCS12Bag) {
        if (!(pKCS12Bag instanceof PKCS12SecretBag)) {
            return false;
        }
        return OracleLocalKeyId.e(pKCS12Bag.getLocalKeyID());
    }

    private static boolean f(PKCS12Bag pKCS12Bag) {
        if (!(pKCS12Bag instanceof PKCS12SecretBag)) {
            return false;
        }
        return OracleLocalKeyId.a(pKCS12Bag.getLocalKeyID());
    }

    void g(PKCS12 pKCS12) throws NoSuchAlgorithmException, CertificateException, IOException {
        int n;
        String string;
        Object object;
        int n2;
        Vector vector = OracleKeyStoreSpi.i(pKCS12);
        Vector vector2 = OracleKeyStoreSpi.k(pKCS12);
        Vector vector3 = OracleKeyStoreSpi.h(pKCS12);
        Vector vector4 = OracleKeyStoreSpi.j(pKCS12);
        HashMap<String, Object> hashMap = new HashMap<String, Object>(vector.size() + vector2.size());
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>(vector3.size());
        for (n2 = 0; n2 < vector.size(); ++n2) {
            OraclePKIDebug.c("Processing identity " + n2);
            object = new C19((PKCS12Bag)vector.elementAt(n2), vector2, vector4);
            string = ((C17)object).c();
            n = 1;
            while (hashMap.containsKey(string)) {
                string = string + ' ' + Integer.toString(n);
                ++n;
            }
            OraclePKIDebug.c("Storing identity " + n2 + " as " + string);
            hashMap.put(string, object);
        }
        for (n2 = 0; n2 < vector2.size(); ++n2) {
            OraclePKIDebug.c("Processing TP " + n2);
            object = new C01((PKCS12CertBag)vector2.elementAt(n2));
            string = ((C17)object).c();
            n = 1;
            while (hashMap.containsKey(string)) {
                string = ((C17)object).c() + ' ' + Integer.toString(n);
                ++n;
            }
            OraclePKIDebug.c("Storing TP " + n2 + " as " + string);
            hashMap.put(string, object);
        }
        try {
            for (n2 = 0; n2 < vector3.size(); ++n2) {
                OraclePKIDebug.c("OracleKeyStoreSpi: Storing Secret" + n2);
                object = new C16((PKCS12SecretBag)vector3.elementAt(n2));
                hashMap2.put(((C16)object).d(), object);
            }
        }
        catch (OracleSecretStoreException oracleSecretStoreException) {
            throw new IOException(oracleSecretStoreException.toString());
        }
        this.p = hashMap;
        this.q = hashMap2;
    }

    private static Vector h(PKCS12 pKCS12) {
        Vector vector = pKCS12.getAuthSafes();
        Vector<PKCS12Bag> vector2 = new Vector<PKCS12Bag>();
        for (int i = 0; i < vector.size(); ++i) {
            PKCS12Safe pKCS12Safe = (PKCS12Safe)vector.elementAt(i);
            OraclePKIDebug.c("OracleKeyStoreSpi: Opening safe " + i);
            Vector vector3 = pKCS12Safe.getBags();
            for (int j = 0; j < vector3.size(); ++j) {
                PKCS12Bag pKCS12Bag = (PKCS12Bag)vector3.elementAt(j);
                if (!OracleKeyStoreSpi.e(pKCS12Bag)) continue;
                OraclePKIDebug.c("OracleKeyStoreSpi: found secret store bag");
                vector2.addElement(pKCS12Bag);
                vector3.removeElementAt(j);
                --j;
            }
            pKCS12Safe.setBags(vector3);
        }
        return vector2;
    }

    public Certificate engineGetCertificate(String string) {
        OraclePKIDebug.c("OracleKeyStoreSpi: getCertificate alias \"" + (null == string ? "null" : string) + "\"");
        if (this.engineContainsAlias(string)) {
            return ((C17)this.p.get(string)).e();
        }
        return null;
    }

    private static Vector i(PKCS12 pKCS12) {
        Vector vector = pKCS12.getAuthSafes();
        Vector<PKCS12Bag> vector2 = new Vector<PKCS12Bag>();
        for (int i = 0; i < vector.size(); ++i) {
            PKCS12Safe pKCS12Safe = (PKCS12Safe)vector.elementAt(i);
            OraclePKIDebug.c("OracleKeyStoreSpi: Opening safe " + i);
            Vector vector3 = pKCS12Safe.getBags();
            for (int j = 0; j < vector3.size(); ++j) {
                PKCS12Bag pKCS12Bag = (PKCS12Bag)vector3.elementAt(j);
                if (!OracleKeyStoreSpi.n(pKCS12Bag)) continue;
                OraclePKIDebug.c("OracleKeyStoreSpi: found key bag");
                vector2.addElement(pKCS12Bag);
                vector3.removeElementAt(j);
                --j;
            }
            pKCS12Safe.setBags(vector3);
        }
        return vector2;
    }

    public void secretStoreSetSecret(String string, char[] cArray) throws OracleSecretStoreException {
        if (this.secretStoreContainsAlias(string)) {
            C16 c16 = (C16)this.q.get(string);
            c16.c(cArray);
        } else {
            C16 c16 = new C16(string, cArray);
            this.q.put(c16.d(), c16);
        }
    }

    public boolean engineIsKeyEntry(String string) {
        if (this.engineContainsAlias(string)) {
            return ((C17)this.p.get(string)).a();
        }
        return false;
    }

    public void secretStoreListCredential() throws OracleSecretStoreException {
        Enumeration enumeration = new Vector(this.q.values()).elements();
        System.out.println("List credential (index: connect_string username)");
        while (enumeration.hasMoreElements()) {
            C16 c16 = (C16)enumeration.nextElement();
            String string = new String(c16.a());
            String string2 = c16.d();
            if (!string2.startsWith(CREDENTIAL_CONNECT_STRING)) continue;
            String string3 = string2.substring(CREDENTIAL_CONNECT_STRING.length());
            System.out.println(string3 + ": " + string + " " + new String(this.secretStoreGetSecret(CREDENTIAL_USERNAME + string3)));
        }
    }

    private static Vector j(PKCS12 pKCS12) {
        Vector vector = pKCS12.getAuthSafes();
        Vector<PKCS12Bag> vector2 = new Vector<PKCS12Bag>();
        for (int i = 0; i < vector.size(); ++i) {
            PKCS12Safe pKCS12Safe = (PKCS12Safe)vector.elementAt(i);
            OraclePKIDebug.c("OracleKeyStoreSpi: Opening safe " + i);
            Vector vector3 = pKCS12Safe.getBags();
            for (int j = 0; j < vector3.size(); ++j) {
                PKCS12Bag pKCS12Bag = (PKCS12Bag)vector3.elementAt(j);
                if (!OracleKeyStoreSpi.f(pKCS12Bag)) continue;
                OraclePKIDebug.c("OracleKeyStoreSpi: found cert req bag");
                vector2.addElement(pKCS12Bag);
                vector3.removeElementAt(j);
                --j;
            }
            pKCS12Safe.setBags(vector3);
        }
        return vector2;
    }

    public void secretStoreModifyCredential(char[] cArray, char[] cArray2, char[] cArray3) throws OracleSecretStoreException {
        boolean bl = false;
        Enumeration enumeration = new Vector(this.q.values()).elements();
        System.out.println("Modify credential ");
        while (enumeration.hasMoreElements()) {
            C16 c16 = (C16)enumeration.nextElement();
            String string = new String(c16.a());
            String string2 = c16.d();
            if (!string2.startsWith(CREDENTIAL_CONNECT_STRING) || !string.equalsIgnoreCase(new String(cArray))) continue;
            String string3 = string2.substring(CREDENTIAL_CONNECT_STRING.length());
            System.out.println("Modify " + string3);
            this.secretStoreDeleteSecret(CREDENTIAL_USERNAME + string3);
            this.secretStoreSetSecret(CREDENTIAL_USERNAME + string3, cArray2);
            this.secretStoreDeleteSecret(CREDENTIAL_PASSWORD + string3);
            this.secretStoreSetSecret(CREDENTIAL_PASSWORD + string3, cArray3);
            bl = true;
            break;
        }
        if (!bl) {
            throw new OracleSecretStoreException("Credential does not exists");
        }
    }

    public void engineSetKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        throw new KeyStoreException("Not Implemented");
    }

    public boolean secretStoreContainsAlias(String string) throws OracleSecretStoreException {
        return this.q.containsKey(string);
    }

    private static Vector k(PKCS12 pKCS12) {
        Vector vector = pKCS12.getAuthSafes();
        Vector<PKCS12Bag> vector2 = new Vector<PKCS12Bag>();
        for (int i = 0; i < vector.size(); ++i) {
            PKCS12Safe pKCS12Safe = (PKCS12Safe)vector.elementAt(i);
            OraclePKIDebug.c("OracleKeyStoreSpi: Opening safe " + i);
            Vector vector3 = pKCS12Safe.getBags();
            for (int j = 0; j < vector3.size(); ++j) {
                PKCS12Bag pKCS12Bag = (PKCS12Bag)vector3.elementAt(j);
                if (!OracleKeyStoreSpi.b(pKCS12Bag)) continue;
                OraclePKIDebug.c("OracleKeyStoreSpi: found cert bag");
                vector2.addElement(pKCS12Bag);
                vector3.removeElementAt(j);
                --j;
            }
            pKCS12Safe.setBags(vector3);
        }
        return vector2;
    }

    public void engineLoad(InputStream inputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        PKCS12 pKCS12 = null;
        OraclePKIDebug.c("OracleKeyStoreSpi: Loading wallet from stream");
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new OracleWalletPermission("load"));
        }
        if (inputStream == null) {
            pKCS12 = new PKCS12();
            pKCS12.setPassword(new String(cArray));
        } else {
            pKCS12 = new PKCS12(new String(cArray), inputStream);
        }
        boolean bl = false;
        try {
            bl = pKCS12.verify();
        }
        catch (AuthenticationException authenticationException) {
            bl = false;
        }
        if (!bl) {
            throw new IOException("Invalid MAC for Wallet");
        }
        this.g(pKCS12);
        OraclePKIDebug.c("OracleKeyStoreSpi: Keystore Loaded");
    }

    public boolean engineIsCertificateEntry(String string) {
        if (this.engineContainsAlias(string)) {
            return ((C17)this.p.get(string)).d();
        }
        return false;
    }

    Enumeration l() {
        TreeSet<Object> treeSet = new TreeSet<Object>(Collator.getInstance());
        treeSet.addAll(this.q.keySet());
        return new Vector<Object>(treeSet).elements();
    }

    public void secretStoreCreateCredential(char[] cArray, char[] cArray2, char[] cArray3) throws OracleSecretStoreException {
        int n = 1;
        Enumeration enumeration = new Vector(this.q.values()).elements();
        System.out.print("Create credential ");
        while (enumeration.hasMoreElements()) {
            C16 c16 = (C16)enumeration.nextElement();
            String string = new String(c16.a());
            String string2 = c16.d();
            if (!string2.startsWith(CREDENTIAL_CONNECT_STRING) || !string.equalsIgnoreCase(new String(cArray))) continue;
            throw new OracleSecretStoreException("Credential already exists");
        }
        while (this.secretStoreContainsAlias(CREDENTIAL_CONNECT_STRING + n)) {
            ++n;
        }
        System.out.println(CREDENTIAL_CONNECT_STRING + n);
        this.secretStoreSetSecret(CREDENTIAL_CONNECT_STRING + n, cArray);
        this.secretStoreSetSecret(CREDENTIAL_USERNAME + n, cArray2);
        this.secretStoreSetSecret(CREDENTIAL_PASSWORD + n, cArray3);
    }

    byte[] m(InputStream inputStream, KeyStore keyStore, char[] cArray) throws IOException, KeyStoreException, CertificateException {
        ASN1Object aSN1Object;
        PKCS12 pKCS12 = new PKCS12();
        pKCS12.setPassword(new String(cArray));
        if (inputStream != null) {
            aSN1Object = new PKCS12(new String(cArray), inputStream);
            pKCS12.setAuthSafes(((PKCS12)aSN1Object).getAuthSafes());
            OracleKeyStoreSpi.i(pKCS12);
            OracleKeyStoreSpi.k(pKCS12);
            OracleKeyStoreSpi.j(pKCS12);
        }
        aSN1Object = null;
        if (pKCS12.getAuthSafes().size() == 0) {
            OraclePKIDebug.c("OracleKeyStoreSpi: creating new key store");
            aSN1Object = new PKCS12Safe(pKCS12);
            ((PKCS12Safe)aSN1Object).setMode(3);
        } else {
            OraclePKIDebug.c("OracleKeyStoreSpi: using safe 0");
            aSN1Object = (PKCS12Safe)pKCS12.getAuthSafes().elementAt(0);
        }
        Vector vector = ((PKCS12Safe)aSN1Object).getBags();
        OraclePKIDebug.c("OracleKeyStoreSpi: safe has " + vector.size() + " bags");
        Object object = keyStore.aliases();
        while (object.hasMoreElements()) {
            int n = 0;
            String string = object.nextElement();
            if (keyStore.isCertificateEntry(string)) {
                X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(string);
                X509 x509 = x509Certificate instanceof OraclePKIX509CertImpl ? ((OraclePKIX509CertImpl)x509Certificate).getX509() : new X509(x509Certificate.getEncoded());
                PKCS12CertBag pKCS12CertBag = new PKCS12CertBag((PKCS12Safe)aSN1Object, x509);
                pKCS12CertBag.setLocalKeyID(OracleLocalKeyId.c(0, n));
                vector.insertElementAt(pKCS12CertBag, 0);
                OraclePKIDebug.c("OracleWallet: added cert bag");
                continue;
            }
            if (!keyStore.isKeyEntry(string)) continue;
            throw new IOException("Not Implemented for private keys");
        }
        ((PKCS12Safe)aSN1Object).setBags(vector);
        if (vector.size() > 0 && pKCS12.getAuthSafes().size() == 0) {
            pKCS12.addAuthSafe((PKCS12Safe)aSN1Object);
        }
        OraclePKIDebug.c("OracleWallet: wallet has " + pKCS12.getAuthSafes().size() + " safes");
        OraclePKIDebug.c("OracleWallet: wallet size " + pKCS12.length());
        object = new ByteArrayOutputStream(pKCS12.length());
        pKCS12.output((OutputStream)object);
        return ((ByteArrayOutputStream)object).toByteArray();
    }

    public void secretStoreDeleteCredential(char[] cArray) throws OracleSecretStoreException {
        boolean bl = false;
        Enumeration enumeration = new Vector(this.q.values()).elements();
        System.out.println("Delete credential ");
        while (enumeration.hasMoreElements()) {
            C16 c16 = (C16)enumeration.nextElement();
            String string = new String(c16.a());
            String string2 = c16.d();
            if (!string2.startsWith(CREDENTIAL_CONNECT_STRING) || !string.equalsIgnoreCase(new String(cArray))) continue;
            String string3 = string2.substring(CREDENTIAL_CONNECT_STRING.length());
            System.out.println("Delete " + string3);
            this.secretStoreDeleteSecret(string2);
            this.secretStoreDeleteSecret(CREDENTIAL_USERNAME + string3);
            this.secretStoreDeleteSecret(CREDENTIAL_PASSWORD + string3);
            bl = true;
            break;
        }
        if (!bl) {
            throw new OracleSecretStoreException("Credential does not exists");
        }
    }

    private static boolean n(PKCS12Bag pKCS12Bag) {
        return pKCS12Bag instanceof PKCS12KeyBag || pKCS12Bag instanceof PKCS12ShroudedKeyBag;
    }

    public Enumeration engineAliases() {
        return new Vector(this.p.keySet()).elements();
    }

    public void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        throw new KeyStoreException("Not Implemented");
    }

    public Date engineGetCreationDate(String string) {
        if (this.engineContainsAlias(string)) {
            return ((C17)this.p.get(string)).b();
        }
        return null;
    }

    public boolean engineContainsAlias(String string) {
        return this.p.containsKey(string);
    }

    public String engineGetCertificateAlias(Certificate certificate) {
        Set set = this.p.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!((C17)entry.getValue()).e().equals(certificate)) continue;
            return (String)entry.getKey();
        }
        return null;
    }

    public void secretStoreDeleteSecret(String string) throws OracleSecretStoreException {
        if (!this.secretStoreContainsAlias(string)) {
            throw new OracleSecretStoreException("No such alias in secret store");
        }
        this.q.remove(string);
    }

    public Key engineGetKey(String string, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        if (this.engineContainsAlias(string)) {
            return ((C17)this.p.get(string)).g();
        }
        return null;
    }

    public int engineSize() {
        return this.p.size();
    }

    public void engineStore(OutputStream outputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
    }
}

