/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki;

import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.cert.PKIX;
import com.phaos.cert.X509;
import com.phaos.cert.extension.BasicConstraintsExtension;
import com.phaos.cert.extension.KeyUsageExtension;
import com.phaos.crypto.RSAPublicKey;
import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Set;
import oracle.security.pki.C07;
import oracle.security.pki.OraclePKIDebug;
import oracle.security.pki.OraclePKIPrincipalImpl;

public final class OraclePKIX509CertImpl
extends X509Certificate {
    private final X509 a;

    public void verify(PublicKey publicKey) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        throw new CertificateException("Not implemented");
    }

    public boolean[] getKeyUsage() {
        KeyUsageExtension keyUsageExtension = (KeyUsageExtension)this.a.getExtension(PKIX.id_ce_keyUsage);
        if (keyUsageExtension == null) {
            return null;
        }
        return new boolean[]{keyUsageExtension.hasUsageFlag(0), keyUsageExtension.hasUsageFlag(1), keyUsageExtension.hasUsageFlag(2), keyUsageExtension.hasUsageFlag(3), keyUsageExtension.hasUsageFlag(4), keyUsageExtension.hasUsageFlag(5), keyUsageExtension.hasUsageFlag(6), keyUsageExtension.hasUsageFlag(7), keyUsageExtension.hasUsageFlag(8)};
    }

    public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        this.checkValidity(new Date());
    }

    public boolean[] getSubjectUniqueID() {
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(this.a.getEncoded()));
            return x509Certificate.getSubjectUniqueID();
        }
        catch (Throwable throwable) {
            OraclePKIDebug.c("Java can't parse this cert");
            return null;
        }
    }

    public byte[] getTBSCertificate() throws CertificateEncodingException {
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(this.a.getEncoded()));
            return x509Certificate.getTBSCertificate();
        }
        catch (Throwable throwable) {
            throw new CertificateEncodingException();
        }
    }

    public PublicKey getPublicKey() {
        com.phaos.crypto.PublicKey publicKey = this.a.getPublicKey();
        if (publicKey instanceof RSAPublicKey) {
            return new C07((RSAPublicKey)publicKey);
        }
        return null;
    }

    public Set getNonCriticalExtensionOIDs() {
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(this.a.getEncoded()));
            return x509Certificate.getCriticalExtensionOIDs();
        }
        catch (Throwable throwable) {
            OraclePKIDebug.c("Java can't parse this cert");
            return null;
        }
    }

    public Principal getSubjectDN() {
        return new OraclePKIPrincipalImpl(this.a.getSubject());
    }

    public int getBasicConstraints() {
        BasicConstraintsExtension basicConstraintsExtension = (BasicConstraintsExtension)this.a.getExtension(PKIX.id_ce_basicConstraints);
        if (basicConstraintsExtension == null) {
            return -1;
        }
        if (!basicConstraintsExtension.getCA()) {
            return -1;
        }
        BigInteger bigInteger = basicConstraintsExtension.getPathLen();
        if (bigInteger == null) {
            return Integer.MAX_VALUE;
        }
        return bigInteger.intValue();
    }

    public String getSigAlgOID() {
        return this.a.getSigAlgOID().toString();
    }

    public OraclePKIX509CertImpl(X509 x509) {
        this.a = x509;
    }

    public String getSigAlgName() {
        return this.a.getSigAlgString();
    }

    public boolean[] getIssuerUniqueID() {
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(this.a.getEncoded()));
            return x509Certificate.getIssuerUniqueID();
        }
        catch (Throwable throwable) {
            OraclePKIDebug.c("Java can't parse this cert");
            return null;
        }
    }

    public Principal getIssuerDN() {
        return new OraclePKIPrincipalImpl(this.a.getIssuer());
    }

    public Set getCriticalExtensionOIDs() {
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(this.a.getEncoded()));
            return x509Certificate.getCriticalExtensionOIDs();
        }
        catch (Throwable throwable) {
            OraclePKIDebug.c("Java can't parse this cert");
            return null;
        }
    }

    public BigInteger getSerialNumber() {
        return this.a.getSerialNo();
    }

    public boolean hasUnsupportedCriticalExtension() {
        return this.a.getExtensionSet().hasUnrecognizedCriticalExtension();
    }

    public byte[] getSigAlgParams() {
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(this.a.getEncoded()));
            return x509Certificate.getSigAlgParams();
        }
        catch (Throwable throwable) {
            OraclePKIDebug.c("Java can't parse this cert");
            return null;
        }
    }

    public Date getNotBefore() {
        return this.a.getNotBeforeDate();
    }

    public byte[] getSignature() {
        try {
            return this.a.getSigBytes();
        }
        catch (com.phaos.crypto.SignatureException signatureException) {
            return null;
        }
    }

    public void verify(PublicKey publicKey, String string) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        throw new CertificateException("Not implemented");
    }

    public Date getNotAfter() {
        return this.a.getNotAfterDate();
    }

    public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        if (this.a.getNotAfterDate().compareTo(date) < 0) {
            OraclePKIDebug.c("Certificate expired on " + this.a.getNotAfterDate());
            throw new CertificateExpiredException();
        }
        if (this.a.getNotBeforeDate().compareTo(date) > 0) {
            OraclePKIDebug.c("Certificate not valid until " + this.a.getNotBeforeDate());
            throw new CertificateNotYetValidException();
        }
    }

    public X509 getX509() {
        return this.a;
    }

    public byte[] getExtensionValue(String string) {
        return this.a.getExtension(new ASN1ObjectID(string)).getValue();
    }

    public byte[] getEncoded() throws CertificateEncodingException {
        return this.a.getEncoded();
    }

    public int getVersion() {
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(this.a.getEncoded()));
            return x509Certificate.getVersion();
        }
        catch (Throwable throwable) {
            OraclePKIDebug.c("Java can't parse this cert");
            return 0;
        }
    }

    public String toString() {
        return this.a.toString();
    }
}

