/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki;

import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.Set;
import oracle.security.pki.OraclePKIDebug;

public final class OraclePKIX509CertUsage {
    public static final int CA_SIGNING = 16;
    public static final int CODE_SIGNING = 8;
    public static final int S_MIME_ENCRYPTION = 2;
    public static final int UNSUPPORTED_USAGE = 64;
    public static final int TRUST_POINT = 32;
    public static final int SSL = 1;
    public static final int S_MIME_SIGNATURE = 4;

    static boolean a(X509Certificate x509Certificate) {
        Set<String> set = x509Certificate.getCriticalExtensionOIDs();
        String string = "2.5.29.15";
        if (set != null && !set.isEmpty()) {
            OraclePKIDebug.c("Critical Extensions Present");
            Iterator<String> iterator = set.iterator();
            while (iterator.hasNext()) {
                String string2 = iterator.next();
                OraclePKIDebug.c("Extensions " + string2);
                if (!string2.equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isCertValidFor(Certificate certificate, int n) {
        if (n != 1 && n != 2 && n != 4 && n != 8 && n != 16 && n != 32 && n != 64) {
            throw new IllegalArgumentException("Invalid Usage" + n);
        }
        return certificate instanceof X509Certificate && (n & OraclePKIX509CertUsage.keyUsageForCert((X509Certificate)certificate)) != 0;
    }

    public static int keyUsageForCert(X509Certificate x509Certificate) {
        int n;
        boolean[] blArray = x509Certificate.getKeyUsage();
        boolean bl = OraclePKIX509CertUsage.a(x509Certificate);
        int n2 = n = bl ? 0 : 32;
        if (blArray == null) {
            return 3 | n;
        }
        if (blArray[0] && !blArray[2] && !blArray[5]) {
            return 0xC | n;
        }
        if (!(!blArray[1] || blArray[0] || blArray[2] || blArray[3] || blArray[4] || blArray[5] || blArray[6] || blArray[7] || blArray[9])) {
            if (bl) {
                return 64;
            }
            return 0xC | n;
        }
        if (blArray[2] && !blArray[5]) {
            return 3 | n;
        }
        if (blArray[5]) {
            return 48;
        }
        if (bl) {
            return 64;
        }
        return 3 | n;
    }

    public static boolean isCertChainValidFor(Certificate[] certificateArray, int n) {
        if (n != 1 && n != 2 && n != 4 && n != 8 && n != 16 && n != 32 && n != 64) {
            throw new IllegalArgumentException("Invalid Usage " + n);
        }
        if (certificateArray.length == 0) {
            return false;
        }
        if (!OraclePKIX509CertUsage.isCertValidFor(certificateArray[0], n)) {
            return false;
        }
        for (int i = 1; i < certificateArray.length; ++i) {
            if (OraclePKIX509CertUsage.isCertValidFor(certificateArray[i], 32)) continue;
            return false;
        }
        return true;
    }
}

