/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki;

import com.phaos.ASN1.ASN1String;
import com.phaos.cert.CRL;
import com.phaos.cert.CRLDistPoint;
import com.phaos.cert.GeneralName;
import com.phaos.cert.PKIX;
import com.phaos.cert.X509;
import com.phaos.cert.extension.CRLDistPointExtension;
import java.io.IOException;
import java.net.URL;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Vector;
import oracle.security.pki.OraclePKIDebug;
import oracle.security.pki.OraclePKIX509CertImpl;
import oracle.security.pki.OraclePKIX509CrlStore;

public class OraclePKIX509CrlDPStore
implements OraclePKIX509CrlStore {
    public CRL getCrlFor(X509Certificate x509Certificate) throws IOException, CertificateException {
        OraclePKIDebug.c("OraclePKIX509CrlDPStore: entry");
        X509 x509 = null;
        x509 = x509Certificate instanceof OraclePKIX509CertImpl ? ((OraclePKIX509CertImpl)x509Certificate).getX509() : new X509(x509Certificate.getEncoded());
        CRLDistPointExtension cRLDistPointExtension = (CRLDistPointExtension)x509.getExtension(PKIX.id_ce_cRLDistributionPoints);
        if (cRLDistPointExtension == null) {
            return null;
        }
        Vector vector = cRLDistPointExtension.getCRLDistPoints();
        OraclePKIDebug.c("OraclePKIX509CrlDPStore: found " + vector.size() + " Distribution Points");
        for (int i = 0; i < vector.size(); ++i) {
            Vector vector2 = ((CRLDistPoint)vector.elementAt(i)).getDistPointName().getFullName();
            for (int j = 0; j < vector2.size(); ++j) {
                GeneralName generalName = (GeneralName)vector2.elementAt(j);
                if (generalName.getType() != GeneralName.Type.URI) continue;
                OraclePKIDebug.c("OraclePKIX509CrlDPStore: trying " + ((ASN1String)generalName.getValue()).getValue());
                try {
                    URL uRL = new URL(((ASN1String)generalName.getValue()).getValue());
                    return new CRL(uRL);
                }
                catch (Exception exception) {
                    OraclePKIDebug.c("OraclePKIX509CrlDPStore: " + exception);
                }
            }
        }
        OraclePKIDebug.c("OraclePKIX509CrlDPStore: CRL not found");
        return null;
    }
}

