/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki;

import com.phaos.cert.CRL;
import com.phaos.cert.X500Name;
import com.phaos.cert.X509;
import com.phaos.crypto.MD5;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import oracle.security.pki.OraclePKIDebug;
import oracle.security.pki.OraclePKIX509CertImpl;
import oracle.security.pki.OraclePKIX509CrlHelper;
import oracle.security.pki.OraclePKIX509CrlStore;

public class OraclePKIX509CrlFileStore
implements OraclePKIX509CrlStore {
    File a;

    public OraclePKIX509CrlFileStore(File file) throws IOException {
        if (!file.isDirectory() || !file.canRead()) {
            throw new IOException("Can't open crl location");
        }
        this.a = file;
    }

    public CRL getCrlFor(X509Certificate x509Certificate) throws IOException, CertificateException {
        OraclePKIDebug.c("OraclePKIX509CrlFileStore: entry");
        X509 x509 = null;
        x509 = x509Certificate instanceof OraclePKIX509CertImpl ? ((OraclePKIX509CertImpl)x509Certificate).getX509() : new X509(x509Certificate.getEncoded());
        OraclePKIDebug.c("OraclePKIX509CrlFileStore: looking for CRL for " + x509.getIssuer());
        String string = OraclePKIX509CrlFileStore.hashName(x509.getIssuer());
        OraclePKIDebug.c("OraclePKIX509CrlFileStore: looking for file " + string);
        File file = new File(this.a, string);
        try {
            return new CRL(file);
        }
        catch (IOException iOException) {
            return OraclePKIX509CrlHelper.readB64CRLFrom(new FileReader(file));
        }
    }

    public static String hashName(X500Name x500Name) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            x500Name.output(byteArrayOutputStream);
        }
        catch (IOException iOException) {
            return "";
        }
        MD5 mD5 = new MD5();
        mD5.init();
        byte[] byArray = mD5.computeDigest(byteArrayOutputStream.toByteArray());
        StringBuffer stringBuffer = new StringBuffer(9);
        for (int i = 3; i >= 0; --i) {
            if (byArray[i] < 0) {
                stringBuffer.append(Integer.toHexString(256 + byArray[i]));
                continue;
            }
            if (byArray[i] < 16) {
                stringBuffer.append("0");
                stringBuffer.append(Integer.toHexString(byArray[i]));
                continue;
            }
            stringBuffer.append(Integer.toHexString(byArray[i]));
        }
        stringBuffer.append(".rN");
        return stringBuffer.toString();
    }
}

