/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki;

import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import oracle.security.pki.OracleKeyStoreSpi;
import oracle.security.pki.OraclePKIDebug;
import oracle.security.pki.OracleSSOKeyStoreSpi;
import oracle.security.pki.OracleSecretStoreException;

public class OracleSecretStore {
    private OracleKeyStoreSpi c = null;

    public void setSecret(String string, char[] cArray) throws OracleSecretStoreException {
        if (this.c == null) {
            throw new OracleSecretStoreException("Secret Store not initialized");
        }
        this.c.secretStoreSetSecret(string, cArray);
    }

    public void deleteSecret(String string) throws OracleSecretStoreException {
        if (this.c == null) {
            throw new OracleSecretStoreException("Secret Store not initialized");
        }
        this.c.secretStoreDeleteSecret(string);
    }

    public byte[] setStoreInWallet(InputStream inputStream, char[] cArray) throws IOException, OracleSecretStoreException {
        if (this.c == null) {
            throw new OracleSecretStoreException("Secret Store not initialized");
        }
        return this.c.b(inputStream, cArray);
    }

    public void modifyCredential(char[] cArray, char[] cArray2, char[] cArray3) throws OracleSecretStoreException {
        if (this.c == null) {
            throw new OracleSecretStoreException("Secret Store not initialized");
        }
        this.c.secretStoreModifyCredential(cArray, cArray2, cArray3);
    }

    public void createCredential(char[] cArray, char[] cArray2, char[] cArray3) throws OracleSecretStoreException {
        if (this.c == null) {
            throw new OracleSecretStoreException("Secret Store not initialized");
        }
        this.c.secretStoreCreateCredential(cArray, cArray2, cArray3);
    }

    public void load(InputStream inputStream, char[] cArray) throws IOException, OracleSecretStoreException {
        OraclePKIDebug.c("OracleSecretStore: loading wallet from stream");
        this.c = cArray == null ? new OracleSSOKeyStoreSpi() : new OracleKeyStoreSpi();
        try {
            this.c.engineLoad(inputStream, cArray);
        }
        catch (CertificateException certificateException) {
            throw new OracleSecretStoreException("Error opening secret store");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new OracleSecretStoreException("Error opening secret store");
        }
    }

    public Enumeration internalAliases() throws OracleSecretStoreException {
        return this.a();
    }

    protected OracleSecretStore() {
    }

    Enumeration a() throws OracleSecretStoreException {
        if (this.c == null) {
            throw new OracleSecretStoreException("Secret Store not initialized");
        }
        return this.c.l();
    }

    public void deleteCredential(char[] cArray) throws OracleSecretStoreException {
        if (this.c == null) {
            throw new OracleSecretStoreException("Secret Store not initialized");
        }
        this.c.secretStoreDeleteCredential(cArray);
    }

    public void listCredential() throws OracleSecretStoreException {
        if (this.c == null) {
            throw new OracleSecretStoreException("Secret Store not initialized");
        }
        this.c.secretStoreListCredential();
    }

    public char[] getSecret(String string) throws OracleSecretStoreException {
        if (this.c == null) {
            throw new OracleSecretStoreException("Secret Store not initialized");
        }
        return this.c.secretStoreGetSecret(string);
    }

    public boolean containsAlias(String string) throws OracleSecretStoreException {
        if (this.c == null) {
            throw new OracleSecretStoreException("Secret Store not initialized");
        }
        return this.c.secretStoreContainsAlias(string);
    }

    int b() throws OracleSecretStoreException {
        if (this.c == null) {
            throw new OracleSecretStoreException("Secret Store not initialized");
        }
        return this.c.d();
    }
}

