/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki;

import com.phaos.cert.CertificateRequest;
import com.phaos.cert.X509;
import com.phaos.crypto.RSAPrivateKey;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.security.cert.CertificateException;
import oracle.security.pki.C08;
import oracle.security.pki.C12;
import oracle.security.pki.C15;
import oracle.security.pki.C18;
import oracle.security.pki.OracleKeyStoreSpi;
import oracle.security.pki.OraclePKIDebug;
import oracle.security.pki.OraclePKIProvider;
import oracle.security.pki.OraclePKIX509CertImpl;
import oracle.security.pki.OracleSecretStore;
import oracle.security.pki.OracleSecretStoreException;
import sun.misc.BASE64Decoder;

public class OracleWallet {
    public static final String ENTRUST_MAIN_CERT = "MIIE2DCCBEGgAwIBAgIEN0rSQzANBgkqhkiG9w0BAQUFADCBwzELMAkGA1UEBhMCVVMxFDASBgNVBAoTC0VudHJ1c3QubmV0MTswOQYDVQQLEzJ3d3cuZW50cnVzdC5uZXQvQ1BTIGluY29ycC4gYnkgcmVmLiAobGltaXRzIGxpYWIuKTElMCMGA1UECxMcKGMpIDE5OTkgRW50cnVzdC5uZXQgTGltaXRlZDE6MDgGA1UEAxMxRW50cnVzdC5uZXQgU2VjdXJlIFNlcnZlciBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTAeFw05OTA1MjUxNjA5NDBaFw0xOTA1MjUxNjM5NDBaMIHDMQswCQYDVQQGEwJVUzEUMBIGA1UEChMLRW50cnVzdC5uZXQxOzA5BgNVBAsTMnd3dy5lbnRydXN0Lm5ldC9DUFMgaW5jb3JwLiBieSByZWYuIChsaW1pdHMgbGlhYi4pMSUwIwYDVQQLExwoYykgMTk5OSBFbnRydXN0Lm5ldCBMaW1pdGVkMTowOAYDVQQDEzFFbnRydXN0Lm5ldCBTZWN1cmUgU2VydmVyIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MIGdMA0GCSqGSIb3DQEBAQUAA4GLADCBhwKBgQDNKIM0VBuJ8w+vN5Ex/68xYMmo6LIQaO2f55M28Qpku0f1BBc/I0dNxScZgSYMVHINiC3ZH5oSn7yzcdOAGT9HZnuMNSjSuQrfJNqc1lB5gXpa0zf3wkrYKZImZNHkmGw6AIr1NJtl+O3jEP/9uElY3KDegjlrgbEWGWG5VLbmQwIBA6OCAdcwggHTMBEGCWCGSAGG+EIBAQQEAwIABzCCARkGA1UdHwSCARAwggEMMIHeoIHboIHYpIHVMIHSMQswCQYDVQQGEwJVUzEUMBIGA1UEChMLRW50cnVzdC5uZXQxOzA5BgNVBAsTMnd3dy5lbnRydXN0Lm5ldC9DUFMgaW5jb3JwLiBieSByZWYuIChsaW1pdHMgbGlhYi4pMSUwIwYDVQQLExwoYykgMTk5OSBFbnRydXN0Lm5ldCBMaW1pdGVkMTowOAYDVQQDEzFFbnRydXN0Lm5ldCBTZWN1cmUgU2VydmVyIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MQ0wCwYDVQQDEwRDUkwxMCmgJ6AlhiNodHRwOi8vd3d3LmVudHJ1c3QubmV0L0NSTC9uZXQxLmNybDArBgNVHRAEJDAigA8xOTk5MDUyNTE2MDk0MFqBDzIwMTkwNTI1MTYwOTQwWjALBgNVHQ8EBAMCAQYwHwYDVR0jBBgwFoAU8BdiE1U9s/8KAGv7UISX8+1i0BowHQYDVR0OBBYEFPAXYhNVPbP/CgBr+1CEl/PtYtAaMAwGA1UdEwQFMAMBAf8wGQYJKoZIhvZ9B0EABAwwChsEVjQuMAMCBJAwDQYJKoZIhvcNAQEFBQADgYEAkNwwAvpkdMKnCqV8IY00F6j7Rw7/JXyNEwr75Ji174z4xRAN95K+8cPV1ZVqBLssziY2ZcgxxufuP+NXdYR6Ee9GTxj005i7qIcyunL2POI9n9cd2cNgQ4xYDiKWL2KjLB+6rQXvqzJ4h6BUcxm1XAX5Uj5tLUUL9wqT6u0G+bI=";
    private char[] c = null;
    private static final String d = "reg:";
    public static final String GTE_CYBERTRUSTGLOBAL_CERT = "MIICWjCCAcMCAgGlMA0GCSqGSIb3DQEBBAUAMHUxCzAJBgNVBAYTAlVTMRgwFgYDVQQKEw9HVEUgQ29ycG9yYXRpb24xJzAlBgNVBAsTHkdURSBDeWJlclRydXN0IFNvbHV0aW9ucywgSW5jLjEjMCEGA1UEAxMaR1RFIEN5YmVyVHJ1c3QgR2xvYmFsIFJvb3QwHhcNOTgwODEzMDAyOTAwWhcNMTgwODEzMjM1OTAwWjB1MQswCQYDVQQGEwJVUzEYMBYGA1UEChMPR1RFIENvcnBvcmF0aW9uMScwJQYDVQQLEx5HVEUgQ3liZXJUcnVzdCBTb2x1dGlvbnMsIEluYy4xIzAhBgNVBAMTGkdURSBDeWJlclRydXN0IEdsb2JhbCBSb290MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCVD6C28FCc6HrHiM3dFw4usJTQGz0O9pTAipTHBsiQl8i4ZBp6fmw8U+E3KHNgf7KXUwefU/ltWJTSr41tiGeA5u2ylc9yMcqlHHK6XALnZELn+aks1joNrI1CqiQBOeacPwGFVw1Yh0X404Wqk2kmhXBIgD8SFcd5tB8FLztimQIDAQABMA0GCSqGSIb3DQEBBAUAA4GBAG3rGwnpXtlR22ciYaQqPEh346B8pt5zohQDhT37qw4wxYMWM4ETCJ57NE7fQMh017l93PR2VX2bY1QY6fDq81yx2YtCHrnAlU66+tXifPVoYb+O7AWXX1uw16OFNMQkpw0PlZPvy5TYnh+dXIVtx6quTx8itc2VrbqnzPmrC3p/";
    private static String e = "MIICNDCCAaECEAKtZn5ORf5eV288mBle3cAwDQYJKoZIhvcNAQECBQAwXzELMAkGA1UEBhMCVVMxIDAeBgNVBAoTF1JTQSBEYXRhIFNlY3VyaXR5LCBJbmMuMS4wLAYDVQQLEyVTZWN1cmUgU2VydmVyIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTk0MTEwOTAwMDAwMFoXDTEwMDEwNzIzNTk1OVowXzELMAkGA1UEBhMCVVMxIDAeBgNVBAoTF1JTQSBEYXRhIFNlY3VyaXR5LCBJbmMuMS4wLAYDVQQLEyVTZWN1cmUgU2VydmVyIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MIGbMA0GCSqGSIb3DQEBAQUAA4GJADCBhQJ+AJLOesGugz5aqomDV6wlAXYMra6OLDfO6zV4ZFQD5YRAUcm/jwjiioII0haGN1XpsSECrXZogZoFokvJSyVmIlZsiAeP94FZbYQHZXATcXY+m3dM41CJVphIuR2nKRoTLkoRWZweFdVJVCxzOmmCsZc5nG1wZ0jl3S3WyB57AgMBAAEwDQYJKoZIhvcNAQECBQADfgBl3X7hsuyw4jrg7HFGmhkRuNPHoLQDQCYCPgmc4RKz0Vr2N6W3YQO2WxZpO8ZECAyIUwxrl0nHPjXcbLm7qt9cuzovk2C2qUtN8iD3zV9/ZHuO3ABc1/p3yjkWWW8O6tO1g39NTUJWdrTJXwT4OPjr0l91X817/OWOgHz8UA==";
    public static final String GTE_CYBERTRUST_CERT = "MIIB+jCCAWMCAgGjMA0GCSqGSIb3DQEBBAUAMEUxCzAJBgNVBAYTAlVTMRgwFgYDVQQKEw9HVEUgQ29ycG9yYXRpb24xHDAaBgNVBAMTE0dURSBDeWJlclRydXN0IFJvb3QwHhcNOTYwMjIzMjMwMTAwWhcNMDYwMjIzMjM1OTAwWjBFMQswCQYDVQQGEwJVUzEYMBYGA1UEChMPR1RFIENvcnBvcmF0aW9uMRwwGgYDVQQDExNHVEUgQ3liZXJUcnVzdCBSb290MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQC45k+625h8cXyvRLfTD0bZZOWTwUKOx7pJjTUteueLveUFMVnGsS8KDPufpz+iCWaEVh43KRuH6X4MypqfpX/1FZSj1aJGgthoTNE3FQZor734sLPwKfWVWgkWYXcKIiXUT0Wqx73llt/51KiOQswkwB6RJ0q1bQaAYznEol44AwIDAQABMA0GCSqGSIb3DQEBBAUAA4GBABKzdcZfHeFhVYAA1IFLezEPI2PnPfMD+fQ2qLvZ46WXTeorKeDWanOB5sCJo9Px4KWlIjeaY8JIILTbcuPI9tl8vrGvU9oUtCG41tWW4/5ODFlitppK+ULdjG+BqXH/9ApybW1EDp3zdHSo1TRJ6V6e6bR64eVaH4QwnNOfpSXY";
    private static String f;
    private byte[] g = null;
    private static final char h = ':';
    private static String i;
    private C08 j = null;
    public static final String ENTRUST_PREMIUM_CERT = "MIIEXDCCA0SgAwIBAgIEOGO5ZjANBgkqhkiG9w0BAQUFADCBtDEUMBIGA1UEChMLRW50cnVzdC5uZXQxQDA+BgNVBAsUN3d3dy5lbnRydXN0Lm5ldC9DUFNfMjA0OCBpbmNvcnAuIGJ5IHJlZi4gKGxpbWl0cyBsaWFiLikxJTAjBgNVBAsTHChjKSAxOTk5IEVudHJ1c3QubmV0IExpbWl0ZWQxMzAxBgNVBAMTKkVudHJ1c3QubmV0IENlcnRpZmljYXRpb24gQXV0aG9yaXR5ICgyMDQ4KTAeFw05OTEyMjQxNzUwNTFaFw0xOTEyMjQxODIwNTFaMIG0MRQwEgYDVQQKEwtFbnRydXN0Lm5ldDFAMD4GA1UECxQ3d3d3LmVudHJ1c3QubmV0L0NQU18yMDQ4IGluY29ycC4gYnkgcmVmLiAobGltaXRzIGxpYWIuKTElMCMGA1UECxMcKGMpIDE5OTkgRW50cnVzdC5uZXQgTGltaXRlZDEzMDEGA1UEAxMqRW50cnVzdC5uZXQgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkgKDIwNDgpMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEArU1LqRKGsuqjIAcVFmQqK0vRvwtKTY7tgHalZ7d4QMBzQshowNtTK91euHaYNZOLGp18EzoOH1u3Hs/lJBQesYGpjX24zGtLA/ECDNyrpUAkAH90lKGdCCmziAv1h3edVc3kw37XamSrhRSGlVuXMlBvPci6Zgzj/L24ScF2iUkZ/cCovYmjZy/Gn7xxGWC4LeksyZB2ZnuU4q941mVTXTzWnLLPKQP5L6RQstRIzgUyVYr9smRMDuSYB3Xbf9+5CFVghTAp+XtIpGmG4zU/HoZdenoVve8AjhUiVBcAkCaTvA5JaJG/+EfTnZVCwQ5N328mz8MYIWJmQ3DW1cAH4QIDAQABo3QwcjARBglghkgBhvhCAQEEBAMCAAcwHwYDVR0jBBgwFoAUVeSB0RGAvtiJuQijMfmhJAkWuXAwHQYDVR0OBBYEFFXkgdERgL7YibkIozH5oSQJFrlwMB0GCSqGSIb2fQdBAAQQMA4bCFY1LjA6NC4wAwIEkDANBgkqhkiG9w0BAQUFAAOCAQEAWUesIYSKF8mciVMeuoCFGsY8Tj6xnLZ8xpJdGGQC49MGCBFhfGPjK50xA3B20qMooPS7mmNz7W3lKtvtFKkrxjYR0CvrB4ul2p5cGZ1WEvVUKcgF7bISKo30Axv/55IQh7A6tcOdBTcSo8f0FbnVpDkWm1M6I5HxqIKiaohowXkCIryqptau37AUX7iH0N18f3v/rxzP5tsHrV7bhZ3QKw0z2wTR5klAEyt2+z7pnIkPFc4YsIV4IU9rTw76NmfNB/L/CNDi3tm/Kq+4h4YhPATKt5Rof8886ZjXOP/swNlQ8C5LWK5Gb9Auw2DaclVyvUxFnmG6v4SBkgPR0ml8xQ==";
    private static final String k = "file:";
    private static String l;
    private String m = null;
    public static final String ENTRUST_GLOBAL_CERT = "MIIElTCCA/6gAwIBAgIEOJsRPDANBgkqhkiG9w0BAQQFADCBujEUMBIGA1UEChMLRW50cnVzdC5uZXQxPzA9BgNVBAsUNnd3dy5lbnRydXN0Lm5ldC9TU0xfQ1BTIGluY29ycC4gYnkgcmVmLiAobGltaXRzIGxpYWIuKTElMCMGA1UECxMcKGMpIDIwMDAgRW50cnVzdC5uZXQgTGltaXRlZDE6MDgGA1UEAxMxRW50cnVzdC5uZXQgU2VjdXJlIFNlcnZlciBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTAeFw0wMDAyMDQxNzIwMDBaFw0yMDAyMDQxNzUwMDBaMIG6MRQwEgYDVQQKEwtFbnRydXN0Lm5ldDE/MD0GA1UECxQ2d3d3LmVudHJ1c3QubmV0L1NTTF9DUFMgaW5jb3JwLiBieSByZWYuIChsaW1pdHMgbGlhYi4pMSUwIwYDVQQLExwoYykgMjAwMCBFbnRydXN0Lm5ldCBMaW1pdGVkMTowOAYDVQQDEzFFbnRydXN0Lm5ldCBTZWN1cmUgU2VydmVyIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDHwV9OcfHO8GCGD9JYf9Mzly0XonUwtZZkJi9ow0SrqHXmAGc0V55lxyKbc+bT3QgON1WqJUaBbL3+qPZ1V1eMkGxKwz6LS0MKyRFWmponIpnPVZ5h2QLifLZ8OAfc439PmrkDQYC2dWcTC5/oVzbIXQA23mYU2m52H083jIITiQIDAQABo4IBpDCCAaAwEQYJYIZIAYb4QgEBBAQDAgAHMIHjBgNVHR8EgdswgdgwgdWggdKggc+kgcwwgckxFDASBgNVBAoTC0VudHJ1c3QubmV0MT8wPQYDVQQLFDZ3d3cuZW50cnVzdC5uZXQvU1NMX0NQUyBpbmNvcnAuIGJ5IHJlZi4gKGxpbWl0cyBsaWFiLikxJTAjBgNVBAsTHChjKSAyMDAwIEVudHJ1c3QubmV0IExpbWl0ZWQxOjA4BgNVBAMTMUVudHJ1c3QubmV0IFNlY3VyZSBTZXJ2ZXIgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkxDTALBgNVBAMTBENSTDEwKwYDVR0QBCQwIoAPMjAwMDAyMDQxNzIwMDBagQ8yMDIwMDIwNDE3NTAwMFowCwYDVR0PBAQDAgEGMB8GA1UdIwQYMBaAFMtswGvjuz7L/CKc/vuLkpyw8m4iMB0GA1UdDgQWBBTLbMBr47s+y/winP77i5KcsPJuIjAMBgNVHRMEBTADAQH/MB0GCSqGSIb2fQdBAAQQMA4bCFY1LjA6NC4wAwIEkDANBgkqhkiG9w0BAQQFAAOBgQBi24GRzsiad0Iv7L0no1MPUBvqTpLwqa+poLpIYcvvyQbvH9X07t9WLebKahlzqlO+krNQAraFJnJj2HVQYnUUt7NQGj/KEQALhUVpbbalrlHhStyCP2yMNLJ3a9kC9n8O6mUE8c1UyrrJzOCE98g+EZfTYAkYvAX/bIkz8OwVDw==";

    public void setSecretStore(OracleSecretStore oracleSecretStore) throws IOException, OracleSecretStoreException {
        OraclePKIDebug.c("OracleWallet: setSecretStore");
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.g != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.g);
        }
        this.g = oracleSecretStore.setStoreInWallet(byteArrayInputStream, this.c);
    }

    public boolean exists(String string) throws IOException {
        C08 c08 = this.a(string);
        return c08.a();
    }

    public OracleSecretStore getSecretStore() throws IOException, OracleSecretStoreException {
        OracleSecretStore oracleSecretStore = new OracleSecretStore();
        OraclePKIDebug.c("OracleWallet: getSecretStore");
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.g != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.g);
        }
        oracleSecretStore.load(byteArrayInputStream, this.c);
        return oracleSecretStore;
    }

    public static String getDefaultLocation() {
        return null;
    }

    public void open(String string, char[] cArray) throws IOException {
        this.b();
        if (cArray != null) {
            this.c = new char[cArray.length];
            System.arraycopy(cArray, 0, this.c, 0, cArray.length);
        }
        try {
            this.j = this.a(string);
            this.g = this.j.g();
            OraclePKIDebug.c("Oracle Wallet: wallet size " + this.g.length);
            try {
                this.getSecretStore();
            }
            catch (Throwable throwable) {
                OraclePKIDebug.c("OracleWallet: " + throwable.toString());
                this.b();
                throw new IOException("Check password");
            }
        }
        catch (Throwable throwable) {
            this.b();
            throw new IOException("Could not open wallet. " + throwable.getMessage());
        }
    }

    public OracleWallet() {
        this.b();
    }

    public void internalAddCertReq(CertificateRequest certificateRequest, RSAPrivateKey rSAPrivateKey) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        OraclePKIDebug.c("OracleWallet: internalAddCertReq");
        OracleKeyStoreSpi oracleKeyStoreSpi = new OracleKeyStoreSpi();
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.g != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.g);
        }
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.c);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        this.g = oracleKeyStoreSpi.c(byteArrayInputStream, this.c, certificateRequest, rSAPrivateKey);
    }

    public KeyStore getKeyStore() throws IOException {
        KeyStore keyStore = null;
        try {
            if (null == Security.getProvider("OraclePKI")) {
                Security.insertProviderAt(new OraclePKIProvider(), 1);
            }
            keyStore = this.c != null ? KeyStore.getInstance("PKCS12", "OraclePKI") : KeyStore.getInstance("SSO", "OraclePKI");
            ByteArrayInputStream byteArrayInputStream = null;
            if (this.g != null) {
                byteArrayInputStream = new ByteArrayInputStream(this.g);
            }
            keyStore.load(byteArrayInputStream, this.c);
        }
        catch (GeneralSecurityException generalSecurityException) {
            return null;
        }
        return keyStore;
    }

    public void openDefault(char[] cArray) throws IOException {
        String string = "";
        this.open(string, cArray);
        throw new IOException("not implemented");
    }

    public void deleteSSOWallet() throws IOException {
        this.j.c();
    }

    public void createSSO() throws IOException {
        OraclePKIDebug.c("OracleWallet: saving sso " + this.g.length + " bytes.");
        this.j.d(this.g, this.c);
    }

    public void setKeyStore(KeyStore keyStore) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        OraclePKIDebug.c("OracleWallet: setKeyStore");
        OracleKeyStoreSpi oracleKeyStoreSpi = new OracleKeyStoreSpi();
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.g != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.g);
        }
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.c);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        this.g = oracleKeyStoreSpi.m(byteArrayInputStream, keyStore, this.c);
    }

    public void saveAs(String string) throws IOException {
        C08 c08 = this.a(string);
        c08.f(this.g, this.c);
        this.j = c08;
    }

    public void create(char[] cArray) throws IOException {
        this.b();
        this.c = new char[cArray.length];
        System.arraycopy(cArray, 0, this.c, 0, cArray.length);
        this.g = null;
        this.j = new C12();
        KeyStore keyStore = this.getKeyStore();
        OraclePKIX509CertImpl oraclePKIX509CertImpl = new OraclePKIX509CertImpl(new X509(new BASE64Decoder().decodeBuffer(l)));
        OraclePKIX509CertImpl oraclePKIX509CertImpl2 = new OraclePKIX509CertImpl(new X509(new BASE64Decoder().decodeBuffer(i)));
        OraclePKIX509CertImpl oraclePKIX509CertImpl3 = new OraclePKIX509CertImpl(new X509(new BASE64Decoder().decodeBuffer(f)));
        OraclePKIX509CertImpl oraclePKIX509CertImpl4 = new OraclePKIX509CertImpl(new X509(new BASE64Decoder().decodeBuffer(e)));
        OraclePKIX509CertImpl oraclePKIX509CertImpl5 = new OraclePKIX509CertImpl(new X509(new BASE64Decoder().decodeBuffer(GTE_CYBERTRUST_CERT)));
        OraclePKIX509CertImpl oraclePKIX509CertImpl6 = new OraclePKIX509CertImpl(new X509(new BASE64Decoder().decodeBuffer(GTE_CYBERTRUSTGLOBAL_CERT)));
        OraclePKIX509CertImpl oraclePKIX509CertImpl7 = new OraclePKIX509CertImpl(new X509(new BASE64Decoder().decodeBuffer(ENTRUST_PREMIUM_CERT)));
        OraclePKIX509CertImpl oraclePKIX509CertImpl8 = new OraclePKIX509CertImpl(new X509(new BASE64Decoder().decodeBuffer(ENTRUST_GLOBAL_CERT)));
        OraclePKIX509CertImpl oraclePKIX509CertImpl9 = new OraclePKIX509CertImpl(new X509(new BASE64Decoder().decodeBuffer(ENTRUST_MAIN_CERT)));
        try {
            keyStore.setCertificateEntry(oraclePKIX509CertImpl4.getSubjectDN().getName(), oraclePKIX509CertImpl4);
            keyStore.setCertificateEntry(oraclePKIX509CertImpl.getSubjectDN().getName(), oraclePKIX509CertImpl);
            keyStore.setCertificateEntry(oraclePKIX509CertImpl2.getSubjectDN().getName(), oraclePKIX509CertImpl2);
            keyStore.setCertificateEntry(oraclePKIX509CertImpl3.getSubjectDN().getName(), oraclePKIX509CertImpl3);
            keyStore.setCertificateEntry(oraclePKIX509CertImpl5.getSubjectDN().getName(), oraclePKIX509CertImpl5);
            keyStore.setCertificateEntry(oraclePKIX509CertImpl6.getSubjectDN().getName(), oraclePKIX509CertImpl6);
            keyStore.setCertificateEntry(oraclePKIX509CertImpl7.getSubjectDN().getName(), oraclePKIX509CertImpl7);
            keyStore.setCertificateEntry(oraclePKIX509CertImpl8.getSubjectDN().getName(), oraclePKIX509CertImpl8);
            keyStore.setCertificateEntry(oraclePKIX509CertImpl9.getSubjectDN().getName(), oraclePKIX509CertImpl9);
            this.setKeyStore(keyStore);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new IOException();
        }
    }

    public void save() throws IOException {
        OraclePKIDebug.c("OracleWallet: saving " + this.g.length + " bytes.");
        this.j.f(this.g, this.c);
    }

    static {
        l = "MIICPDCCAaUCEDJQM89Q0VbzXIGtZVxPyCUwDQYJKoZIhvcNAQECBQAwXzELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMTcwNQYDVQQLEy5DbGFzcyAxIFB1YmxpYyBQcmltYXJ5IENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTk2MDEyOTAwMDAwMFoXDTIwMDEwNzIzNTk1OVowXzELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMTcwNQYDVQQLEy5DbGFzcyAxIFB1YmxpYyBQcmltYXJ5IENlcnRpZmljYXRpb24gQXV0aG9yaXR5MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDlGb9to1ZhLZlIcfZn3rmN67eehoAKkQ76OCWvRoiC5XOooJskXQ0fzGVuDLDQVoQYh5oGmxChc9+0WDlrbsH2FdWoqD+qEgaNMax/sDTXjzRniAnNFBHiTkVWaR94AoDa3EeRKbs2yWNcxeDXLYd7obcysHswuiovMaruo2fa2wIDAQABMA0GCSqGSIb3DQEBAgUAA4GBAEtEZmBoZOSYG/OwcuaViXzde7OVwB0u2NgZ0C00PcZQmhCGjKo/O6gE/DdSlcPZydvN8oYGxLEb8IKIMEKOF1AcZHq4PplJdJf8rAJD+5YMVgQlDHx8h50kp9jwMim1pN9dokzFFjKoQvZFprY2ueC/ZTaTwtLXa9zeWdaiNfhF";
        i = "MIICPDCCAaUCEC0b/EoXjaOR6+f/9YtFvgswDQYJKoZIhvcNAQECBQAwXzELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMTcwNQYDVQQLEy5DbGFzcyAyIFB1YmxpYyBQcmltYXJ5IENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTk2MDEyOTAwMDAwMFoXDTI4MDgwMTIzNTk1OVowXzELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMTcwNQYDVQQLEy5DbGFzcyAyIFB1YmxpYyBQcmltYXJ5IENlcnRpZmljYXRpb24gQXV0aG9yaXR5MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQC2WoujDWojg4BrzzmH9CETMwZMJaLtVRKXxaeAufqDwSCg+i8VDXyhYGt+eSz6Bg86rvYbb7HS/y8oUl+DfUvEerf4Zh+AVPy3wo5ZShRXRtGak75BkQO7FYCTXOvnzAhsPz6zSvz/S2wj1VCCJkQZjiPDceoZJEcEnnW/yKYAHwIDAQABMA0GCSqGSIb3DQEBAgUAA4GBAIobK/o5wXTXXtgZZKJYSi034DNHD6zt96rbHuSLBlxgJ8pFUs4W7z8GZOeUaHxgMxURaa+dYo2jA1Rrpr7l7gUYYAS/QoD90KioHgE796Ncr6Pc5iaAIzy4RHT3Cq5Ji2F4zCS/iIqnDupzGUH9TQPwiNHleI2lKk/2lw0Xd8rY";
        f = "MIICPDCCAaUCEHC65B0Q2Sk0tjjKewPMur8wDQYJKoZIhvcNAQECBQAwXzELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMTcwNQYDVQQLEy5DbGFzcyAzIFB1YmxpYyBQcmltYXJ5IENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTk2MDEyOTAwMDAwMFoXDTI4MDgwMTIzNTk1OVowXzELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMTcwNQYDVQQLEy5DbGFzcyAzIFB1YmxpYyBQcmltYXJ5IENlcnRpZmljYXRpb24gQXV0aG9yaXR5MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDJXFme8huKARS0EN8EQNvjV69qRUCPhAwL0TPZ2RHP7gJYHyX3KqhEBarsAx94f56TuZoAqiN91qyFomNFx3InzPRMxnVx0jnvT0Lwdd8KkMaOIG+YD/isI19wKTakyYbnsZogy1Olhec9vn2a/iRFM9x2Fe0PonFkTGUugWhFpwIDAQABMA0GCSqGSIb3DQEBAgUAA4GBALtMEivPLCYATxQT3ab7/AoRhIzzKBxnki98tsX63/Dolbwdj2wsqFHMc9ikwFPwTtYmwHYBV4GSXiHx0bH/59AhWM1pF+NEHJwZRDmJXNycAA9WjQKZ7aKQRUzkuxCkPfAyAw7xzvjoyVGM5mKf5p/AfbdynMk2OmufTqj/ZA1k";
    }

    private C08 a(String string) throws IOException {
        if (string.indexOf(58) < 2) {
            string = k + string;
        }
        if (string.toLowerCase().startsWith(k)) {
            if (this.c == null) {
                return new C15(string.substring(k.length()));
            }
            return new C18(string.substring(k.length()));
        }
        throw new IOException("Unsupported WRL type" + string);
    }

    public void deleteWallet() throws IOException {
        this.j.b();
    }

    public String getLocation() {
        return this.m;
    }

    private void b() {
        this.c = null;
        this.m = null;
        this.g = null;
        this.j = null;
    }

    public void internalAddTrustedCert(OraclePKIX509CertImpl oraclePKIX509CertImpl) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        OraclePKIDebug.c("OracleWallet: internalAddCertReq");
        OracleKeyStoreSpi oracleKeyStoreSpi = new OracleKeyStoreSpi();
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.g != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.g);
        }
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.c);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        this.g = oracleKeyStoreSpi.a(byteArrayInputStream, this.c, oraclePKIX509CertImpl);
    }
}

