/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.ssl;

import com.phaos.cert.CRL;
import com.phaos.cert.X509;
import java.io.File;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Vector;
import oracle.security.pki.OraclePKIX509CertImpl;
import oracle.security.pki.OraclePKIX509CrlDPStore;
import oracle.security.pki.OraclePKIX509CrlFileStore;
import oracle.security.pki.OraclePKIX509CrlStore;
import oracle.security.pki.ssl.C06;
import oracle.security.pki.ssl.C18;
import oracle.security.pki.ssl.OracleSSLDebug;

final class C03
implements C18 {
    C06 b = null;
    OraclePKIX509CrlStore[] c = null;
    Vector d = new Vector();

    C03(KeyStore keyStore, String string, String string2, int n) throws KeyStoreException {
        Object object;
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            if (!keyStore.isCertificateEntry((String)object)) continue;
            if (keyStore.getCertificate((String)object) instanceof OraclePKIX509CertImpl) {
                this.d.add(keyStore.getCertificate((String)object));
                OracleSSLDebug.c("OracleSSLX509TrustManager: added trusted cert at alias " + (String)object);
            }
            if (!(keyStore.getCertificate((String)object) instanceof X509Certificate)) continue;
            try {
                X509 x509 = new X509(((X509Certificate)keyStore.getCertificate((String)object)).getEncoded());
                this.d.addElement(new OraclePKIX509CertImpl(x509));
                OracleSSLDebug.c("OracleSSLX509TrustManager: added trusted cert at alias " + (String)object);
            }
            catch (Exception exception) {
                OracleSSLDebug.c("OracleX509CrlTrustManagaer: Invalid cert at alias " + (String)object);
            }
        }
        object = new Vector();
        if (string != null && !string.equals("")) {
            OracleSSLDebug.c("OracleSSLX509TrustManager: Adding CRL File location " + string);
            try {
                ((Vector)object).addElement(new OraclePKIX509CrlFileStore(new File(string)));
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException(string + " is not a valid location.");
            }
        }
        if (string2 != null) {
            OracleSSLDebug.c("OracleSSLX509TrustManager: Adding CRL Ldap location " + string2 + ":" + n);
        }
        ((Vector)object).addElement(new OraclePKIX509CrlDPStore());
        OracleSSLDebug.c("OracleSSLX509TrustManager: using " + ((Vector)object).size() + " CRL Stores");
        this.c = ((Vector)object).toArray(new OraclePKIX509CrlStore[((Vector)object).size()]);
        OracleSSLDebug.c("OracleSSLX509TrustManager: Created");
        this.b = new C06();
    }

    private final OraclePKIX509CertImpl a(X509Certificate x509Certificate) {
        OracleSSLDebug.c("OracleX509TrustManager: Looking for trusted certificate: " + x509Certificate.getSubjectDN());
        for (int i = 0; i < this.d.size(); ++i) {
            OraclePKIX509CertImpl oraclePKIX509CertImpl = (OraclePKIX509CertImpl)this.d.elementAt(i);
            OracleSSLDebug.c("OracleX509TrustManager: Is it : " + oraclePKIX509CertImpl + " ? " + ((Object)x509Certificate.getIssuerDN()).equals(oraclePKIX509CertImpl.getSubjectDN()));
            if (!((Object)x509Certificate.getIssuerDN()).equals(oraclePKIX509CertImpl.getSubjectDN())) continue;
            return oraclePKIX509CertImpl;
        }
        return null;
    }

    public final void checkServerTrusted(X509Certificate[] x509CertificateArray) throws CertificateException, CertificateExpiredException, CertificateNotYetValidException {
        this.checkClientTrusted(x509CertificateArray);
    }

    public final X509Certificate[] getAcceptedIssuers() {
        return this.d.toArray(new X509Certificate[this.d.size()]);
    }

    public final void checkClientTrusted(X509Certificate[] x509CertificateArray) throws CertificateException {
        OraclePKIX509CertImpl oraclePKIX509CertImpl;
        OraclePKIX509CertImpl oraclePKIX509CertImpl2;
        block10: {
            oraclePKIX509CertImpl2 = null;
            oraclePKIX509CertImpl = null;
            try {
                oraclePKIX509CertImpl2 = new OraclePKIX509CertImpl(new X509(x509CertificateArray[0].getEncoded()));
                OracleSSLDebug.c("OracleSSLX509TrustManager: Checking revocation status of " + oraclePKIX509CertImpl2.getSubjectDN());
                OracleSSLDebug.c("OracleSSLX509TrustManager: looking for signer");
                oraclePKIX509CertImpl = this.a(oraclePKIX509CertImpl2);
                if (oraclePKIX509CertImpl != null) break block10;
                for (int i = 0; i < x509CertificateArray.length; ++i) {
                    OracleSSLDebug.c("OracleSSLX509TrustManager: Is it : " + x509CertificateArray[i].getSubjectDN() + " ? " + ((Object)oraclePKIX509CertImpl2.getIssuerDN()).equals(x509CertificateArray[i].getSubjectDN()));
                    if (!((Object)oraclePKIX509CertImpl2.getIssuerDN()).equals(x509CertificateArray[i].getSubjectDN())) continue;
                    X509 x509 = new X509(x509CertificateArray[i].getEncoded());
                    oraclePKIX509CertImpl = new OraclePKIX509CertImpl(x509);
                    break;
                }
            }
            catch (IOException iOException) {
                throw new CertificateException("Invalid certificate in chain");
            }
        }
        if (oraclePKIX509CertImpl == null) {
            throw new CertificateException("Unable to find signer of peer");
        }
        OracleSSLDebug.c("OracleSSLX509TrustManager: Looking for CRL");
        CRL cRL = this.b.getCRLFor(oraclePKIX509CertImpl2);
        if (cRL == null || !cRL.verifyDate()) {
            for (int i = 0; i < this.c.length; ++i) {
                try {
                    CRL cRL2 = this.c[i].getCrlFor(oraclePKIX509CertImpl2);
                    cRL2.setPublicKey(oraclePKIX509CertImpl.getX509().getPublicKey());
                    OracleSSLDebug.c("OracleSSLX509TrustManager: found candidate CRL in store " + i);
                    if (!cRL2.verify()) continue;
                    cRL = cRL2;
                    break;
                }
                catch (Exception exception) {
                    OracleSSLDebug.c("OracleSSLX509TrustManager: no valid crl in crl store " + i);
                    OracleSSLDebug.c("OracleSSLX509TrustManager: " + exception.toString());
                }
            }
            if (cRL == null) {
                throw new CertificateException("Unable to find CRL for peer");
            }
            this.b.storeCRL(cRL);
        }
        OracleSSLDebug.c("OracleSSLX509TrustManager: found CRL");
        if (cRL.isRevoked(oraclePKIX509CertImpl2.getSerialNumber())) {
            throw new CertificateException("Certificate Revoked");
        }
    }
}

