/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.ssl;

import com.phaos.cert.X509;
import com.phaos.crypto.AuthenticationException;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Vector;
import oracle.security.pki.OraclePKIX509CertImpl;
import oracle.security.pki.OraclePKIX509CertUsage;
import oracle.security.pki.ssl.C18;
import oracle.security.pki.ssl.OracleSSLDebug;

final class C13
implements C18 {
    Vector b = new Vector();

    C13(KeyStore keyStore) throws KeyStoreException {
        Enumeration<String> enumeration = keyStore.aliases();
        Vector vector = new Vector(keyStore.size());
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            if (!keyStore.isCertificateEntry(string)) continue;
            if (keyStore.getCertificate(string) instanceof OraclePKIX509CertImpl) {
                this.b.add(keyStore.getCertificate(string));
                OracleSSLDebug.c("OracleX509CertTrustManager: added trusted cert at alias " + string);
            }
            if (!(keyStore.getCertificate(string) instanceof X509Certificate)) continue;
            try {
                X509 x509 = new X509(((X509Certificate)keyStore.getCertificate(string)).getEncoded());
                this.b.addElement(new OraclePKIX509CertImpl(x509));
                OracleSSLDebug.c("OracleX509CertTrustManager: added trusted cert at alias " + string);
            }
            catch (Exception exception) {
                OracleSSLDebug.c("OracleX509TrutManagaer: Invalid cert at alias " + string);
            }
        }
        OracleSSLDebug.c("OracleX509CertTrustManager: Trust Manager Created");
    }

    private final OraclePKIX509CertImpl a(X509Certificate x509Certificate) {
        OracleSSLDebug.c("OracleX509CertTrustManager: Looking for trusted certificate: " + x509Certificate.getSubjectDN());
        for (int i = 0; i < this.b.size(); ++i) {
            OraclePKIX509CertImpl oraclePKIX509CertImpl = (OraclePKIX509CertImpl)this.b.elementAt(i);
            OracleSSLDebug.c("OracleX509CertTrustManager: Is it : " + oraclePKIX509CertImpl + " ? " + ((Object)x509Certificate.getIssuerDN()).equals(oraclePKIX509CertImpl.getSubjectDN()));
            if (!((Object)x509Certificate.getIssuerDN()).equals(oraclePKIX509CertImpl.getSubjectDN())) continue;
            return oraclePKIX509CertImpl;
        }
        return null;
    }

    public final void checkServerTrusted(X509Certificate[] x509CertificateArray) throws CertificateException, CertificateExpiredException, CertificateNotYetValidException {
        this.checkClientTrusted(x509CertificateArray);
    }

    public final X509Certificate[] getAcceptedIssuers() {
        return this.b.toArray(new X509Certificate[this.b.size()]);
    }

    public final void checkClientTrusted(X509Certificate[] x509CertificateArray) throws CertificateException, CertificateExpiredException, CertificateNotYetValidException {
        int n;
        OraclePKIX509CertImpl oraclePKIX509CertImpl;
        if (x509CertificateArray == null || x509CertificateArray.length == 0) {
            throw new CertificateException("Peer sent no certificates");
        }
        OraclePKIX509CertImpl[] oraclePKIX509CertImplArray = null;
        boolean bl = false;
        Vector<OraclePKIX509CertImpl> vector = new Vector<OraclePKIX509CertImpl>();
        try {
            vector.addElement(new OraclePKIX509CertImpl(new X509(x509CertificateArray[0].getEncoded())));
            oraclePKIX509CertImpl = (OraclePKIX509CertImpl)vector.elementAt(0);
            block4: for (int i = 1; i < x509CertificateArray.length; ++i) {
                oraclePKIX509CertImpl = (OraclePKIX509CertImpl)vector.elementAt(i - 1);
                OracleSSLDebug.c("OracleX509CertTrustManager: Looking for signer of:  " + oraclePKIX509CertImpl.getSubjectDN());
                OraclePKIX509CertImpl oraclePKIX509CertImpl2 = this.a(oraclePKIX509CertImpl);
                if (oraclePKIX509CertImpl2 != null) {
                    oraclePKIX509CertImpl.getX509().setIssuerCertificate(oraclePKIX509CertImpl2.getX509());
                    bl = true;
                    break;
                }
                for (int j = 1; j < x509CertificateArray.length; ++j) {
                    OracleSSLDebug.c("OracleX509CertTrustManager: Is it : " + x509CertificateArray[j].getSubjectDN() + " ? " + ((Object)oraclePKIX509CertImpl.getIssuerDN()).equals(x509CertificateArray[j].getSubjectDN()));
                    if (!((Object)oraclePKIX509CertImpl.getIssuerDN()).equals(x509CertificateArray[j].getSubjectDN())) continue;
                    X509 x509 = new X509(x509CertificateArray[j].getEncoded());
                    oraclePKIX509CertImpl.getX509().setIssuerCertificate(x509);
                    vector.addElement(new OraclePKIX509CertImpl(x509));
                    continue block4;
                }
            }
        }
        catch (IOException iOException) {
            throw new CertificateException("Invalid certificate in chain");
        }
        oraclePKIX509CertImpl = (OraclePKIX509CertImpl)vector.elementAt(vector.size() - 1);
        OracleSSLDebug.c("OracleX509CertTrustManager: Trying to complete the chain ending with: " + oraclePKIX509CertImpl.getIssuerDN());
        OraclePKIX509CertImpl oraclePKIX509CertImpl3 = this.a(oraclePKIX509CertImpl);
        if (oraclePKIX509CertImpl3 != null) {
            oraclePKIX509CertImpl.getX509().setIssuerCertificate(oraclePKIX509CertImpl3.getX509());
            vector.addElement(oraclePKIX509CertImpl3);
            bl = true;
        }
        if (!bl) {
            throw new CertificateException("Untrusted Cert Chain");
        }
        oraclePKIX509CertImplArray = vector.toArray(new OraclePKIX509CertImpl[vector.size()]);
        OracleSSLDebug.c("Checking Dates of Certificates");
        for (n = 0; n < oraclePKIX509CertImplArray.length - 1; ++n) {
            x509CertificateArray[n].checkValidity();
        }
        OracleSSLDebug.c("Checking Usage of Certificates");
        if (!OraclePKIX509CertUsage.isCertChainValidFor(x509CertificateArray, 1)) {
            OracleSSLDebug.c("Peer is not trusted");
            throw new CertificateException("Peer is not trusted");
        }
        OracleSSLDebug.c("Checking Signatures");
        try {
            for (n = 0; n < oraclePKIX509CertImplArray.length - 1; ++n) {
                oraclePKIX509CertImplArray[n].getX509().verifyCertSignature();
            }
        }
        catch (AuthenticationException authenticationException) {
            OracleSSLDebug.c("Invalid signature");
            throw new CertificateException("Invalid signatures");
        }
        OracleSSLDebug.c("Certificate Chain OK");
    }
}

