/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.ssl;

import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import oracle.security.pki.OraclePKIX509CertUsage;
import oracle.security.pki.ssl.C10;
import oracle.security.pki.ssl.OracleSSLDebug;

final class C16 {
    Map c = new HashMap();

    public final String chooseServerAlias(String string, Principal[] principalArray) {
        OracleSSLDebug.c("OracleX509KeyManager: chooseServerAlias ");
        String[] stringArray = this.getServerAliases(string, principalArray);
        if (stringArray == null) {
            return null;
        }
        return stringArray[0];
    }

    public final String[] getClientAliases(String string, Principal[] principalArray) {
        Vector<String> vector = new Vector<String>(this.c.size());
        Set set = this.c.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!C16.b(((C10)entry.getValue()).b(), principalArray) || !C16.a(((C10)entry.getValue()).a(), string)) continue;
            vector.addElement((String)entry.getKey());
        }
        if (vector.size() == 0) {
            return null;
        }
        return vector.toArray(new String[vector.size()]);
    }

    public final PrivateKey getPrivateKey(String string) {
        if (!this.c.containsKey(string)) {
            return null;
        }
        return ((C10)this.c.get(string)).a();
    }

    private static final boolean a(PrivateKey privateKey, String string) {
        return string.equalsIgnoreCase(privateKey.getAlgorithm());
    }

    public final String chooseClientAlias(String string, Principal[] principalArray) {
        OracleSSLDebug.c("OracleX509KeyManager: chooseClientAlias ");
        String[] stringArray = this.getClientAliases(string, principalArray);
        if (stringArray == null) {
            return null;
        }
        return stringArray[0];
    }

    public final String[] getServerAliases(String string, Principal[] principalArray) {
        return this.getClientAliases(string, principalArray);
    }

    public C16(KeyStore keyStore, char[] cArray) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            try {
                String string = enumeration.nextElement();
                if (!keyStore.isKeyEntry(string)) continue;
                OracleSSLDebug.c("OracleX509KeyManager: Checking alias " + string);
                Certificate[] certificateArray = keyStore.getCertificateChain(string);
                Key key = keyStore.getKey(string, cArray);
                if (certificateArray == null || key == null || !OraclePKIX509CertUsage.isCertChainValidFor(certificateArray, 1)) continue;
                this.c.put(string, new C10(this, certificateArray, (PrivateKey)key));
            }
            catch (ClassCastException classCastException) {
                OracleSSLDebug.c("OracleX509KeyManager: Not a Private Key " + classCastException);
            }
        }
        OracleSSLDebug.c("OracleX509KeyManager: Key Manager created with " + this.c.size() + " key pairs");
    }

    public final X509Certificate[] getCertificateChain(String string) {
        OracleSSLDebug.c("OracleX509KeyManager: getCertificateChain " + string);
        if (!this.c.containsKey(string)) {
            return null;
        }
        return ((C10)this.c.get(string)).b();
    }

    private static final boolean b(X509Certificate[] x509CertificateArray, Principal[] principalArray) {
        if (principalArray == null) {
            return true;
        }
        for (int i = 0; i < x509CertificateArray.length; ++i) {
            for (int j = 0; j < principalArray.length; ++j) {
                OracleSSLDebug.c("OracleX509KeyManager: check issuer " + principalArray[j]);
                if (!((Object)x509CertificateArray[i].getIssuerDN()).equals(principalArray[j])) continue;
                return true;
            }
        }
        return false;
    }
}

