/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.textui;

import com.phaos.cert.CertificateRequest;
import com.phaos.cert.X509;
import com.phaos.crypto.RSAPrivateKey;
import com.phaos.crypto.SignatureException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.math.BigInteger;
import java.security.KeyStore;
import java.util.ResourceBundle;
import oracle.security.pki.OraclePKIX509CertImpl;
import oracle.security.pki.internal.OraclePKIX509CertHelper;
import oracle.security.pki.textui.OraclePKIGenFunc;

public class OracleCertTextUI {
    static String a;
    static ResourceBundle b;

    public static void display(String[] stringArray) {
        String string = null;
        boolean bl = false;
        boolean bl2 = false;
        if (stringArray.length == 0) {
            System.out.println(a);
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-cert")) {
                string = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-summary")) {
                bl2 = true;
                continue;
            }
            if (stringArray[i].equals("-complete")) {
                bl = true;
                continue;
            }
            System.out.println(b.getString("INVALID_COMMAND_ERROR") + stringArray[i]);
            System.out.println(a);
            return;
        }
        OraclePKIX509CertImpl[] oraclePKIX509CertImplArray = null;
        try {
            oraclePKIX509CertImplArray = OraclePKIGenFunc.readCertsAt(string);
        }
        catch (IOException iOException) {
            System.out.println("Unable to read certificate at " + string);
            iOException.printStackTrace();
            return;
        }
        if (bl) {
            for (int i = 0; i < oraclePKIX509CertImplArray.length; ++i) {
                System.out.println(oraclePKIX509CertImplArray[i]);
            }
        } else {
            for (int i = 0; i < oraclePKIX509CertImplArray.length; ++i) {
                System.out.println("Subject:        " + oraclePKIX509CertImplArray[i].getSubjectDN());
                System.out.println(b.getString("GEN_ISSUER_OUT") + oraclePKIX509CertImplArray[i].getIssuerDN());
                System.out.println("Valid Until:    " + oraclePKIX509CertImplArray[i].getNotAfter());
            }
        }
    }

    public static void command(String[] stringArray) {
        if (stringArray.length == 0) {
            System.out.println(a);
            return;
        }
        if (stringArray[0].equals("help")) {
            System.out.println(a);
            return;
        }
        if (stringArray[0].equals("display")) {
            String[] stringArray2 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray2, 0, stringArray2.length);
            OracleCertTextUI.display(stringArray2);
        } else if (stringArray[0].equals("create")) {
            String[] stringArray3 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray3, 0, stringArray3.length);
            OracleCertTextUI.create(stringArray3);
        } else {
            System.out.println(b.getString("INVALID_COMMAND_ERROR") + stringArray[0]);
            System.out.println(a);
            return;
        }
    }

    static {
        b = ResourceBundle.getBundle("oracle.security.pki.resources.OraclePKIMsg");
        a = "cert:\ndisplay [-cert [url|filename]] <-summary> <-complete>\ncreate [-wallet [wallet]] [-request [url|filename]] [-cert [filename]]\n     [-validity [days]] <-summary> [-pwd <pwd>]\nhelp\n";
    }

    public static void create(String[] stringArray) {
        Object object;
        Object object2;
        String string = null;
        boolean bl = false;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        boolean bl2 = false;
        if (stringArray.length == 0) {
            System.out.println(a);
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-cert")) {
                string = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-request")) {
                string2 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-wallet")) {
                string3 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-validity")) {
                string4 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-summary")) {
                bl = true;
                continue;
            }
            if (stringArray[i].equals("-pwd")) {
                string5 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-obpwd")) {
                bl2 = true;
                continue;
            }
            System.out.println(b.getString("INVALID_COMMAND_ERROR") + stringArray[i]);
            System.out.println(a);
            return;
        }
        KeyStore keyStore = null;
        CertificateRequest certificateRequest = null;
        int n = 0;
        try {
            n = Integer.parseInt(string4);
            if (n <= 0) {
                throw new NumberFormatException("");
            }
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Validity must be a positive integer");
            return;
        }
        try {
            keyStore = OraclePKIGenFunc.openAWallet(string3, string5, bl2).getKeyStore();
        }
        catch (Exception exception) {
            System.out.println(b.getString("WALLET_LOAD_ERROR") + string3);
            return;
        }
        try {
            certificateRequest = OraclePKIGenFunc.readCertRequestAt(string2);
        }
        catch (Exception exception) {
            System.out.println("Unable to read certificate request at " + string2);
            return;
        }
        RSAPrivateKey rSAPrivateKey = null;
        X509 x509 = null;
        try {
            object2 = keyStore.aliases();
            while (object2.hasMoreElements()) {
                object = object2.nextElement();
                if (!keyStore.isKeyEntry((String)object)) continue;
                rSAPrivateKey = new RSAPrivateKey(keyStore.getKey((String)object, null).getEncoded());
                x509 = ((OraclePKIX509CertImpl)keyStore.getCertificate((String)object)).getX509();
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (rSAPrivateKey == null || x509 == null) {
            System.out.println("No valid user certificate found in wallet");
            return;
        }
        try {
            object2 = new X509(certificateRequest, x509, rSAPrivateKey, BigInteger.ZERO, n);
            OraclePKIX509CertHelper.writeB64X509CertTo((Writer)new FileWriter(string), (X509)object2);
            if (bl) {
                object = new OraclePKIX509CertImpl((X509)object2);
                System.out.println("Subject:        " + ((OraclePKIX509CertImpl)object).getSubjectDN());
                System.out.println(b.getString("GEN_ISSUER_OUT") + ((OraclePKIX509CertImpl)object).getIssuerDN());
                System.out.println("Valid Until:    " + ((OraclePKIX509CertImpl)object).getNotAfter());
            }
        }
        catch (SignatureException signatureException) {
            System.out.println("Unable to create certificate");
        }
        catch (IOException iOException) {
            System.out.println("Unable to save certificate at " + string);
        }
    }
}

