/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.textui;

import com.phaos.cert.CertificateRequest;
import com.phaos.cert.PKCS7;
import com.phaos.cert.X500Name;
import com.phaos.cert.X509;
import com.phaos.crypto.KeyPair;
import com.phaos.crypto.PrivateKey;
import com.phaos.crypto.RSAKeyPairGenerator;
import com.phaos.crypto.RSAPrivateKey;
import com.phaos.crypto.RSAPublicKey;
import com.phaos.crypto.SHA1RandomBitsSource;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.Enumeration;
import java.util.ResourceBundle;
import oracle.security.admin.wltmgr.owmo.OwmoClient;
import oracle.security.pki.OraclePKIRSAPrivateKey;
import oracle.security.pki.OraclePKIX509CertImpl;
import oracle.security.pki.OracleSecretStore;
import oracle.security.pki.OracleWallet;
import oracle.security.pki.internal.OraclePKIX509CertHelper;
import oracle.security.pki.internal.OraclePKIX509CertReqHelper;
import oracle.security.pki.textui.OraclePKIGenFunc;
import oracle.security.wallet.NZException;
import oracle.security.wallet.NZPersona;
import oracle.security.wallet.NZWallet;

public class OracleWalletTextUI {
    static String b;
    static ResourceBundle c;

    private static char[] a() {
        boolean bl;
        char[] cArray = null;
        char[] cArray2 = null;
        do {
            bl = (cArray = OraclePKIGenFunc.getPassword("ENTER_PASSWORD")).length == (cArray2 = OraclePKIGenFunc.getPassword("ENTER_PASSWORD_AGAIN")).length;
            for (int i = 0; i < cArray.length && bl; ++i) {
                bl = cArray[i] == cArray2[i];
            }
            if (bl) continue;
            System.out.println(c.getString("PASSWORD_NOT_MATCH_EERROR"));
        } while (!bl);
        return cArray;
    }

    static {
        c = ResourceBundle.getBundle("oracle.security.pki.resources.OraclePKIMsg");
        b = "wallet: \ncreate [-wallet [wallet]] [-auto_login] [-pwd <pwd>]\ndisplay [-wallet [wallet]] <-summary> [-pwd <pwd>]\nadd [-wallet [wallet]] <[-keysize [512|1024|2048]] [-dn [dn]] \n     <-self_signed [-validity [days]> <[-cert [filename]] \n     [-trusted_cert|-user_cert]> [-pwd <pwd>]\nexport [-wallet [wallet]] <-cert [filename]> <-request [filename]> [-pwd <pwd>]\nexport_trust_chain [-wallet <wlt>] -certchain <filename> [-dn <user cert dn>] [-pwd <pwd>]\np11_add [-wallet <wallet>] -p11_lib <pkcs11Lib> [-p11_tokenlabel <tokenLabel>] [-p11_tokenpw <tokenPassphrase>] [-p11_certlabel <certlabel>] [-pwd <pwd>]\np11_verify [-wallet <wallet>] [-pwd <pwd>]\nhelp\n";
    }

    public static void p11_add(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        boolean bl = false;
        if (stringArray.length == 0) {
            System.out.println(b);
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-wallet")) {
                string = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-p11_lib")) {
                string2 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-p11_tokenlabel")) {
                string3 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-p11_tokenpw")) {
                string4 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-p11_certlabel")) {
                string5 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-pwd")) {
                string6 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-obpwd")) {
                bl = true;
                continue;
            }
            System.out.println(c.getString("INVALID_COMMAND_ERROR") + stringArray[i]);
            System.out.println(b);
            return;
        }
        char[] cArray = OraclePKIGenFunc.getPassword(string6, bl, "WALLET_PASSWORD_PROMPT");
        NZWallet nZWallet = null;
        try {
            nZWallet = NZWallet.getPersonasWithTypeOld((String)("file:" + string), (String)new String(cArray));
            nZWallet.setWRL("file:" + string);
            nZWallet.setPersonaTypes(new String(cArray));
        }
        catch (Exception exception) {
            System.out.println(c.getString("WALLET_LOAD_ERROR") + string);
            return;
        }
        try {
            nZWallet.addPkcs11Info(string2, string3, string4, string5);
        }
        catch (NZException nZException) {
            System.out.println("Error: " + nZException.getExceptionId());
        }
        try {
            nZWallet.storeWallet();
            OracleWallet oracleWallet = new OracleWallet();
            oracleWallet.open(string, cArray);
            oracleWallet.save();
        }
        catch (NZException nZException) {
            System.out.println("Error: " + nZException.getExceptionId());
        }
        catch (Exception exception) {
            System.out.println(c.getString("GEN_UNKNOWN_ERROR"));
            return;
        }
    }

    public static void create(String[] stringArray) {
        boolean bl;
        boolean bl2 = false;
        String string = null;
        String string2 = null;
        boolean bl3 = false;
        if (stringArray.length == 0) {
            System.out.println(b);
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-wallet")) {
                string = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-auto_login")) {
                bl2 = true;
                continue;
            }
            if (stringArray[i].equals("-pwd")) {
                string2 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-obpwd")) {
                bl3 = true;
                continue;
            }
            System.out.println(c.getString("INVALID_COMMAND_ERROR") + stringArray[i]);
            System.out.println(b);
            return;
        }
        OracleWallet oracleWallet = new OracleWallet();
        try {
            OracleWallet oracleWallet2 = new OracleWallet();
            oracleWallet2.create(new char[]{'a', '2', 'v', 'b', 'n', '9', '8', 'z'});
            bl = oracleWallet2.exists(string);
        }
        catch (IOException iOException) {
            System.out.println(c.getString("GEN_UNKNOWN_ERROR") + string);
            return;
        }
        if (bl && !bl2) {
            System.out.println(c.getString("WALLET_EXISTS_ERROR") + string);
            return;
        }
        if (bl && bl2) {
            try {
                oracleWallet.open(string, OraclePKIGenFunc.getPassword(string2, bl3, "WALLET_PASSWORD_PROMPT"));
            }
            catch (Exception exception) {
                System.out.println(c.getString("WALLET_LOAD_ERROR") + string);
                return;
            }
        }
        try {
            oracleWallet.create(OraclePKIGenFunc.getCreatePassword(string2, bl3));
            oracleWallet.saveAs(string);
        }
        catch (IOException iOException) {
            System.out.println("Unable to save wallet at " + string);
            return;
        }
        if (bl2) {
            try {
                oracleWallet.createSSO();
            }
            catch (IOException iOException) {
                System.out.println("Unable to save wallet at " + string);
                return;
            }
        }
    }

    public static void export(String[] stringArray) {
        KeyStore keyStore;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        boolean bl = false;
        if (stringArray.length == 0) {
            System.out.println(b);
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-wallet")) {
                string = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-dn")) {
                string2 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-request")) {
                string3 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-cert")) {
                string4 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-pwd")) {
                string5 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-obpwd")) {
                bl = true;
                continue;
            }
            System.out.println(c.getString("INVALID_COMMAND_ERROR") + stringArray[i]);
            System.out.println(b);
            return;
        }
        try {
            OracleWallet oracleWallet = OraclePKIGenFunc.openAWallet(string, string5, bl);
            keyStore = oracleWallet.getKeyStore();
        }
        catch (Exception exception) {
            System.out.println(c.getString("WALLET_LOAD_ERROR"));
            return;
        }
        if (string4 != null) {
            X500Name x500Name = new X500Name(string2);
            try {
                Enumeration<String> enumeration = keyStore.aliases();
                while (enumeration.hasMoreElements()) {
                    String string6;
                    String string7 = enumeration.nextElement();
                    OraclePKIX509CertImpl oraclePKIX509CertImpl = (OraclePKIX509CertImpl)keyStore.getCertificate(string7);
                    if (oraclePKIX509CertImpl == null || !(string6 = ((Object)oraclePKIX509CertImpl.getSubjectDN()).toString().toUpperCase()).startsWith(x500Name.toString().toUpperCase())) continue;
                    OraclePKIX509CertHelper.writeB64X509CertTo((Writer)new FileWriter(string4), oraclePKIX509CertImpl.getX509());
                    return;
                }
            }
            catch (IOException iOException) {
                System.out.println("Unable to save certificate at " + string4);
            }
            catch (KeyStoreException keyStoreException) {
                System.out.println(c.getString("GEN_UNKNOWN_ERROR"));
            }
            System.out.println(string2 + " not found in wallet");
        } else if (string3 != null) {
            X500Name x500Name = new X500Name(string2);
            try {
                Enumeration<String> enumeration = keyStore.aliases();
                while (enumeration.hasMoreElements()) {
                    CertificateRequest certificateRequest;
                    String string8;
                    String string9 = enumeration.nextElement();
                    if (!keyStore.isKeyEntry(string9) || !(string8 = (certificateRequest = ((OraclePKIRSAPrivateKey)keyStore.getKey(string9, null)).getCertificateRequest()).getSubject().toString().toUpperCase()).startsWith(x500Name.toString().toUpperCase())) continue;
                    OraclePKIX509CertReqHelper.writeB64X509CertReqTo(new FileWriter(string3), certificateRequest);
                    return;
                }
                System.out.println(string2 + " not found in wallet");
            }
            catch (IOException iOException) {
                System.out.println("Unable to save certificate request at" + string3);
            }
            catch (KeyStoreException keyStoreException) {
                System.out.println(c.getString("GEN_UNKNOWN_ERROR"));
            }
            catch (GeneralSecurityException generalSecurityException) {
                System.out.println(c.getString("GEN_UNKNOWN_ERROR"));
            }
        }
    }

    public static void p11_verify(String[] stringArray) {
        String string = null;
        String string2 = null;
        boolean bl = false;
        if (stringArray.length == 0) {
            System.out.println(b);
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-wallet")) {
                string = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-pwd")) {
                string2 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-obpwd")) {
                bl = true;
                continue;
            }
            System.out.println(c.getString("INVALID_COMMAND_ERROR") + stringArray[i]);
            System.out.println(b);
            return;
        }
        char[] cArray = OraclePKIGenFunc.getPassword(string2, bl, "WALLET_PASSWORD_PROMPT");
        NZWallet nZWallet = null;
        try {
            nZWallet = NZWallet.getPersonasWithTypeOld((String)("file:" + string), (String)new String(cArray));
            nZWallet.setWRL("file:" + string);
            nZWallet.setPersonaTypes(new String(cArray));
        }
        catch (Exception exception) {
            System.out.println(c.getString("WALLET_LOAD_ERROR") + string);
            return;
        }
        try {
            nZWallet.verifyPkcs11Credentials();
        }
        catch (NZException nZException) {
            System.out.println("Error: " + nZException.getExceptionId());
        }
    }

    public static void display(String[] stringArray) {
        KeyStore keyStore;
        OracleWallet oracleWallet;
        boolean bl = true;
        boolean bl2 = false;
        String string = null;
        String string2 = null;
        boolean bl3 = false;
        if (stringArray.length == 0) {
            System.out.println(b);
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-wallet")) {
                string = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-summary")) {
                bl = true;
                ++i;
                continue;
            }
            if (stringArray[i].equals("-complete")) {
                bl2 = true;
                ++i;
                continue;
            }
            if (stringArray[i].equals("-pwd")) {
                string2 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-obpwd")) {
                bl3 = true;
                continue;
            }
            System.out.println(c.getString("INVALID_COMMAND_ERROR") + stringArray[i]);
            System.out.println(b);
            return;
        }
        try {
            oracleWallet = OraclePKIGenFunc.openAWallet(string, string2, bl3);
            keyStore = oracleWallet.getKeyStore();
            OracleSecretStore oracleSecretStore = oracleWallet.getSecretStore();
        }
        catch (Exception exception) {
            System.out.println(c.getString("WALLET_LOAD_ERROR") + string);
            return;
        }
        if (bl) {
            try {
                Object object;
                Object object2;
                System.out.println("Requested Certificates: ");
                Enumeration<String> enumeration = keyStore.aliases();
                while (enumeration.hasMoreElements()) {
                    object2 = enumeration.nextElement();
                    if (!keyStore.isKeyEntry((String)object2) || keyStore.getCertificate((String)object2) != null || (object = ((OraclePKIRSAPrivateKey)keyStore.getKey((String)object2, null)).getCertificateRequest()) == null) continue;
                    System.out.println("Subject:        " + ((CertificateRequest)object).getSubject());
                }
                System.out.println("User Certificates:");
                enumeration = keyStore.aliases();
                while (enumeration.hasMoreElements()) {
                    object2 = enumeration.nextElement();
                    if (!keyStore.isKeyEntry((String)object2) || (object = (OraclePKIX509CertImpl)keyStore.getCertificate((String)object2)) == null) continue;
                    System.out.println("Subject:        " + ((OraclePKIX509CertImpl)object).getSubjectDN());
                }
                object2 = oracleWallet.getSecretStore().internalAliases();
                if (object2.hasMoreElements()) {
                    System.out.println(c.getString("ENTRIES_LIST"));
                }
                while (object2.hasMoreElements()) {
                    System.out.println(object2.nextElement());
                }
                System.out.println("Trusted Certificates: ");
                enumeration = keyStore.aliases();
                while (enumeration.hasMoreElements()) {
                    object = enumeration.nextElement();
                    if (!keyStore.isCertificateEntry((String)object)) continue;
                    OraclePKIX509CertImpl oraclePKIX509CertImpl = (OraclePKIX509CertImpl)keyStore.getCertificate((String)object);
                    System.out.println("Subject:        " + oraclePKIX509CertImpl.getSubjectDN());
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.out.println(c.getString("GEN_UNKNOWN_ERROR") + string);
                return;
            }
        }
    }

    public static void command(String[] stringArray) {
        if (stringArray.length == 0) {
            System.out.println(b);
            return;
        }
        if (stringArray[0].equals("help")) {
            System.out.println(b);
            return;
        }
        if (stringArray[0].equals("display")) {
            String[] stringArray2 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray2, 0, stringArray2.length);
            OracleWalletTextUI.display(stringArray2);
        } else if (stringArray[0].equals("create")) {
            String[] stringArray3 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray3, 0, stringArray3.length);
            OracleWalletTextUI.create(stringArray3);
        } else if (stringArray[0].equals("add")) {
            String[] stringArray4 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray4, 0, stringArray4.length);
            OracleWalletTextUI.add(stringArray4);
        } else if (stringArray[0].equals("p11_add")) {
            String[] stringArray5 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray5, 0, stringArray5.length);
            OracleWalletTextUI.p11_add(stringArray5);
        } else if (stringArray[0].equals("p11_verify")) {
            String[] stringArray6 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray6, 0, stringArray6.length);
            OracleWalletTextUI.p11_verify(stringArray6);
        } else if (stringArray[0].equals("export")) {
            String[] stringArray7 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray7, 0, stringArray7.length);
            OracleWalletTextUI.export(stringArray7);
        } else if (stringArray[0].equals("export_trust_chain")) {
            String[] stringArray8 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray8, 0, stringArray8.length);
            OracleWalletTextUI.exportchain(stringArray8);
        } else {
            System.out.println(c.getString("INVALID_COMMAND_ERROR") + stringArray[0]);
            System.out.println(b);
            return;
        }
    }

    public static void add(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        String string7 = null;
        boolean bl4 = false;
        if (stringArray.length == 0) {
            System.out.println(b);
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-wallet")) {
                string = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-dn")) {
                string2 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-keysize")) {
                string3 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-validity")) {
                string4 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-self_signed")) {
                bl = true;
                continue;
            }
            if (stringArray[i].equals("-request")) {
                string5 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-cert")) {
                string6 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-trusted_cert")) {
                bl2 = true;
                bl3 = false;
                continue;
            }
            if (stringArray[i].equals("-user_cert")) {
                bl2 = false;
                bl3 = true;
                continue;
            }
            if (stringArray[i].equals("-pwd")) {
                string7 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-obpwd")) {
                bl4 = true;
                continue;
            }
            System.out.println(c.getString("INVALID_COMMAND_ERROR") + stringArray[i]);
            System.out.println(b);
            return;
        }
        if (bl) {
            OracleWallet oracleWallet = new OracleWallet();
            char[] cArray = OraclePKIGenFunc.getPassword(string7, bl4, "WALLET_PASSWORD_PROMPT");
            try {
                oracleWallet.open(string, cArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.out.println(c.getString("WALLET_LOAD_ERROR") + string);
                return;
            }
            int n = 0;
            try {
                n = Integer.parseInt(string3);
                if (n != 512 && n != 1024 && n != 2048) {
                    throw new NumberFormatException("");
                }
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("Keysize must be 512 or 1024 or 2048");
                return;
            }
            int n2 = 0;
            if (bl) {
                n2 = 0;
                try {
                    n2 = Integer.parseInt(string4);
                    if (n2 <= 0) {
                        throw new NumberFormatException("");
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Validity must be a positive integer.");
                    return;
                }
            }
            if (bl) {
                RSAKeyPairGenerator rSAKeyPairGenerator = new RSAKeyPairGenerator();
                rSAKeyPairGenerator.initialize(n, new SHA1RandomBitsSource());
                KeyPair keyPair = rSAKeyPairGenerator.generateKeyPair();
                RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)keyPair.getPrivate();
                RSAPublicKey rSAPublicKey = (RSAPublicKey)keyPair.getPublic();
                X500Name x500Name = new X500Name(string2);
                CertificateRequest certificateRequest = new CertificateRequest(x500Name, keyPair);
                OraclePKIX509CertImpl oraclePKIX509CertImpl = null;
                try {
                    oraclePKIX509CertImpl = new OraclePKIX509CertImpl(new X509(x500Name, rSAPublicKey, x500Name, (PrivateKey)rSAPrivateKey, BigInteger.ZERO, n2));
                }
                catch (Exception exception) {
                    System.out.println(c.getString("GEN_UNKNOWN_ERROR"));
                    return;
                }
                try {
                    if (oraclePKIX509CertImpl != null) {
                        oracleWallet.internalAddCertReq(certificateRequest, rSAPrivateKey);
                        oracleWallet.internalAddTrustedCert(oraclePKIX509CertImpl);
                    }
                    oracleWallet.save();
                    NZWallet nZWallet = NZWallet.getPersonasWithTypeOld((String)("file:" + string), (String)new String(cArray));
                    nZWallet.setWRL("file:" + string);
                    nZWallet.setPersonaTypes(new String(cArray));
                    NZPersona nZPersona = nZWallet.getPersonabyIndex(0);
                    nZWallet.installCerts(nZPersona, "NZDST_CERTIFICATE", oraclePKIX509CertImpl.getEncoded());
                    nZWallet.storeWallet();
                    oracleWallet.open(string, cArray);
                    oracleWallet.save();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    System.out.println(c.getString("GEN_UNKNOWN_ERROR") + string);
                    return;
                }
            }
        } else {
            char[] cArray = OraclePKIGenFunc.getPassword(string7, bl4, "WALLET_PASSWORD_PROMPT");
            NZWallet nZWallet = null;
            try {
                nZWallet = NZWallet.getPersonasWithTypeOld((String)("file:" + string), (String)new String(cArray));
                nZWallet.setWRL("file:" + string);
                nZWallet.setPersonaTypes(new String(cArray));
            }
            catch (Exception exception) {
                System.out.println(c.getString("WALLET_LOAD_ERROR") + string);
                return;
            }
            NZPersona nZPersona = nZWallet.getPersonabyIndex(0);
            if (string2 != null) {
                int n = 0;
                try {
                    n = Integer.parseInt(string3);
                    if (n != 512 && n != 1024 && n != 2048) {
                        throw new NumberFormatException("");
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Keysize must be 512 or 1024 or 2048");
                    return;
                }
                try {
                    String string8 = OwmoClient.reverseToken((String)string2);
                    nZPersona.addCertRequest(string8, n, nZWallet.getPersonaTypes());
                    nZWallet.storeWallet();
                    OracleWallet oracleWallet = new OracleWallet();
                    oracleWallet.open(string, cArray);
                    oracleWallet.save();
                }
                catch (Exception exception) {
                    System.out.println(c.getString("GEN_UNKNOWN_ERROR"));
                    return;
                }
            }
            if (string6 != null) {
                try {
                    InputStream inputStream;
                    try {
                        inputStream = new URL(string6).openStream();
                    }
                    catch (MalformedURLException malformedURLException) {
                        inputStream = new FileInputStream(string6);
                    }
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    int n = inputStream.read();
                    while (n != -1) {
                        byteArrayOutputStream.write((byte)n);
                        n = inputStream.read();
                    }
                    if (bl2) {
                        nZWallet.installCerts(nZPersona, "NZDST_CLEAR_PTP", byteArrayOutputStream.toByteArray());
                    } else if (bl3) {
                        try {
                            nZWallet.installCerts(nZPersona, "NZDST_CERTIFICATE", byteArrayOutputStream.toByteArray());
                        }
                        catch (NZException nZException) {
                            System.out.println("Could not install user cert at" + string6);
                            System.out.println("Please add all trusted certificates before adding the user certificate");
                        }
                    }
                    nZWallet.storeWallet();
                    OracleWallet oracleWallet = new OracleWallet();
                    oracleWallet.open(string, cArray);
                    oracleWallet.save();
                }
                catch (IOException iOException) {
                    System.out.println("Unable to read certificate at " + string6);
                }
                catch (NZException nZException) {
                    System.out.println(c.getString("GEN_UNKNOWN_ERROR"));
                }
            }
        }
    }

    public static void exportchain(String[] stringArray) {
        KeyStore keyStore;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        boolean bl = false;
        if (stringArray.length == 0) {
            System.out.println(b);
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-wallet")) {
                string = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-dn")) {
                string2 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-certchain")) {
                string3 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-pwd")) {
                string4 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-obpwd")) {
                bl = true;
                continue;
            }
            System.out.println(c.getString("INVALID_COMMAND_ERROR") + stringArray[i]);
            System.out.println(b);
            return;
        }
        try {
            OracleWallet oracleWallet = OraclePKIGenFunc.openAWallet(string, string4, bl);
            keyStore = oracleWallet.getKeyStore();
        }
        catch (Exception exception) {
            System.out.println(c.getString("WALLET_LOAD_ERROR"));
            return;
        }
        try {
            Object object;
            Enumeration<String> enumeration;
            Certificate[] certificateArray;
            String string5 = null;
            boolean bl2 = false;
            if (string2 != null) {
                certificateArray = new X500Name(string2);
                enumeration = keyStore.aliases();
                while (enumeration.hasMoreElements()) {
                    String string6;
                    string5 = enumeration.nextElement();
                    object = (OraclePKIX509CertImpl)keyStore.getCertificate(string5);
                    if (object == null || !(string6 = ((Object)((OraclePKIX509CertImpl)object).getSubjectDN()).toString().toUpperCase()).startsWith(certificateArray.toString().toUpperCase())) continue;
                    bl2 = true;
                    break;
                }
                if (!bl2) {
                    System.out.println("No certificate with matching DN found in wallet.");
                    return;
                }
            } else {
                enumeration = keyStore.aliases();
                while (enumeration.hasMoreElements()) {
                    string5 = enumeration.nextElement();
                    if (!keyStore.isKeyEntry(string5)) continue;
                    bl2 = true;
                    break;
                }
                if (!bl2) {
                    System.out.println("No user certificate found in wallet.");
                    return;
                }
            }
            certificateArray = keyStore.getCertificateChain(string5);
            object = new PKCS7();
            if (certificateArray.length > 1) {
                for (int i = 1; i < certificateArray.length; ++i) {
                    ((PKCS7)object).addCertificate(new X509(((OraclePKIX509CertImpl)certificateArray[i]).getEncoded()));
                }
            } else if (certificateArray.length == 1) {
                ((PKCS7)object).addCertificate(new X509(((OraclePKIX509CertImpl)certificateArray[0]).getEncoded()));
            } else {
                System.out.println("Certificate chain length is zero");
                return;
            }
            OraclePKIX509CertHelper.writeB64X509CertTo((Writer)new FileWriter(string3), ((PKCS7)object).getEncoded());
            return;
        }
        catch (CertificateEncodingException certificateEncodingException) {
            certificateEncodingException.printStackTrace();
            return;
        }
        catch (IOException iOException) {
            System.out.println("Unable to export trust chain.");
            iOException.printStackTrace();
            return;
        }
        catch (KeyStoreException keyStoreException) {
            System.out.println(c.getString("GEN_UNKNOWN_ERROR"));
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println(c.getString("GEN_UNKNOWN_ERROR") + string);
            return;
        }
    }
}

