/*
 * Decompiled with CFR 0.152.
 */
package javax.security.cert;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import javax.security.cert.CertificateEncodingException;
import javax.security.cert.CertificateException;

public abstract class Certificate {
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Certificate)) {
            return false;
        }
        try {
            byte[] byArray = this.getEncoded();
            byte[] byArray2 = ((Certificate)object).getEncoded();
            if (byArray.length != byArray2.length) {
                return false;
            }
            int n = 0;
            while (n < byArray.length) {
                if (byArray[n] != byArray2[n]) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        catch (CertificateException certificateException) {
            return false;
        }
    }

    public abstract byte[] getEncoded() throws CertificateEncodingException;

    public abstract PublicKey getPublicKey();

    public int hashCode() {
        int n = 0;
        try {
            byte[] byArray = this.getEncoded();
            int n2 = 1;
            while (n2 < byArray.length) {
                n += byArray[n2] * n2;
                ++n2;
            }
            return n;
        }
        catch (CertificateException certificateException) {
            return n;
        }
    }

    public abstract String toString();

    public abstract void verify(PublicKey var1) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException;

    public abstract void verify(PublicKey var1, String var2) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException;
}

