/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.KeyManager;
import com.sun.net.ssl.KeyManagerFactory;
import com.sun.net.ssl.SSLContextSpi;
import com.sun.net.ssl.TrustManager;
import com.sun.net.ssl.TrustManagerFactory;
import com.sun.net.ssl.X509KeyManager;
import com.sun.net.ssl.X509TrustManager;
import com.sun.net.ssl.internal.ssl.Debug;
import com.sun.net.ssl.internal.ssl.JsseX509KeyManager;
import com.sun.net.ssl.internal.ssl.JsseX509TrustManager;
import com.sun.net.ssl.internal.ssl.SSLServerSocketFactoryImpl;
import com.sun.net.ssl.internal.ssl.SSLSessionContextImpl;
import com.sun.net.ssl.internal.ssl.SSLSocketFactoryImpl;
import com.sun.net.ssl.internal.ssl.TrustManagerFactoryImpl;
import java.io.FileInputStream;
import java.security.AccessController;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SecureRandom;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;

public final class SSLContextImpl
extends SSLContextSpi {
    private static SSLContextImpl a;
    private X509KeyManager b;
    private X509TrustManager c;
    private SecureRandom d;
    private SSLSessionContextImpl e = new SSLSessionContextImpl();
    private SSLSessionContextImpl f = new SSLSessionContextImpl();
    private static final Debug g;

    static {
        g = Debug.getInstance("ssl");
    }

    static /* synthetic */ SSLContextImpl b() {
        return a;
    }

    protected SSLServerSocketFactory engineGetServerSocketFactory() {
        return new SSLServerSocketFactoryImpl(this);
    }

    protected SSLSocketFactory engineGetSocketFactory() {
        return new SSLSocketFactoryImpl(this);
    }

    protected void engineInit(KeyManager[] keyManagerArray, TrustManager[] trustManagerArray, SecureRandom secureRandom) throws KeyManagementException {
        this.b = new JsseX509KeyManager(keyManagerArray);
        if (trustManagerArray == null) {
            try {
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
                trustManagerFactory.init(null);
                trustManagerArray = trustManagerFactory.getTrustManagers();
            }
            catch (Exception exception) {}
        }
        this.c = new JsseX509TrustManager(trustManagerArray);
        if (secureRandom == null) {
            secureRandom = new SecureRandom();
        }
        this.d = secureRandom;
        if (g != null && Debug.isOn("sslctx")) {
            System.out.println("trigger seeding of SecureRandom");
        }
        this.d.nextInt();
        if (g != null && Debug.isOn("sslctx")) {
            System.out.println("done seeding SecureRandom");
        }
    }

    SSLSessionContextImpl c() {
        return this.e;
    }

    static synchronized SSLContextImpl d() {
        if (a != null) {
            return a;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    Object object;
                    FileInputStream fileInputStream = null;
                    KeyStore keyStore = null;
                    SSLContextImpl sSLContextImpl = null;
                    String string = System.getProperty("javax.net.ssl.keyStore", "");
                    String string2 = System.getProperty("javax.net.ssl.keyStoreType", KeyStore.getDefaultType());
                    String string3 = System.getProperty("javax.net.ssl.keyStorePassword", "");
                    if (g != null && Debug.isOn("defaultctx")) {
                        System.out.println("keyStore is : " + string);
                        System.out.println("keyStore type is : " + string2);
                    }
                    if (string.length() != 0) {
                        fileInputStream = new FileInputStream(string);
                    }
                    if (string2.length() != 0) {
                        if (g != null && Debug.isOn("defaultctx")) {
                            System.out.println("init keystore");
                        }
                        keyStore = KeyStore.getInstance(string2);
                        object = null;
                        if (string3.length() != 0) {
                            object = string3.toCharArray();
                        }
                        keyStore.load(fileInputStream, (char[])object);
                    }
                    if (fileInputStream != null) {
                        fileInputStream.close();
                        fileInputStream = null;
                    }
                    if (g != null && Debug.isOn("defaultctx")) {
                        System.out.println("init keymanager of type " + KeyManagerFactory.getDefaultAlgorithm());
                    }
                    object = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                    ((KeyManagerFactory)object).init(keyStore, string3.toCharArray());
                    KeyManager[] keyManagerArray = ((KeyManagerFactory)object).getKeyManagers();
                    keyStore = TrustManagerFactoryImpl.a("defaultctx");
                    TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    TrustManager[] trustManagerArray = null;
                    trustManagerFactory.init(keyStore);
                    trustManagerArray = trustManagerFactory.getTrustManagers();
                    if (g != null && Debug.isOn("defaultctx")) {
                        System.out.println("init context");
                    }
                    sSLContextImpl = new SSLContextImpl();
                    sSLContextImpl.engineInit(keyManagerArray, trustManagerArray, null);
                    a = sSLContextImpl;
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            if (g != null && Debug.isOn("defaultctx")) {
                System.out.println("default context init failed: " + privilegedActionException);
            }
            throw new RuntimeException("Default SSL context init failed: " + privilegedActionException.getMessage());
        }
        catch (RuntimeException runtimeException) {
            if (g != null && Debug.isOn("defaultctx")) {
                System.out.println("default context init failed: " + runtimeException);
            }
            throw runtimeException;
        }
        catch (Error error) {
            if (g != null && Debug.isOn("defaultctx")) {
                System.out.println("default context init failed: " + error);
            }
            throw error;
        }
        return a;
    }

    SecureRandom e() {
        return this.d;
    }

    SSLSessionContextImpl f() {
        return this.f;
    }

    X509KeyManager g() {
        return this.b;
    }

    X509TrustManager h() {
        return this.c;
    }
}

