/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.SSLPermission;
import com.sun.net.ssl.internal.ssl.CipherSpec;
import com.sun.net.ssl.internal.ssl.Debug;
import com.sun.net.ssl.internal.ssl.SSLSessionContextImpl;
import com.sun.net.ssl.internal.ssl.SecureKey;
import com.sun.net.ssl.internal.ssl.SessionId;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.security.cert.CertificateEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionBindingEvent;
import javax.net.ssl.SSLSessionBindingListener;
import javax.net.ssl.SSLSessionContext;
import javax.security.cert.CertificateException;
import javax.security.cert.X509Certificate;

final class SSLSessionImpl
implements SSLSession {
    static final SSLSessionImpl a = new SSLSessionImpl();
    private static final byte b = 0;
    private SessionId c;
    private java.security.cert.X509Certificate[] d;
    private byte e;
    private CipherSpec f;
    private byte[] g;
    private final long h = System.currentTimeMillis();
    private long i = 0L;
    private String j;
    private int k;
    private SSLSessionContextImpl l;
    private int m;
    private boolean n;
    private boolean o;
    private static int p = 0;
    private static boolean q = true;
    private static final Debug r = Debug.getInstance("ssl");
    private Hashtable s = new Hashtable();

    SSLSessionImpl() {
        this(new CipherSpec(), new SessionId(false, null), null, -1);
    }

    SSLSessionImpl(CipherSpec cipherSpec, SessionId sessionId, String string, int n) {
        this.c = sessionId;
        this.d = null;
        this.e = 0;
        this.f = cipherSpec;
        this.g = null;
        this.j = string;
        this.k = n;
        this.m = ++p;
        if (r != null && Debug.isOn("session")) {
            System.out.println("%% Created:  " + this);
        }
    }

    SSLSessionImpl(CipherSpec cipherSpec, SecureRandom secureRandom, String string, int n) {
        this(cipherSpec, new SessionId(q, secureRandom), string, n);
    }

    boolean a(SessionId sessionId) {
        return this.c != null && this.c.equals(sessionId);
    }

    public void finalize() {
        String[] stringArray = this.getValueNames();
        int n = 0;
        while (n < stringArray.length) {
            this.removeValue(stringArray[n]);
            ++n;
        }
    }

    public java.security.cert.X509Certificate[] getCertificateChain() throws SSLPeerUnverifiedException {
        if (this.d != null) {
            return (java.security.cert.X509Certificate[])this.d.clone();
        }
        throw new SSLPeerUnverifiedException("peer not authenticated");
    }

    CipherSpec a() {
        return this.f;
    }

    public String getCipherSuite() {
        return this.f.toString();
    }

    byte b() {
        return this.e;
    }

    public long getCreationTime() {
        return this.h;
    }

    public byte[] getId() {
        return this.c.a();
    }

    public long getLastAccessedTime() {
        return this.i != 0L ? this.i : this.h;
    }

    byte[] c() {
        return this.g;
    }

    public InetAddress getPeerAddress() {
        try {
            return InetAddress.getByName(this.j);
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    public X509Certificate[] getPeerCertificateChain() throws SSLPeerUnverifiedException {
        if (this.d == null) {
            throw new SSLPeerUnverifiedException("peer not authenticated");
        }
        X509Certificate[] x509CertificateArray = new X509Certificate[this.d.length];
        int n = 0;
        while (n < this.d.length) {
            byte[] byArray = null;
            try {
                byArray = this.d[n].getEncoded();
                x509CertificateArray[n] = X509Certificate.getInstance(byArray);
            }
            catch (CertificateEncodingException certificateEncodingException) {
                throw new SSLPeerUnverifiedException(certificateEncodingException.getMessage());
            }
            catch (CertificateException certificateException) {
                throw new SSLPeerUnverifiedException(certificateException.getMessage());
            }
            ++n;
        }
        return x509CertificateArray;
    }

    public String getPeerHost() {
        return this.j;
    }

    public SSLSessionContext getSessionContext() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SSLPermission("getSSLSessionContext"));
        }
        return this.l;
    }

    SessionId d() {
        return this.c;
    }

    public Object getValue(String string) {
        SecureKey secureKey = new SecureKey(string);
        return this.s.get(secureKey);
    }

    public String[] getValueNames() {
        Vector<Object> vector = new Vector<Object>();
        Object object = SecureKey.b();
        Enumeration enumeration = this.s.keys();
        while (enumeration.hasMoreElements()) {
            SecureKey secureKey = (SecureKey)enumeration.nextElement();
            if (!object.equals(secureKey.c())) continue;
            vector.addElement(secureKey.a());
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public synchronized void invalidate() {
        if (this == a) {
            return;
        }
        this.o = true;
        if (r != null && Debug.isOn("session")) {
            System.out.println("%% Invalidated:  " + this);
        }
        if (this.l != null) {
            this.l.a(this.c);
            this.l = null;
        }
    }

    boolean e() {
        return this.c != null && this.c.b() != 0 && !this.o;
    }

    boolean f() {
        return this.n;
    }

    public void putValue(String string, Object object) {
        SSLSessionBindingEvent sSLSessionBindingEvent;
        SecureKey secureKey = new SecureKey(string);
        Object object2 = this.s.put(secureKey, object);
        if (object2 instanceof SSLSessionBindingListener) {
            sSLSessionBindingEvent = new SSLSessionBindingEvent(this, string);
            ((SSLSessionBindingListener)object2).valueUnbound(sSLSessionBindingEvent);
        }
        if (object instanceof SSLSessionBindingListener) {
            sSLSessionBindingEvent = new SSLSessionBindingEvent(this, string);
            ((SSLSessionBindingListener)object).valueBound(sSLSessionBindingEvent);
        }
    }

    public void removeValue(String string) {
        SecureKey secureKey = new SecureKey(string);
        Object v = this.s.remove(secureKey);
        if (v instanceof SSLSessionBindingListener) {
            SSLSessionBindingEvent sSLSessionBindingEvent = new SSLSessionBindingEvent(this, string);
            ((SSLSessionBindingListener)v).valueUnbound(sSLSessionBindingEvent);
        }
    }

    void a(SSLSessionContextImpl sSLSessionContextImpl) {
        if (this.l == null) {
            this.l = sSLSessionContextImpl;
        }
    }

    void a(long l) {
        this.i = l;
    }

    void a(byte[] byArray) {
        if (this.g == null) {
            this.g = byArray;
        }
    }

    void a(java.security.cert.X509Certificate[] x509CertificateArray) {
        if (this.d == null) {
            this.d = x509CertificateArray;
        }
    }

    void a(boolean bl) {
        this.n = bl;
    }

    public String toString() {
        return "[Session-" + this.m + ", " + this.getCipherSuite() + "]";
    }
}

