/*
 * Decompiled with CFR 0.152.
 */
package com.sun.swup.client.engine.solaris;

import com.sun.cns.authentication.CMDExecutionException;
import com.sun.cns.authentication.NotAuthenticatedException;
import com.sun.swup.client.common.I18NHelper;
import com.sun.swup.client.engine.solaris.CategoryFileException;
import com.sun.swup.client.wrapper.PatchProWrapper;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class PatchCategory {
    private static String[] categories = null;
    private static String[] precedenceCategory = null;
    private static String[] displayCategory = null;
    private static Hashtable categoryTable = null;
    private static PatchProWrapper ppro = PatchProWrapper.getInstance();
    public static I18NHelper I18N = new I18NHelper(class$com$sun$swup$client$engine$solaris$PatchCategory == null ? (class$com$sun$swup$client$engine$solaris$PatchCategory = PatchCategory.class$("com.sun.swup.client.engine.solaris.PatchCategory")) : class$com$sun$swup$client$engine$solaris$PatchCategory, "resources/strings/warning");
    private static PatchCategory categoryObj = null;
    public static final int AUTH_CMD_EXCEPTION = 1;
    public static final int CATEGORY_ZERO_LENGTH = 2;
    public static final int CANT_PARSE_CATEGORY = 3;
    static /* synthetic */ Class class$com$sun$swup$client$engine$solaris$PatchCategory;

    public PatchCategory() throws CMDExecutionException, NotAuthenticatedException, CategoryFileException {
        this.processCategories();
    }

    public static PatchCategory getInstance() throws CMDExecutionException, NotAuthenticatedException, CategoryFileException {
        if (categoryObj == null) {
            categoryObj = new PatchCategory();
        }
        return categoryObj;
    }

    public static void invalidatePatchCategory() {
        categoryObj = null;
    }

    public static boolean isCategoryObjInit() {
        return categoryObj != null;
    }

    private void processCategories() throws CMDExecutionException, NotAuthenticatedException, CategoryFileException {
        String line = null;
        String output = null;
        CategoryFileException exception = null;
        try {
            output = ppro.getCategoryFile(null);
        }
        catch (CMDExecutionException ce) {
            exception = new CategoryFileException(ce.getErrorMessage(), 1);
            categoryObj = null;
            throw exception;
        }
        if (output == null || output.length() == 0) {
            exception = new CategoryFileException(I18N.getString("category-zero-length"), 2);
            categoryObj = null;
            throw exception;
        }
        String[] lines = output.split("\n");
        String name = null;
        String reals = null;
        int prec = -1;
        int disp = -1;
        CategoryProperty category = null;
        for (int i = 0; i < lines.length; ++i) {
            line = lines[i];
            if (line == null || line.startsWith("#") || line.trim().length() <= 0) continue;
            if (line.indexOf(".name") != -1) {
                name = line.substring(line.indexOf("=") + 1);
            } else if (line.indexOf(".realizations") != -1) {
                reals = line.substring(line.indexOf("=") + 1);
                if (reals == null) {
                    reals = "";
                }
            } else if (line.indexOf(".precedence") != -1) {
                prec = Integer.parseInt(line.substring(line.indexOf("=") + 1));
            } else if (line.indexOf(".display") != -1) {
                disp = Integer.parseInt(line.substring(line.indexOf("=") + 1));
            }
            if (name == null || reals == null || prec == -1 || disp == -1) continue;
            category = new CategoryProperty(name, reals, prec, disp);
            if (categoryTable == null) {
                categoryTable = new Hashtable();
            }
            categoryTable.put(name, category);
            name = null;
            reals = null;
            prec = -1;
            disp = -1;
        }
        if (categoryTable == null || categoryTable.size() == 0) {
            exception = new CategoryFileException(I18N.getString("category-content-error"), 3);
            throw exception;
        }
    }

    public String[] getUpdateCategories() {
        if (categories != null && categories.length > 0) {
            return categories;
        }
        String[] categories = null;
        Enumeration catKeys = null;
        ArrayList<String> catList = null;
        if (categoryTable != null && categoryTable.size() > 0) {
            catKeys = categoryTable.keys();
        }
        if (catKeys != null) {
            catList = new ArrayList<String>();
            while (catKeys.hasMoreElements()) {
                String cat = (String)catKeys.nextElement();
                catList.add(cat);
            }
        }
        if (catList != null) {
            categories = new String[catList.size()];
            for (int i = 0; i < catList.size(); ++i) {
                categories[i] = (String)catList.get(i);
            }
        }
        return categories;
    }

    public String[] getPrecedenceSortedCategories() {
        if (precedenceCategory != null) {
            return precedenceCategory;
        }
        Object categories = null;
        Object catList = null;
        precedenceCategory = this.getUpdateCategories();
        if (precedenceCategory != null && precedenceCategory.length > 0) {
            for (int i = 0; i < precedenceCategory.length; ++i) {
                for (int j = 0; j < precedenceCategory.length - i - 1; ++j) {
                    CategoryProperty nextProp;
                    int nextPrecedence;
                    CategoryProperty curProp = (CategoryProperty)categoryTable.get(precedenceCategory[j]);
                    int curPrecedence = curProp.getPrecedence();
                    if (curPrecedence <= (nextPrecedence = (nextProp = (CategoryProperty)categoryTable.get(precedenceCategory[j + 1])).getPrecedence())) continue;
                    String tmp = precedenceCategory[j];
                    PatchCategory.precedenceCategory[j] = precedenceCategory[j + 1];
                    PatchCategory.precedenceCategory[j + 1] = tmp;
                }
            }
        }
        return precedenceCategory;
    }

    public String[] getDisplayPrecedenceSortedCategories() {
        if (displayCategory != null) {
            return displayCategory;
        }
        Object categories = null;
        displayCategory = this.getUpdateCategories();
        if (displayCategory != null && displayCategory.length > 0) {
            for (int i = 0; i < displayCategory.length; ++i) {
                for (int j = 0; j < displayCategory.length - i - 1; ++j) {
                    CategoryProperty nextProp;
                    int nextDisplay;
                    CategoryProperty curProp = (CategoryProperty)categoryTable.get(displayCategory[j]);
                    int curDisplay = curProp.getPrecedence();
                    if (curDisplay <= (nextDisplay = (nextProp = (CategoryProperty)categoryTable.get(displayCategory[j + 1])).getPrecedence())) continue;
                    String tmp = displayCategory[j];
                    PatchCategory.displayCategory[j] = displayCategory[j + 1];
                    PatchCategory.displayCategory[j + 1] = tmp;
                }
            }
        }
        return displayCategory;
    }

    public String getCategoryDisplayName(String cat) {
        String dispName = null;
        Object catProp = categoryTable.get(cat);
        if (catProp == null || ((CategoryProperty)catProp).getRealizations() == null) {
            catProp = categoryTable.get(categories[categories.length - 1]);
        }
        if (catProp != null) {
            dispName = ((CategoryProperty)catProp).getName();
        }
        return dispName;
    }

    public String getUpdateCategory(String reals) {
        Object toks = null;
        String[] cats = this.getPrecedenceSortedCategories();
        String category = cats[cats.length - 1];
        for (int i = 0; i < cats.length; ++i) {
            CategoryProperty catProp = (CategoryProperty)categoryTable.get(cats[i]);
            if (!catProp.isCategory(reals)) continue;
            category = catProp.getName();
        }
        return category;
    }

    public int getUpdatePrecedence(String reals) {
        String category = this.getUpdateCategory(reals);
        int precedence = -1;
        CategoryProperty catProp = (CategoryProperty)categoryTable.get(category);
        if (catProp != null) {
            precedence = catProp.getPrecedence();
        }
        return precedence;
    }

    public int getUpdateDisplayPrecedence(String reals) {
        String category = this.getUpdateCategory(reals);
        int display = -1;
        CategoryProperty catProp = (CategoryProperty)categoryTable.get(category);
        if (catProp != null) {
            display = catProp.getDisplayPrecedence();
        }
        return display;
    }

    public int getCategoryPrecedence(String category) {
        int precedence = -1;
        Object catProp = categoryTable.get(category);
        if (catProp == null) {
            catProp = categoryTable.get(categories[categories.length - 1]);
        }
        if (catProp != null) {
            precedence = ((CategoryProperty)catProp).getPrecedence();
        }
        return precedence;
    }

    public int getCategoryDisplayPrecedence(String category) {
        int dispPrecedence = -1;
        Object catProp = categoryTable.get(category);
        if (catProp == null) {
            catProp = categoryTable.get(categories[categories.length - 1]);
        }
        if (catProp != null) {
            dispPrecedence = ((CategoryProperty)catProp).getDisplayPrecedence();
        }
        return dispPrecedence;
    }

    public String[] getCategoryRealizations(String category) {
        String[] reals = null;
        Object catProp = categoryTable.get(category);
        if (catProp == null) {
            catProp = categoryTable.get(categories[categories.length - 1]);
        }
        if (catProp != null) {
            reals = ((CategoryProperty)catProp).getRealizations();
        }
        return reals;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class CategoryProperty {
        private String name = null;
        private String[] realizations;
        private int precedence = -1;
        private int displayPrecedence = -1;

        public CategoryProperty(String name, String reals, int prec, int disp) {
            this.name = name;
            this.realizations = this.processRealIDs(reals);
            this.precedence = prec;
            this.displayPrecedence = disp;
        }

        private String[] processRealIDs(String reals) {
            String[] toks = reals.split(" ");
            for (int i = 0; i < toks.length; ++i) {
                toks[i] = toks[i].trim();
            }
            return toks;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String[] getRealizations() {
            return this.realizations;
        }

        public void setRealizations(String reals) {
            this.realizations = this.processRealIDs(reals);
        }

        public int getPrecedence() {
            return this.precedence;
        }

        public void setPrecedence(int prec) {
            this.precedence = prec;
        }

        public int getDisplayPrecedence() {
            return this.displayPrecedence;
        }

        public void setDisplayPrecedence(int disp) {
            this.displayPrecedence = disp;
        }

        public boolean isCategory(String reals) {
            String[] toks = null;
            String[] realIDs = this.getRealizations();
            boolean isCategory = false;
            if (reals != null && reals.length() > 0) {
                toks = reals.split(" ");
                for (int i = 0; i < toks.length; ++i) {
                    for (int j = 0; j < realIDs.length; ++j) {
                        if (!toks[i].equals(realIDs[j])) continue;
                        isCategory = true;
                    }
                }
            }
            return isCategory;
        }
    }
}

