/*
 * Decompiled with CFR 0.152.
 */
package com.sun.swup.client.engine.solaris;

import com.sun.cns.authentication.CMDExecutionException;
import com.sun.cns.authentication.NotAuthenticatedException;
import com.sun.swup.client.common.I18NHelper;
import com.sun.swup.client.common.UMData;
import com.sun.swup.client.engine.solaris.CollectionFileException;
import com.sun.swup.client.wrapper.PatchProWrapper;
import java.util.ArrayList;
import java.util.Hashtable;

public class PatchCollection {
    private static String[] collections = null;
    private static Hashtable collectionTable = null;
    private static PatchProWrapper ppro = PatchProWrapper.getInstance();
    private static PatchCollection collectionObj = null;
    public static I18NHelper I18N = new I18NHelper(class$com$sun$swup$client$engine$solaris$PatchCollection == null ? (class$com$sun$swup$client$engine$solaris$PatchCollection = PatchCollection.class$("com.sun.swup.client.engine.solaris.PatchCollection")) : class$com$sun$swup$client$engine$solaris$PatchCollection, "resources/strings/warning");
    public static final int AUTH_CMD_EXCEPTION = 1;
    public static final int COLLECTION_ZERO_LENGTH = 2;
    public static final int CANT_PARSE_COLLECTION = 3;
    static /* synthetic */ Class class$com$sun$swup$client$engine$solaris$PatchCollection;

    public PatchCollection() throws CMDExecutionException, NotAuthenticatedException, CollectionFileException {
        this.processCollections();
    }

    public static PatchCollection getInstance() throws CMDExecutionException, NotAuthenticatedException, CollectionFileException {
        if (collectionObj == null) {
            collectionObj = new PatchCollection();
        }
        return collectionObj;
    }

    public static void invalidatePatchCollections() {
        collectionObj = null;
    }

    public static boolean isCollectionObjInit() {
        return collectionObj != null;
    }

    private void processCollections() throws CMDExecutionException, NotAuthenticatedException, CollectionFileException {
        int i;
        String line = null;
        ArrayList<String> names = null;
        String output = null;
        CollectionFileException exception = null;
        try {
            output = ppro.getCollectionFile(null);
        }
        catch (CMDExecutionException ce) {
            exception = new CollectionFileException(ce.getErrorMessage(), 1);
            collectionObj = null;
            throw exception;
        }
        if (output == null || output.length() == 0) {
            exception = new CollectionFileException(I18N.getString("collection-zero-length"), 2);
            collectionObj = null;
            throw exception;
        }
        String[] lines = output.split("\n");
        for (i = 0; i < lines.length; ++i) {
            line = lines[i];
            if (line == null || line.startsWith("#") || line.trim().length() == 0 || line.indexOf(".name") < 0 || line.indexOf("=") < 0) continue;
            line = line.trim();
            String key = line.substring(0, line.indexOf("="));
            String colName = key.substring(0, key.indexOf(".name"));
            String value = line.substring(line.indexOf("=") + 1);
            if (value == null || value.trim().length() == 0) continue;
            String colDescription = value.trim();
            if (names == null) {
                names = new ArrayList<String>();
                collectionTable = new Hashtable();
            }
            names.add(colName);
            collectionTable.put(colName, colDescription);
        }
        if (names != null) {
            collections = new String[names.size()];
            for (i = 0; i < names.size(); ++i) {
                PatchCollection.collections[i] = (String)names.get(i);
            }
        }
        if (collections == null || collections.length == 0) {
            exception = new CollectionFileException(I18N.getString("collection-content-error"), 3);
            throw exception;
        }
    }

    public String[] getCollectionNames() throws CMDExecutionException, NotAuthenticatedException {
        if (collections != null && collections.length > 0) {
            String defaultSet = ppro.get("patchpro.patchset");
            if (defaultSet != null && defaultSet.trim().length() > 0) {
                if (collectionTable.containsKey(defaultSet) && !defaultSet.equals(collections[0])) {
                    String tmp = collections[0];
                    PatchCollection.collections[0] = defaultSet;
                    for (int i = 1; i < collections.length; ++i) {
                        String tmp2 = collections[i];
                        PatchCollection.collections[i] = tmp;
                        if (!tmp2.equals(defaultSet)) {
                            tmp = tmp2;
                            continue;
                        }
                        break;
                    }
                } else if (!collectionTable.containsKey(defaultSet)) {
                    this.setPatchSet(collections[0]);
                }
            }
            UMData.setCurrentPatchset((String)collections[0]);
        }
        return collections;
    }

    public void setPatchSet(String name) throws CMDExecutionException, NotAuthenticatedException {
        ppro.set("patchpro.patchset", name);
        UMData.setCurrentPatchset((String)name);
    }

    public String[] getCollectionDescriptions() throws CMDExecutionException, NotAuthenticatedException {
        if (this.getCollectionNames() == null || collectionTable == null) {
            return null;
        }
        String[] descriptions = new String[collections.length];
        for (int i = 0; i < collections.length || i < collectionTable.size(); ++i) {
            descriptions[i] = (String)collectionTable.get(collections[i]);
        }
        return descriptions;
    }

    public String getDescription(String collection) {
        if (collection == null || collectionTable == null) {
            return null;
        }
        return (String)collectionTable.get(collection);
    }

    public static Hashtable getCollectionTable() {
        return collectionTable;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

