/*
 * Decompiled with CFR 0.152.
 */
package com.sun.swup.client.sample;

import com.sun.cns.authentication.CMDExecutionException;
import com.sun.cns.authentication.NotAuthenticatedException;
import com.sun.swup.client.interfaces.Installer;
import com.sun.swup.client.interfaces.InstallerMessenger;
import com.sun.swup.client.interfaces.Update;
import java.util.Timer;
import java.util.TimerTask;

public class InstallerImpl
implements Installer {
    private static final int SECONDS_PER_UPDATE = 2;
    private InstallerMessenger installerMessenger;
    private Update[] aUpdate;
    private int iCounter;
    private Timer timer;
    private TimerTask timerTask;
    private boolean bRestartRequired;

    public InstallerMessenger getMessenger() {
        if (this.installerMessenger == null) {
            this.installerMessenger = new InstallerMessenger();
        }
        return this.installerMessenger;
    }

    public void beginInstall(Update[] aUpdate) throws CMDExecutionException, NotAuthenticatedException {
        this.aUpdate = aUpdate;
        this.startTimer();
    }

    public void cancelInstall() {
        this.timer.cancel();
        this.timer = null;
    }

    public void setRestartRequired(boolean bRestartRequired) {
        this.bRestartRequired = bRestartRequired;
    }

    public boolean isRestartRequired() {
        return this.bRestartRequired;
    }

    private void startTimer() {
        this.iCounter = 0;
        this.timer = new Timer();
        this.timerTask = new InstallerTimerTask();
        this.timer.schedule(this.timerTask, 0L, 2000L);
    }

    private int calculateKilobytesRemaining() {
        int iKilobytes = 0;
        for (int i = this.iCounter; i < this.aUpdate.length; ++i) {
            Update update = this.aUpdate[i];
            iKilobytes += update.getSize().intValue();
        }
        return iKilobytes;
    }

    private int calculateSecondsRemaining() {
        int iSeconds = 0;
        for (int i = this.iCounter; i < this.aUpdate.length; ++i) {
            iSeconds += 2;
        }
        return iSeconds;
    }

    class InstallerTimerTask
    extends TimerTask {
        InstallerTimerTask() {
        }

        public void run() {
            if (InstallerImpl.this.iCounter >= InstallerImpl.this.aUpdate.length) {
                InstallerImpl.this.setRestartRequired(true);
                InstallerImpl.this.getMessenger().installFinished();
                this.cancel();
            } else {
                Update update = InstallerImpl.this.aUpdate[InstallerImpl.this.iCounter];
                InstallerImpl.this.getMessenger().setUpdateName(update.getName());
                InstallerImpl.this.getMessenger().setUpdateNumber(InstallerImpl.this.iCounter + 1);
                InstallerImpl.this.getMessenger().setUpdateTotal(InstallerImpl.this.aUpdate.length);
                InstallerImpl.this.getMessenger().setKilobytesRemaining(InstallerImpl.this.calculateKilobytesRemaining());
                InstallerImpl.this.getMessenger().setSecondsRemaining(InstallerImpl.this.calculateSecondsRemaining());
            }
            InstallerImpl.this.iCounter++;
        }
    }
}

