/*
 * Decompiled with CFR 0.152.
 */
package com.sun.swup.client.ui;

import com.sun.cns.authentication.NotAuthenticatedException;
import com.sun.swup.client.common.UMData;
import com.sun.swup.client.interfaces.Update;
import com.sun.swup.client.ui.Application;
import com.sun.swup.client.ui.AuthenticationManager;
import com.sun.swup.client.ui.GenericEditorPane;
import com.sun.swup.client.ui.UpdateFrame;
import com.sun.swup.client.ui.UpdateUtility;
import com.sun.swup.client.ui.foundation.Utility;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

class AvailableEditorPane
extends GenericEditorPane {
    private Update update;

    AvailableEditorPane() {
        this.setEditable(false);
        this.setFont(Utility.getReducedFont(this, "small-font-reduction"));
        HTMLEditorKit htmlEditorKit = new HTMLEditorKit();
        this.modifyStyleSheet(htmlEditorKit.getStyleSheet());
        this.setEditorKit(htmlEditorKit);
        this.addHyperlinkListener(new UpdatesHyperlinkListener());
        this.populate();
    }

    void setUpdate(Update update) {
        this.update = update;
        this.populate();
    }

    private void modifyStyleSheet(StyleSheet styleSheet) {
        Font font = this.getFont();
        String sFontFamily = font.getFamily();
        int iFontSize = font.getSize();
        styleSheet.addRule("body {font-family:" + sFontFamily + ";font-size:" + iFontSize + "pt;}");
    }

    private void populate() {
        if (this.update == null) {
            this.setText("");
        } else {
            GetReadMeAction action = new GetReadMeAction();
            ActionEvent e = new ActionEvent(this, 1001, null);
            action.actionPerformed(e);
        }
    }

    private void populate(String sReadMe) {
        StringBuffer sb = new StringBuffer();
        sb.append("<html>");
        sb.append("<body>");
        sb.append("<b>");
        sb.append(this.update.getName());
        sb.append("</b>");
        sb.append("<br>");
        sb.append(UpdateFrame.I18N.getString("available-detail-released"));
        if (this.update.getAvailableDate() != null) {
            sb.append(UpdateFrame.formatDateString(this.update.getAvailableDate()));
        }
        sb.append("<br>");
        sb.append("<br>");
        sb.append(this.update.getDescription());
        sb.append("<br>");
        Object[] aObject = new Object[]{UpdateUtility.getUpdateSizeDisplayString(this.update.getSize())};
        sb.append(UpdateFrame.I18N.format("available-detail-install-file-size", aObject));
        sb.append("<br>");
        sb.append("<br>");
        if (sReadMe != null) {
            sReadMe = sReadMe.replaceAll("\n", "<br>");
            sb.append(sReadMe);
        }
        sb.append("</body>");
        sb.append("</html>");
        this.setText(sb.toString());
        this.setCaretPosition(0);
    }

    class UpdatesHyperlinkListener
    implements HyperlinkListener {
        UpdatesHyperlinkListener() {
        }

        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                Utility.openURL(e.getURL().toString());
            }
        }
    }

    class GetReadMeAction
    extends AbstractAction {
        GetReadMeAction() {
        }

        public void actionPerformed(ActionEvent e) {
            Application.getInstance().getUpdateFrame().setCursor(Cursor.getPredefinedCursor(3));
            try {
                String sReadMe = AvailableEditorPane.this.update.getUpdateReadme();
                AvailableEditorPane.this.populate(sReadMe);
            }
            catch (NotAuthenticatedException ex) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ GetReadMeAction this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        AuthenticationManager.getInstance().setAction(null);
                        boolean bSuccess = AuthenticationManager.getInstance().authenticate();
                        if (bSuccess) {
                            if (UMData.getDebug()) {
                                System.out.println("auth for read me succeeded");
                            }
                            try {
                                String sReadMe = AvailableEditorPane.access$000(GetReadMeAction.access$200(this.this$1)).getUpdateReadme();
                                AvailableEditorPane.access$100(GetReadMeAction.access$200(this.this$1), sReadMe);
                            }
                            catch (Throwable throwable) {
                                try {
                                    AvailableEditorPane.access$100(GetReadMeAction.access$200(this.this$1), null);
                                }
                                catch (Throwable tr) {
                                    Application.getInstance().getUpdateFrame().showWarningDialog(tr, null);
                                }
                            }
                        } else {
                            if (UMData.getDebug()) {
                                System.out.println("auth for read me cancelled");
                            }
                            AvailableEditorPane.access$100(GetReadMeAction.access$200(this.this$1), null);
                        }
                    }
                });
            }
            catch (Throwable throwable) {
                Application.getInstance().getUpdateFrame().showWarningDialog(throwable, null);
            }
            Application.getInstance().getUpdateFrame().setCursor(Cursor.getDefaultCursor());
        }

        static /* synthetic */ AvailableEditorPane access$200(GetReadMeAction x0) {
            return x0.AvailableEditorPane.this;
        }
    }
}

