/*
 * Decompiled with CFR 0.152.
 */
package com.sun.swup.client.ui;

import com.sun.swup.client.interfaces.Update;
import com.sun.swup.client.ui.Application;
import com.sun.swup.client.ui.DependenciesDialog;
import com.sun.swup.client.ui.Dependency;
import com.sun.swup.client.ui.GenericEditorPane;
import com.sun.swup.client.ui.InstalledTable;
import com.sun.swup.client.ui.InstalledTableModel;
import java.awt.Font;
import java.lang.ref.WeakReference;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

class DependenciesEditorPane
extends GenericEditorPane {
    private WeakReference dependenciesDialog;

    DependenciesEditorPane(DependenciesDialog dependenciesDialog) {
        this.setDependenciesDialog(dependenciesDialog);
        this.setEditable(false);
        HTMLEditorKit htmlEditorKit = new HTMLEditorKit();
        this.modifyStyleSheet(htmlEditorKit.getStyleSheet());
        this.setEditorKit(htmlEditorKit);
    }

    void populate() {
        StringBuffer sb = new StringBuffer();
        sb.append("<html>");
        sb.append("<body>");
        Dependency[] aDependency = this.getDependenciesDialog().getDependenciesPanel().getDependencies();
        try {
            sb.append("<table width=\"100%\">");
            for (int i = 0; i < aDependency.length; ++i) {
                Dependency dependency = aDependency[i];
                sb.append("<tr>");
                sb.append("<td width=\"10%\">");
                sb.append(dependency.getUpdateName());
                sb.append("</td>");
                sb.append("<td>");
                sb.append(dependency.getUpdateDesc());
                sb.append("</td>");
                sb.append("</tr>");
                sb.append("<tr>");
                sb.append("<td>");
                sb.append("</td>");
                sb.append("<td colspan=\"2\">");
                sb.append("<table width=\"100%\">");
                sb.append("<td colspan=\"2\"><b>");
                sb.append(DependenciesDialog.I18N.getString("additional-updates-required"));
                sb.append("</b></td>");
                for (int k = 0; k < dependency.getDependantsCount(); ++k) {
                    sb.append("<tr>");
                    sb.append("<td width=\"10%\">");
                    sb.append(dependency.getDependant(k).getName());
                    sb.append("</td>");
                    sb.append("<td>");
                    sb.append(dependency.getDependant(k).getDescription());
                    sb.append("</td>");
                    sb.append("</tr>");
                }
                sb.append("</table>");
                sb.append("</td>");
                sb.append("</tr>");
            }
        }
        catch (Exception e) {
            System.err.println("error populating DependenciesEditorPane...");
        }
        if (Application.getInstance().getUpdateFrame().getDelegate().getDependencyType() == 2) {
            InstalledTable iTable = Application.getInstance().getUpdateFrame().getInstalledPanel().getTable();
            InstalledTableModel iTableModel = (InstalledTableModel)iTable.getModel();
            Update[] checkedUpdates = iTableModel.getCheckedUpdates();
            for (int i = 0; i < checkedUpdates.length; ++i) {
                boolean inDepDialog = false;
                for (int j = 0; j < aDependency.length; ++j) {
                    if (checkedUpdates[i].getName() != aDependency[j].getUpdateName()) continue;
                    inDepDialog = true;
                    break;
                }
                if (inDepDialog) continue;
                sb.append("<tr>");
                sb.append("<td width=\"10%\">");
                sb.append(checkedUpdates[i].getName());
                sb.append("</td>");
                sb.append("<td>");
                sb.append(checkedUpdates[i].getDescription());
                sb.append("</td>");
                sb.append("</tr>");
            }
        }
        sb.append("<table>");
        sb.append("</body>");
        sb.append("</html>");
        this.setText(sb.toString());
        this.setCaretPosition(0);
    }

    private void modifyStyleSheet(StyleSheet styleSheet) {
        Font font = this.getFont();
        String sFontFamily = font.getFamily();
        int iFontSize = font.getSize();
        styleSheet.addRule("body {font-family:" + sFontFamily + ";font-size:" + iFontSize + "pt;}");
    }

    private void setDependenciesDialog(DependenciesDialog dependenciesDialog) {
        this.dependenciesDialog = new WeakReference<DependenciesDialog>(dependenciesDialog);
    }

    private DependenciesDialog getDependenciesDialog() {
        return (DependenciesDialog)this.dependenciesDialog.get();
    }
}

