/*
 * Decompiled with CFR 0.152.
 */
package com.sun.swup.client.ui;

import com.sun.swup.client.common.environment.Environment;
import com.sun.swup.client.ui.Application;
import com.sun.swup.client.ui.DependenciesDialog;
import com.sun.swup.client.ui.DependenciesEditorPane;
import com.sun.swup.client.ui.Dependency;
import com.sun.swup.client.ui.UpdateDelegate;
import com.sun.swup.client.ui.foundation.Utility;
import com.sun.swup.client.ui.foundation.swing.GenericActionSet;
import com.sun.swup.client.ui.foundation.swing.InsetPanel;
import com.sun.swup.client.ui.foundation.swing.MessageTextArea;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.lang.ref.WeakReference;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;

class DependenciesPanel
extends InsetPanel {
    private WeakReference dependenciesDialog;
    private JLabel noteLabel;
    private JLabel confirmLabel;
    private MessageTextArea messageTextArea;
    private MessageTextArea uninstallMessageTextArea;
    private DependenciesEditorPane dependenciesEditorPane;
    private JScrollPane dependenciesScrollPane;
    private JButton okButton;
    private JButton cancelButton;
    private Dependency[] aDependency;
    private int dependencyType;
    private int dependenciesCount;

    DependenciesPanel(DependenciesDialog dependenciesDialog) {
        this.setDependenciesDialog(dependenciesDialog);
        UpdateDelegate updateDelegate = Application.getInstance().getUpdateFrame().getDelegate();
        this.dependencyType = updateDelegate.getDependencyType();
        this.dependenciesCount = dependenciesDialog.getDependenciesCount();
        this.createComponents();
        this.createLayout();
    }

    DependenciesEditorPane getEditorPane() {
        return this.dependenciesEditorPane;
    }

    void setDependencies(Dependency[] aDependency) {
        this.aDependency = aDependency;
        Object[] aObject = new Object[]{new Integer(aDependency.length)};
        if (this.dependencyType == 1) {
            this.messageTextArea.setText(DependenciesDialog.I18N.format("note-install-message", aObject));
        } else if (this.dependenciesCount > 0) {
            this.messageTextArea.setText(DependenciesDialog.I18N.format("note-uninstall-message", aObject));
        }
    }

    Dependency[] getDependencies() {
        return this.aDependency;
    }

    private void createComponents() {
        String sString;
        GenericActionSet actionSet = this.getDependenciesDialog().getActionSet();
        Object[] aObject = new Object[]{new Integer(1000)};
        if (this.dependencyType == 2) {
            ImageIcon confirmIcon = Environment.getImageIcon((String)"help_medium.gif");
            this.confirmLabel = new JLabel(DependenciesDialog.I18N.getString("confirm-uninstall-message"), confirmIcon, 2);
            String uninstallMessage = DependenciesDialog.I18N.getString("uninstall-message");
            int iReferenceWidth = this.getDependenciesDialog().getSize().width;
            this.uninstallMessageTextArea = new MessageTextArea(uninstallMessage, iReferenceWidth);
            this.uninstallMessageTextArea.setFont(Utility.getReducedFont(this, "small-font-reduction"));
            sString = DependenciesDialog.I18N.format("note-uninstall-message", aObject);
        } else {
            sString = DependenciesDialog.I18N.format("note-install-message", aObject);
        }
        if (this.dependenciesCount > 0) {
            ImageIcon warnIcon = Environment.getImageIcon((String)"warning_medium.gif");
            this.noteLabel = new JLabel(DependenciesDialog.I18N.getString("note"), warnIcon, 2);
            int iReferenceWidth = this.getDependenciesDialog().getSize().width;
            this.messageTextArea = new MessageTextArea(sString, iReferenceWidth);
            this.messageTextArea.setFont(Utility.getReducedFont(this, "small-font-reduction"));
        }
        this.dependenciesEditorPane = new DependenciesEditorPane(this.getDependenciesDialog());
        this.dependenciesScrollPane = this.dependenciesEditorPane.getScrollPane();
        this.okButton = new JButton(actionSet.getAction("ok"));
        this.okButton.setMnemonic(DependenciesDialog.I18N.getString("continue.mnemonic").charAt(0));
        this.okButton.setDefaultCapable(true);
        this.getDependenciesDialog().getRootPane().setDefaultButton(this.okButton);
        this.cancelButton = new JButton(actionSet.getAction("cancel"));
        this.cancelButton.setMnemonic(DependenciesDialog.I18N.getString("cancel.mnemonic").charAt(0));
    }

    private void createLayout() {
        InsetPanel headerPanel = new InsetPanel(new Insets(6, 6, 6, 6));
        headerPanel.setLayout(new BoxLayout(headerPanel, 1));
        headerPanel.setAlignmentY(0.0f);
        if (this.dependencyType == 2) {
            InsetPanel confirmPanel = new InsetPanel(new Insets(6, 6, 6, 6));
            confirmPanel.setLayout(new BorderLayout(0, 4));
            confirmPanel.add((Component)this.confirmLabel, "North");
            confirmPanel.add((Component)this.uninstallMessageTextArea, "Center");
            headerPanel.add(confirmPanel);
        }
        if (this.dependenciesCount > 0) {
            InsetPanel notePanel = new InsetPanel(new Insets(6, 6, 6, 6));
            notePanel.setLayout(new BorderLayout(0, 4));
            notePanel.add((Component)this.noteLabel, "North");
            notePanel.add((Component)this.messageTextArea, "Center");
            headerPanel.add(notePanel);
        }
        InsetPanel footerPanel = new InsetPanel(new Insets(8, 0, 0, 0));
        footerPanel.setLayout(new BoxLayout(footerPanel, 0));
        footerPanel.add(Box.createHorizontalGlue());
        footerPanel.add(this.okButton);
        footerPanel.add(Box.createRigidArea(Environment.getDimension((String)"inter-button")));
        footerPanel.add(this.cancelButton);
        this.setInsets(new Insets(13, 13, 13, 13));
        this.setLayout(new BorderLayout());
        this.add((Component)headerPanel, "North");
        this.add((Component)this.dependenciesScrollPane, "Center");
        this.add((Component)footerPanel, "South");
    }

    private void setDependenciesDialog(DependenciesDialog dependenciesDialog) {
        this.dependenciesDialog = new WeakReference<DependenciesDialog>(dependenciesDialog);
    }

    private DependenciesDialog getDependenciesDialog() {
        return (DependenciesDialog)this.dependenciesDialog.get();
    }
}

