/*
 * Decompiled with CFR 0.152.
 */
package com.sun.swup.client.ui;

import com.sun.swup.client.common.environment.Environment;
import com.sun.swup.client.ui.GatherDialog;
import com.sun.swup.client.ui.foundation.Utility;
import com.sun.swup.client.ui.foundation.swing.InsetPanel;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.WeakReference;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.Timer;

class GatherPanel
extends InsetPanel
implements ActionListener {
    private WeakReference gatherDialog;
    private JLabel majorLabel;
    private JProgressBar progressBar;
    private JLabel footerLabel;
    private JButton cancelButton;
    private InsetPanel footerPanel;
    private Timer timer = new Timer(100, this);
    private int iStep = 0;

    GatherPanel(GatherDialog gatherDialog) {
        this.setGatherDialog(gatherDialog);
        this.createComponents();
        this.createLayout();
        this.setMajorLabel("  ");
        this.setProgressValue(0);
        this.setFooterLabel("  ");
    }

    JProgressBar getProgressBar() {
        return this.progressBar;
    }

    AbstractButton getCancelButton() {
        return this.cancelButton;
    }

    void setMessage(String sMessage) {
    }

    private void createComponents() {
        this.majorLabel = new JLabel();
        this.footerPanel = new InsetPanel();
        this.progressBar = new JProgressBar();
        this.footerLabel = new JLabel();
        this.footerLabel.setFont(Utility.getReducedFont(this.footerLabel, "small-font-reduction"));
        this.cancelButton = new JButton(this.getGatherDialog().getActionSet().getAction("cancel"));
    }

    private void createLayout() {
        this.setInsets(Environment.getInsets((String)"frame"));
        this.setLayout(new BoxLayout(this, 1));
        this.majorLabel.setHorizontalAlignment(2);
        this.majorLabel.setAlignmentX(0.0f);
        this.add(this.majorLabel);
        this.add(Box.createRigidArea(new Dimension(5, 5)));
        this.progressBar.setAlignmentX(0.0f);
        this.add(this.progressBar);
        this.add(Box.createRigidArea(new Dimension(5, 5)));
        this.footerPanel.setLayout(new BoxLayout(this.footerPanel, 0));
        this.footerPanel.setAlignmentX(0.0f);
        this.footerPanel.add(this.footerLabel);
        this.footerPanel.add(Box.createHorizontalGlue());
        this.footerPanel.add(this.cancelButton);
        this.add(this.footerPanel);
    }

    public void setMajorLabel(String text) {
        this.majorLabel.setText(text);
    }

    public void setFooterLabel(String text) {
        this.footerLabel.setText(text);
    }

    public void setProgressValue(int percent) {
        this.progressBar.setValue(percent);
    }

    private void setGatherDialog(GatherDialog gatherDialog) {
        this.gatherDialog = new WeakReference<GatherDialog>(gatherDialog);
    }

    private GatherDialog getGatherDialog() {
        return (GatherDialog)this.gatherDialog.get();
    }

    void setProgressing(boolean bProgressing) {
        if (bProgressing) {
            this.iStep = 0;
            this.timer.start();
        } else {
            this.timer.stop();
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof Timer) {
            Timer timer = (Timer)e.getSource();
            ++this.iStep;
            if (this.iStep == 90) {
                timer.stop();
            }
            this.getProgressBar().setValue(this.iStep);
        }
    }
}

