/*
 * Decompiled with CFR 0.152.
 */
package com.sun.swup.client.ui;

import com.sun.swup.client.interfaces.Update;
import com.sun.swup.client.ui.HistoryEditorPane;
import com.sun.swup.client.ui.HistoryTable;
import com.sun.swup.client.ui.HistoryTableModel;
import com.sun.swup.client.ui.SymbolPanel;
import com.sun.swup.client.ui.UpdateFrame;
import com.sun.swup.client.ui.foundation.Utility;
import com.sun.swup.client.ui.foundation.swing.GenericActionSet;
import com.sun.swup.client.ui.foundation.swing.InsetPanel;
import com.sun.swup.client.ui.foundation.swing.OrnamentTableHeader;
import com.sun.swup.client.ui.foundation.swing.TabPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.lang.ref.WeakReference;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class HistoryPanel
extends TabPanel {
    private WeakReference updateFrame;
    private JLabel messageLabel;
    private SymbolPanel symbolPanel;
    private HistorySplitPane historySplitPane;
    private HistoryTable historyTable;
    private HistoryEditorPane historyEditorPane;
    private JButton manageButton;

    HistoryPanel(UpdateFrame updateFrame) {
        this.setUpdateFrame(updateFrame);
        this.createComponents();
        this.createLayout();
    }

    HistoryTable getTable() {
        return this.historyTable;
    }

    HistoryEditorPane getEditorPane() {
        return this.historyEditorPane;
    }

    private void createComponents() {
        this.messageLabel = new JLabel(UpdateFrame.I18N.getString("history-recent-update-activity"));
        this.symbolPanel = new SymbolPanel();
        this.symbolPanel.addLabel("history-installed", "installed.png");
        this.symbolPanel.addLabel("history-partial-install", "partial-install.png");
        this.symbolPanel.addLabel("history-install-failed", "install-failed.png");
        this.symbolPanel.addLabel("history-uninstalled", "uninstalled.png");
        this.symbolPanel.addLabel("history-downloaded", "downloaded.png");
        this.historySplitPane = new HistorySplitPane();
        GenericActionSet actionSet = this.getUpdateFrame().getActionSet();
        this.manageButton = Utility.createLinkStyleButton(actionSet.getAction("manage-at-portal"));
    }

    private void createLayout() {
        this.messageLabel.setHorizontalAlignment(2);
        this.messageLabel.setAlignmentX(0.0f);
        InsetPanel headerPanel = new InsetPanel(new Insets(6, 6, 6, 6));
        headerPanel.setLayout(new BoxLayout(headerPanel, 1));
        headerPanel.add(this.messageLabel);
        headerPanel.add(Box.createRigidArea(new Dimension(1, 10)));
        headerPanel.add(this.symbolPanel);
        InsetPanel footerPanel = new InsetPanel(new Insets(6, 6, 6, 6));
        footerPanel.setLayout(new BoxLayout(footerPanel, 0));
        footerPanel.add(Box.createHorizontalGlue());
        footerPanel.add(this.manageButton);
        this.setLayout(new BorderLayout());
        this.add((Component)headerPanel, "North");
        this.add((Component)this.historySplitPane, "Center");
        this.add((Component)footerPanel, "South");
    }

    private void setUpdateFrame(UpdateFrame updateFrame) {
        this.updateFrame = new WeakReference<UpdateFrame>(updateFrame);
    }

    private UpdateFrame getUpdateFrame() {
        return (UpdateFrame)this.updateFrame.get();
    }

    class HistoryTableListSelectionListener
    implements ListSelectionListener {
        HistoryTableListSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            ListSelectionModel selectionModel = (ListSelectionModel)e.getSource();
            HistoryTable table = HistoryPanel.this.getTable();
            HistoryTableModel model = (HistoryTableModel)table.getModel();
            int iRow = table.getSelectedRow();
            int[] aiSelectedRows = table.getSelectedRows();
            if (aiSelectedRows.length == 1 && iRow >= 0) {
                Update update = model.getUpdateAt(iRow);
                HistoryPanel.this.getEditorPane().setUpdate(update);
            } else {
                HistoryPanel.this.getEditorPane().setUpdate(null);
            }
        }
    }

    class HistorySplitPane
    extends JSplitPane {
        HistorySplitPane() {
            super(0);
            HistoryPanel.this.historyTable = new HistoryTable(HistoryPanel.this.getUpdateFrame());
            ListSelectionModel selectionModel = HistoryPanel.this.historyTable.getSelectionModel();
            selectionModel.addListSelectionListener(new HistoryTableListSelectionListener());
            JScrollPane tableScrollPane = HistoryPanel.this.historyTable.getScrollPane();
            tableScrollPane.setBorder(BorderFactory.createEmptyBorder());
            tableScrollPane.setCorner("UPPER_RIGHT_CORNER", new OrnamentTableHeader());
            HistoryPanel.this.historyEditorPane = new HistoryEditorPane();
            JScrollPane editorScrollPane = HistoryPanel.this.historyEditorPane.getScrollPane();
            editorScrollPane.setBorder(BorderFactory.createEmptyBorder());
            this.setContinuousLayout(true);
            this.setTopComponent(tableScrollPane);
            this.setBottomComponent(editorScrollPane);
            this.setResizeWeight(0.75);
            this.setDividerLocation(300);
        }
    }
}

