/*
 * Decompiled with CFR 0.152.
 */
package com.sun.swup.client.ui;

import com.sun.cns.authentication.CMDExecutionException;
import com.sun.cns.authentication.NotAuthenticatedException;
import com.sun.swup.client.common.I18NHelper;
import com.sun.swup.client.common.UMData;
import com.sun.swup.client.common.environment.Environment;
import com.sun.swup.client.interfaces.Installer;
import com.sun.swup.client.interfaces.Update;
import com.sun.swup.client.ui.Application;
import com.sun.swup.client.ui.AuthenticationManager;
import com.sun.swup.client.ui.AvailableTable;
import com.sun.swup.client.ui.AvailableTableModel;
import com.sun.swup.client.ui.DataController;
import com.sun.swup.client.ui.Dependency;
import com.sun.swup.client.ui.InstallPanel;
import com.sun.swup.client.ui.InstalledTableModel;
import com.sun.swup.client.ui.UpdateDelegate;
import com.sun.swup.client.ui.UpdateFrame;
import com.sun.swup.client.ui.foundation.Worker;
import com.sun.swup.client.ui.foundation.WorkerEvent;
import com.sun.swup.client.ui.foundation.WorkerListener;
import com.sun.swup.client.ui.foundation.swing.GenericAction;
import com.sun.swup.client.ui.foundation.swing.GenericActionSet;
import com.sun.swup.client.ui.foundation.swing.GenericDialog;
import com.sun.swup.client.ui.foundation.swing.SortedTableHeader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;

class InstallDialog
extends GenericDialog {
    static I18NHelper I18N = new I18NHelper(class$com$sun$swup$client$ui$InstallDialog == null ? (class$com$sun$swup$client$ui$InstallDialog = InstallDialog.class$("com.sun.swup.client.ui.InstallDialog")) : class$com$sun$swup$client$ui$InstallDialog, "resources/strings/install");
    private InstallPanel installPanel;
    private InstallWorker worker;
    private Update[] aUpdate;
    private boolean bAuthenticationNeeded;
    static /* synthetic */ Class class$com$sun$swup$client$ui$InstallDialog;

    InstallDialog(Frame owner) {
        super(owner);
        this.setTitle(I18N.getString("title"));
        this.getAccessibleContext().setAccessibleName(I18N.getString("title"));
        this.getAccessibleContext().setAccessibleDescription(I18N.getString("install-dialog-description"));
        this.setResizable(false);
        this.setModal(true);
        this.setActionSet(new GenericActionSet());
        this.getActionSet().putAction("cancel", new CancelAction());
        this.getActionSet().getAction("cancel").setEnabled(true);
        this.createComponents();
        this.createLayout();
        this.pack();
    }

    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        d.width = Environment.getInteger((String)"preferred-dialog-width");
        return d;
    }

    boolean isAuthenticationNeeded() {
        return this.bAuthenticationNeeded;
    }

    void beginInstall() {
        BeginInstallAction action = new BeginInstallAction();
        ActionEvent e = new ActionEvent(this, 1001, null);
        action.actionPerformed(e);
    }

    InstallPanel getInstallPanel() {
        return this.installPanel;
    }

    void refreshAvailableUpdates() {
        AvailableTable table = Application.getInstance().getUpdateFrame().getAvailablePanel().getTable();
        AvailableTableModel model = (AvailableTableModel)table.getModel();
        Update[] checkedUpdates = model.getCheckedUpdates();
        UpdateDelegate ud = Application.getInstance().getUpdateFrame().getDelegate();
        ud.setInstallSummaryUpdates(checkedUpdates);
        ArrayList<Update> appliedUpdateList = new ArrayList<Update>();
        for (int i = 0; i < checkedUpdates.length; ++i) {
            int status = checkedUpdates[i].getUpdateOperateStatus();
            if (UMData.getDebug()) {
                System.out.println("Patch id:" + checkedUpdates[i].getName() + " ,Status: " + status);
            }
            if (status != 0) continue;
            appliedUpdateList.add(checkedUpdates[i]);
        }
        Update[] appliedUpdates = null;
        if (appliedUpdateList.size() > 0) {
            appliedUpdates = new Update[appliedUpdateList.size()];
            for (int j = 0; j < appliedUpdateList.size(); ++j) {
                appliedUpdates[j] = (Update)appliedUpdateList.get(j);
            }
            table.removeAppliedUpdates(appliedUpdates);
            this.removeInstalledDependency(appliedUpdates);
            model.uncheckAll();
        }
        if (appliedUpdates != null) {
            for (int k = 0; k < appliedUpdates.length; ++k) {
                appliedUpdates[k].resetUpdateStatus();
            }
        }
        model.uncheckAll();
    }

    private void removeInstalledDependency(Update[] appliedUpdates) {
        AvailableTable table = Application.getInstance().getUpdateFrame().getAvailablePanel().getTable();
        AvailableTableModel model = (AvailableTableModel)table.getModel();
        Update[] availableUpdates = model.getUpdates();
        for (int i = 0; i < availableUpdates.length; ++i) {
            for (int j = 0; j < appliedUpdates.length; ++j) {
                List dUpdates = availableUpdates[i].getRequiredUpdatesList();
                for (int k = 0; dUpdates != null && k < dUpdates.size(); ++k) {
                    Update update = (Update)dUpdates.get(k);
                    if (!((Object)appliedUpdates[j]).equals(update)) continue;
                    availableUpdates[i].removeRequiredUpdate(update);
                }
            }
        }
    }

    void refreshInstalledUpdates() {
        try {
            Update[] aInstallUpdates = DataController.getInstance().getInstalledUpdates();
            UpdateFrame updateFrame = Application.getInstance().getUpdateFrame();
            InstalledTableModel model = (InstalledTableModel)updateFrame.getInstalledPanel().getTable().getModel();
            model.setUpdates(aInstallUpdates);
            SortedTableHeader header = (SortedTableHeader)updateFrame.getInstalledPanel().getTable().getTableHeader();
            model.sortColumn(header.getSortColumn(), header.getSortDirection());
            model.fireTableDataChanged();
        }
        catch (Throwable throwable) {
            Application.getInstance().getUpdateFrame().showWarningDialog(throwable, this);
        }
    }

    private Update[] getExpandedUpdates(Update[] aUpdate) {
        int i;
        UpdateDelegate updateDelegate = Application.getInstance().getUpdateFrame().getDelegate();
        Dependency[] aDependency = updateDelegate.getInstallDependencies();
        ArrayList<Update> updatesArrayList = new ArrayList<Update>();
        for (i = 0; i < aUpdate.length; ++i) {
            updatesArrayList.add(aUpdate[i]);
        }
        if (aDependency != null && aDependency.length > 0) {
            for (i = 0; i < aDependency.length; ++i) {
                Dependency aDep = aDependency[i];
                for (int j = 0; j < aDep.getDependantsCount(); ++j) {
                    Update update = aDep.getDependant(j);
                    String updateName = update.getName();
                    if (updatesArrayList.contains(update)) continue;
                    updatesArrayList.add(update);
                }
            }
        }
        return updatesArrayList.toArray(new Update[0]);
    }

    private void createComponents() {
        this.installPanel = new InstallPanel(this);
    }

    private void createLayout() {
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.installPanel, "Center");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ Update[] access$202(InstallDialog x0, Update[] x1) {
        x0.aUpdate = x1;
        return x1;
    }

    class InstallWorker
    extends Worker
    implements WorkerListener {
        private Update[] aUpdate;

        InstallWorker() {
            this.addWorkerListener(this);
        }

        public void workStarted(WorkerEvent e) {
        }

        public void workFinished(WorkerEvent e) {
            if (InstallDialog.this.bAuthenticationNeeded) {
                InstallDialog.this.setVisible(false);
                InstallDialog.this.dispose();
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ InstallWorker this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        AuthenticationManager.getInstance().setAction(InstallWorker.access$400(this.this$1).new BeginInstallAction());
                        AuthenticationManager.getInstance().authenticate();
                    }
                });
            }
        }

        public void workInterrupted(WorkerEvent e) {
            InstallDialog.this.getActionSet().getAction("cancel").setEnabled(false);
            InstallDialog.this.getActionSet().removeAction("cancel");
            DataController.getInstance().getInstaller().cancelInstall();
            InstallDialog.this.getInstallPanel().setCancelFlag(true);
            Application.getInstance().getUpdateFrame().createCancelDialogContentPanel(InstallDialog.this);
        }

        void work(Update[] aUpdate) {
            this.aUpdate = aUpdate;
            SwingUtilities.invokeLater(new Runnable(this){
                private final /* synthetic */ InstallWorker this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    InstallWorker.access$500(this.this$1, 0, this);
                }
            });
            this.start();
        }

        public Object construct() {
            Object obj = new Object();
            Installer installer = DataController.getInstance().getInstaller();
            try {
                installer.getMessenger().setPropertyChangeListener(InstallDialog.this.getInstallPanel().getPropertyChangeListener());
                installer.beginInstall(this.aUpdate);
            }
            catch (NotAuthenticatedException e) {
                InstallDialog.this.bAuthenticationNeeded = true;
            }
            catch (Throwable throwable) {
                int code;
                if (throwable instanceof CMDExecutionException && (code = ((CMDExecutionException)throwable).getExitValue()) == 1) {
                    installer.getMessenger().installFinished();
                    return obj;
                }
                throwable.printStackTrace();
            }
            return obj;
        }

        public void finished() {
            this.fireWorkerEvent(1, this);
        }

        static /* synthetic */ InstallDialog access$400(InstallWorker x0) {
            return x0.InstallDialog.this;
        }

        static /* synthetic */ void access$500(InstallWorker x0, int x1, Object x2) {
            x0.fireWorkerEvent(x1, x2);
        }
    }

    class BeginInstallAction
    extends AbstractAction {
        BeginInstallAction() {
        }

        public void actionPerformed(ActionEvent e) {
            InstallDialog.this.bAuthenticationNeeded = false;
            InstallDialog.access$202(InstallDialog.this, Application.getInstance().getUpdateFrame().getDelegate().getInstallUpdates());
            InstallDialog.this.worker = new InstallWorker();
            Update[] expandedUpdates = InstallDialog.this.getExpandedUpdates(InstallDialog.this.aUpdate);
            InstallDialog.this.worker.work(expandedUpdates);
        }
    }

    class CancelAction
    extends GenericAction {
        CancelAction() {
            super(I18N.getString("cancel"));
        }

        public void actionPerformed(ActionEvent e, boolean bInvokedLater) {
            String localizedQuestionMsg = UpdateFrame.I18N.getString("cancel-question");
            String localizedTitle = UpdateFrame.I18N.getString("cancel-title");
            int n = Application.getInstance().getUpdateFrame().showConfirmDialog(Application.getInstance().getUpdateFrame().getDelegate().getInstallDialog(), localizedQuestionMsg, localizedTitle);
            if (n == 0) {
                InstallDialog.this.worker.interrupt();
            }
        }
    }
}

