/*
 * Decompiled with CFR 0.152.
 */
package com.sun.swup.client.ui;

import com.sun.cns.authentication.CMDExecutionException;
import com.sun.cns.authentication.CSMAuthenticator;
import com.sun.swup.client.common.UpdateMgrProperties;
import com.sun.swup.client.common.environment.Environment;
import com.sun.swup.client.interfaces.Uninstaller;
import com.sun.swup.client.interfaces.Update;
import com.sun.swup.client.ui.Application;
import com.sun.swup.client.ui.DataController;
import com.sun.swup.client.ui.Dependency;
import com.sun.swup.client.ui.InstalledTable;
import com.sun.swup.client.ui.InstalledTableModel;
import com.sun.swup.client.ui.UpdateFrame;
import com.sun.swup.client.ui.Utils;
import java.io.File;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JDialog;

class UpdateUtility {
    UpdateUtility() {
    }

    static String getUpdateSizeDisplayString(Integer size) {
        if (size == null) {
            size = new Integer(0);
        }
        if (size < 1000) {
            Object[] aObject = new Object[]{size};
            return Application.I18N.format("bytes", aObject);
        }
        if (size >= 1000 && size < 1000000) {
            int iInteger = size / 100;
            float f = (float)iInteger / 10.0f;
            Object[] aObject = new Object[]{new Float(f)};
            return Application.I18N.format("kilobytes", aObject);
        }
        int iInteger = size / 100000;
        float f = (float)iInteger / 10.0f;
        Object[] aObject = new Object[]{new Float(f)};
        return Application.I18N.format("megabytes", aObject);
    }

    static String getUpdateStatusDisplayString(int iUpdateStatus) {
        switch (iUpdateStatus) {
            case 1: {
                return UpdateFrame.I18N.getString("history-installed");
            }
            case 2: {
                return UpdateFrame.I18N.getString("history-partial-install");
            }
            case 3: {
                return UpdateFrame.I18N.getString("history-install-failed");
            }
            case 4: {
                return UpdateFrame.I18N.getString("history-uninstalled");
            }
            case 6: {
                return UpdateFrame.I18N.getString("history-downloaded");
            }
        }
        return "";
    }

    static ImageIcon getUpdateStatusImageIcon(int iUpdateStatus) {
        switch (iUpdateStatus) {
            case 1: {
                return Environment.getImageIcon((String)"installed.png");
            }
            case 2: {
                return Environment.getImageIcon((String)"partial-install.png");
            }
            case 3: {
                return Environment.getImageIcon((String)"install-failed.png");
            }
            case 4: {
                return Environment.getImageIcon((String)"uninstalled.png");
            }
            case 6: {
                return Environment.getImageIcon((String)"downloaded.png");
            }
        }
        return null;
    }

    static String getUpdateStatusMessage(int iUpdateStatus, Update update) {
        Object[] aObject = new Object[]{update.getName()};
        switch (iUpdateStatus) {
            case 1: {
                return UpdateFrame.I18N.format("history-message-installed", aObject);
            }
            case 2: {
                return UpdateFrame.I18N.format("history-message-partial-install", aObject);
            }
            case 3: {
                return UpdateFrame.I18N.format("history-message-install-failed", aObject);
            }
            case 4: {
                return UpdateFrame.I18N.format("history-message-uninstalled", aObject);
            }
            case 6: {
                return UpdateFrame.I18N.format("history-message-downloaded", aObject);
            }
        }
        return null;
    }

    static Dependency[] getDependencies(Update[] aUpdate) {
        HashMap<String, Dependency> dependencies = new HashMap<String, Dependency>();
        for (int i = 0; i < aUpdate.length; ++i) {
            Update update = aUpdate[i];
            for (int k = 0; k < update.getRequiredUpdateNames().length; ++k) {
                String sUpdateName = update.getRequiredUpdateNames()[k];
                sUpdateName = sUpdateName.trim();
                String sUpdateDesc = update.getDescription();
                sUpdateDesc = sUpdateDesc.trim();
                if (sUpdateName.equals("") || UpdateUtility.isUpdateSelected(sUpdateName, aUpdate)) continue;
                Dependency dependency = (Dependency)dependencies.get(sUpdateName);
                if (dependency == null) {
                    dependency = new Dependency(sUpdateName, sUpdateDesc);
                    dependencies.put(sUpdateName, dependency);
                }
                dependency.addDependant(update);
                dependencies.put(sUpdateName, dependency);
            }
        }
        return dependencies.values().toArray(new Dependency[0]);
    }

    static Dependency[] getDependentUpdates(Update[] aUpdate, int depType) {
        HashMap<String, Dependency> dependencies = new HashMap<String, Dependency>();
        if (depType == 2) {
            UpdateUtility.setUninstallRemoveDependencis(aUpdate);
        }
        for (int i = 0; i < aUpdate.length; ++i) {
            Update update = aUpdate[i];
            String sUpdateName = update.getName();
            String sUpdateDesc = update.getDescription();
            Update[] aUpdates = null;
            aUpdates = depType == 1 ? update.getRequiredUpdates() : update.getRemoveDependency();
            if (aUpdates == null) continue;
            for (int k = 0; k < aUpdates.length; ++k) {
                Update depUpdate = aUpdates[k];
                String depUpdateName = depUpdate.getName();
                if ((depUpdateName = depUpdateName.trim()).equals("") || UpdateUtility.isUpdateSelected(depUpdateName, aUpdate)) continue;
                Dependency dependency = (Dependency)dependencies.get(sUpdateName);
                if (dependency == null) {
                    dependency = new Dependency(sUpdateName, sUpdateDesc);
                    dependencies.put(sUpdateName, dependency);
                }
                dependency.addDependant(depUpdate);
                dependencies.put(sUpdateName, dependency);
            }
        }
        return dependencies.values().toArray(new Dependency[0]);
    }

    private static void setUninstallRemoveDependencis(Update[] aUpdate) {
        Uninstaller uninstaller = DataController.getInstance().getUninstaller();
        InstalledTable iTable = Application.getInstance().getUpdateFrame().getInstalledPanel().getTable();
        InstalledTableModel iTableModel = (InstalledTableModel)iTable.getModel();
        Update[] installedUpdates = iTableModel.getUpdates();
        try {
            Update[] eUpdates = uninstaller.getExpandedUninstallList(aUpdate, installedUpdates);
        }
        catch (CMDExecutionException cee) {
            // empty catch block
        }
    }

    private static boolean isUpdateSelected(String sUpdateName, Update[] aUpdate) {
        boolean bSelected = false;
        for (int i = 0; i < aUpdate.length; ++i) {
            if (!aUpdate[i].getName().equals(sUpdateName)) continue;
            bSelected = true;
            break;
        }
        return bSelected;
    }

    public static void restartSystemNow() {
        try {
            CSMAuthenticator authenticator = CSMAuthenticator.getInstance();
            String restartCommandPropertyVal = UpdateMgrProperties.getInstance().getProperty("SystemRestartCommand");
            String restartCommandName = null;
            String restartCommandPath = null;
            StringTokenizer st = new StringTokenizer(restartCommandPropertyVal);
            int numTokens = st.countTokens();
            Vector<String> args = new Vector<String>();
            for (int i = 0; i < numTokens; ++i) {
                if (i == 0) {
                    restartCommandPath = st.nextToken();
                    File f = new File(restartCommandPath);
                    restartCommandName = f.getName();
                    args.add(restartCommandName);
                    continue;
                }
                args.add(st.nextToken());
            }
            Utils.debug("Rebooting the system now with command:" + restartCommandPath);
            authenticator.runCMD(restartCommandPath, args);
        }
        catch (Throwable throwable) {
            Application.getInstance().getUpdateFrame().showWarningDialog(throwable, new JDialog());
        }
    }
}

